/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.List;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.ValidateConnection;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

public class ConnectorAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.GENERIC || module.getKind() == ModuleKind.CONNECTOR;
    }

    public void verify(Module module) throws AnnotationVerificationException {
        List connectMethods = module.getMethodsAnnotatedWith(Connect.class);
        List validateConnectionMethods = module.getMethodsAnnotatedWith(ValidateConnection.class);
        List disconnectMethods = module.getMethodsAnnotatedWith(Disconnect.class);
        List connectionIdentifierMethods = module.getMethodsAnnotatedWith(ConnectionIdentifier.class);
        if (module.getKind() == ModuleKind.GENERIC) {
            if (!connectMethods.isEmpty()) {
                throw new AnnotationVerificationException((Identifiable)module, "@Connect methods not allowed for @Module classes, use class level annotation @Connector instead");
            }
            if (!validateConnectionMethods.isEmpty()) {
                throw new AnnotationVerificationException((Identifiable)module, "@Connect methods not allowed for @Module classes, use class level annotation @Connector instead");
            }
            if (!disconnectMethods.isEmpty()) {
                throw new AnnotationVerificationException((Identifiable)module, "@Connect methods not allowed for @Module classes, use class level annotation @Connector instead");
            }
            if (!connectionIdentifierMethods.isEmpty()) {
                throw new AnnotationVerificationException((Identifiable)module, "@Connect methods not allowed for @Module classes, use class level annotation @Connector instead");
            }
            return;
        }
        this.checkConnectMethod(module, connectMethods);
        this.checkDisconnetcMethod(module, disconnectMethods);
        this.checkConnectionIdentifierMethod(module, connectionIdentifierMethods);
        this.checkValidateConnectionMethod(module, validateConnectionMethods);
    }

    private void checkConnectMethod(Module module, List<Method<Type>> connectMethods) throws AnnotationVerificationException {
        if (connectMethods.size() > 1) {
            throw new AnnotationVerificationException((Identifiable)module, "You can only have one method annotated with @Connect");
        }
        if (connectMethods.size() > 0) {
            Method<Type> connectMethod = connectMethods.get(0);
            if (!connectMethod.isPublic()) {
                throw new AnnotationVerificationException((Identifiable)module, "A @Connect method must be public.");
            }
            if (connectMethod.getThrownTypes().size() != 1) {
                throw new AnnotationVerificationException((Identifiable)module, "A @Connect method can only throw a single type of exception. That exception must be ConnectionException.");
            }
            if (!connectMethod.getThrownTypes().get(0).toString().equals("org.mule.api.ConnectionException")) {
                throw new AnnotationVerificationException((Identifiable)module, "A @Connect method can only throw a single type of exception. That exception must be ConnectionException.");
            }
            if (!((Object)connectMethod.getReturnType()).toString().equals("void")) {
                throw new AnnotationVerificationException((Identifiable)module, "A @Connect method cannot return anything.");
            }
            this.checkConnectMethodParameters(connectMethod);
        }
    }

    private void checkConnectMethodParameters(Method<Type> method) throws AnnotationVerificationException {
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isReservedIdentifier()) continue;
            throw new AnnotationVerificationException((Identifiable)parameter, "@Connector method cannot contain a parameter identified by '" + parameter.getName() + "'. '" + parameter.getName() + "' is a reserved identifier.");
        }
    }

    private void checkDisconnetcMethod(Module module, List<Method<Type>> disconnectMethods) throws AnnotationVerificationException {
        if (disconnectMethods.size() > 1) {
            throw new AnnotationVerificationException((Identifiable)module, "You can only have one method annotated with @Disconnect");
        }
        if (disconnectMethods.size() > 0) {
            Method<Type> disconnectMethod = disconnectMethods.get(0);
            if (!disconnectMethod.isPublic()) {
                throw new AnnotationVerificationException((Identifiable)module, "A @Disconnect method must be public.");
            }
            if (!disconnectMethod.getParameters().isEmpty()) {
                throw new AnnotationVerificationException((Identifiable)module, "The @Disconnect method cannot receive any arguments");
            }
            if (!((Object)disconnectMethod.getReturnType()).toString().equals("void")) {
                throw new AnnotationVerificationException((Identifiable)module, "A @Disconnect method cannot return anything.");
            }
        }
    }

    private void checkValidateConnectionMethod(Module module, List<Method<Type>> validateConnectionMethods) throws AnnotationVerificationException {
        if (validateConnectionMethods.size() > 1) {
            throw new AnnotationVerificationException((Identifiable)module, "You can only have one method annotated with @ValidateConnection");
        }
        if (validateConnectionMethods.size() > 0) {
            Method<Type> validateConnectionMethod = validateConnectionMethods.get(0);
            if (!validateConnectionMethod.isPublic()) {
                throw new AnnotationVerificationException((Identifiable)module, "A @ValidateConnection method must be public.");
            }
            if (!((Object)validateConnectionMethod.getReturnType()).toString().equals("boolean") && !((Object)validateConnectionMethod.getReturnType()).toString().equals("java.lang.Boolean")) {
                throw new AnnotationVerificationException((Identifiable)module, "A @ValidateConnection method must return a boolean.");
            }
            if (!validateConnectionMethod.getParameters().isEmpty()) {
                throw new AnnotationVerificationException((Identifiable)module, "The @ValidateConnection method cannot receive any arguments");
            }
        }
    }

    private void checkConnectionIdentifierMethod(Module module, List<Method<Type>> connectionIdentifierMethods) throws AnnotationVerificationException {
        if (connectionIdentifierMethods.size() > 1) {
            throw new AnnotationVerificationException((Identifiable)module, "You can only have one method annotated with @ConnectionIdentifier");
        }
        if (connectionIdentifierMethods.size() > 0) {
            Method<Type> connectionIdentifierMethod = connectionIdentifierMethods.get(0);
            if (!((Object)connectionIdentifierMethod.getReturnType()).toString().equals("java.lang.String")) {
                throw new AnnotationVerificationException((Identifiable)module, "A @ConnectionIdentifier must return java.lang.String.");
            }
            if (!connectionIdentifierMethod.isPublic()) {
                throw new AnnotationVerificationException((Identifiable)module, "A @ConnectionIdentifier method must be public.");
            }
            if (connectionIdentifierMethod.isStatic()) {
                throw new AnnotationVerificationException((Identifiable)module, "A @ConnectionIdentifier cannot be static.");
            }
            if (!connectionIdentifierMethod.getParameters().isEmpty()) {
                throw new AnnotationVerificationException((Identifiable)module, "The @ConnectionIdentifier method cannot receive any arguments");
            }
        }
    }
}

