/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import javax.lang.model.type.TypeKind;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.visitor.ModelVisitor;
import org.mule.devkit.model.visitor.VerifyAllClassesAvailableInClasspathVisitor;

public class BasicAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void verify(Module module) throws AnnotationVerificationException {
        if (module.isInterface()) {
            throw new AnnotationVerificationException((Identifiable)module, "@Module/@Connector cannot be applied to an interface");
        }
        if (module.isParametrized()) {
            throw new AnnotationVerificationException((Identifiable)module, "@Module/@Connector type cannot have type parameters");
        }
        if (!module.isPublic()) {
            throw new AnnotationVerificationException((Identifiable)module, "@Module/@Connector must be public");
        }
        for (Field variable : module.getConfigurableFields()) {
            if (variable.isFinal()) {
                throw new AnnotationVerificationException((Identifiable)variable, "@Configurable cannot be applied to field with final modifier");
            }
            if (variable.isStatic()) {
                throw new AnnotationVerificationException((Identifiable)variable, "@Configurable cannot be applied to field with static modifier");
            }
            if (variable.asTypeMirror().getKind() == TypeKind.ARRAY) {
                throw new AnnotationVerificationException((Identifiable)variable, "@Configurable cannot be applied to arrays");
            }
            if (variable.isReservedIdentifier()) {
                throw new AnnotationVerificationException((Identifiable)variable, "@Configurable cannot be applied to field identified by '" + variable.getName() + "'. '" + variable.getName() + "' is a reserved identifier");
            }
            if (!variable.hasGetter()) {
                throw new AnnotationVerificationException((Identifiable)variable, "@Configurable field identified by '" + variable.getName() + "' should have a public getter.");
            }
            if (!variable.hasSetter()) {
                throw new AnnotationVerificationException((Identifiable)variable, "@Configurable field identified by '" + variable.getName() + "' should have a public setter.");
            }
            Optional optional = (Optional)variable.getAnnotation(Optional.class);
            Default def = (Default)variable.getAnnotation(Default.class);
            if (variable.asTypeMirror().getKind().isPrimitive() && optional != null && (def == null || def.value().length() == 0)) {
                throw new AnnotationVerificationException((Identifiable)variable, "@Optional @Configurable fields can only be applied to non-primitive types with a @Default value");
            }
            if (def != null && optional == null) {
                throw new AnnotationVerificationException((Identifiable)variable, "@Default @Configurable fields must also include @Optional, otherwise the @Default will never take place.");
            }
            if (!variable.hasDefaultValue() || !variable.asType().isEnum() || this.isDefaultValueValidForEnum((Variable)variable)) continue;
            throw new AnnotationVerificationException((Identifiable)variable, "@Default value is not valid for this enum, check teh enum declaration");
        }
        this.checkRecursiveAllClassesArePresent(module);
    }

    private void checkRecursiveAllClassesArePresent(Module module) throws AnnotationVerificationException {
        VerifyAllClassesAvailableInClasspathVisitor verifyAllClassesAvailableInClasspathVisitor = new VerifyAllClassesAvailableInClasspathVisitor();
        module.accept((ModelVisitor)verifyAllClassesAvailableInClasspathVisitor);
        if (!verifyAllClassesAvailableInClasspathVisitor.isAllClassesAvailable()) {
            throw new AnnotationVerificationException((Identifiable)module, "The following classes are not available check your build order as they might be generated later from a WSDL or a XSD file: " + verifyAllClassesAvailableInClasspathVisitor.getClassesNotAvailable());
        }
    }

    private boolean isDefaultValueValidForEnum(Variable variable) {
        for (Identifiable enumMember : ((EnumType)variable.asType()).getEnumConstants()) {
            String enumConstant = enumMember.getName();
            if (!variable.getDefaultValue().equals(enumConstant)) continue;
            return true;
        }
        return false;
    }
}

