/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.callback.HttpCallback;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.TransformerMethod;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.Annotation;
import org.mule.devkit.model.schema.Any;
import org.mule.devkit.model.schema.Attribute;
import org.mule.devkit.model.schema.ComplexContent;
import org.mule.devkit.model.schema.Documentation;
import org.mule.devkit.model.schema.ExplicitGroup;
import org.mule.devkit.model.schema.ExtensionType;
import org.mule.devkit.model.schema.FormChoice;
import org.mule.devkit.model.schema.GroupRef;
import org.mule.devkit.model.schema.Import;
import org.mule.devkit.model.schema.LocalComplexType;
import org.mule.devkit.model.schema.LocalSimpleType;
import org.mule.devkit.model.schema.NoFixedFacet;
import org.mule.devkit.model.schema.NumFacet;
import org.mule.devkit.model.schema.ObjectFactory;
import org.mule.devkit.model.schema.Restriction;
import org.mule.devkit.model.schema.Schema;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.model.schema.SimpleContent;
import org.mule.devkit.model.schema.SimpleExtensionType;
import org.mule.devkit.model.schema.TopLevelComplexType;
import org.mule.devkit.model.schema.TopLevelElement;
import org.mule.devkit.model.schema.TopLevelSimpleType;
import org.mule.devkit.model.schema.Union;
import org.mule.util.StringUtils;

public class SchemaBuilder {
    private Set<EnumType> registeredEnums = new HashSet<EnumType>();
    private Set<Type> registeredComplexTypes = new HashSet<Type>();
    private Set<String> registeredMethods = new HashSet<String>();
    private Schema schema;
    private ObjectFactory objectFactory = new ObjectFactory();

    private SchemaBuilder() {
    }

    public static SchemaBuilder newSchema(String targetNamespace) {
        SchemaBuilder builder = new SchemaBuilder();
        builder.schema = new Schema();
        builder.schema.setTargetNamespace(targetNamespace);
        builder.schema.setElementFormDefault(FormChoice.QUALIFIED);
        builder.schema.setAttributeFormDefault(FormChoice.UNQUALIFIED);
        return builder;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public SchemaBuilder importXmlNamespace() {
        Import xmlImport = new Import();
        xmlImport.setNamespace("http://www.w3.org/XML/1998/namespace");
        this.schema.getIncludeOrImportOrRedefine().add(xmlImport);
        return this;
    }

    public SchemaBuilder importSpringFrameworkNamespace() {
        Import springFrameworkImport = new Import();
        springFrameworkImport.setNamespace("http://www.springframework.org/schema/beans");
        springFrameworkImport.setSchemaLocation("http://www.springframework.org/schema/beans/spring-beans-3.0.xsd");
        this.schema.getIncludeOrImportOrRedefine().add(springFrameworkImport);
        return this;
    }

    public SchemaBuilder importMuleNamespace() {
        Import muleSchemaImport = new Import();
        muleSchemaImport.setNamespace("http://www.mulesoft.org/schema/mule/core");
        muleSchemaImport.setSchemaLocation("http://www.mulesoft.org/schema/mule/core/current/mule.xsd");
        this.schema.getIncludeOrImportOrRedefine().add(muleSchemaImport);
        return this;
    }

    public Schema registerSimpleTypes() {
        this.registerType(this.schema, "integerType", SchemaConstants.INTEGER);
        this.registerType(this.schema, "decimalType", SchemaConstants.DECIMAL);
        this.registerType(this.schema, "floatType", SchemaConstants.FLOAT);
        this.registerType(this.schema, "doubleType", SchemaConstants.DOUBLE);
        this.registerType(this.schema, "dateTimeType", SchemaConstants.DATETIME);
        this.registerType(this.schema, "longType", SchemaConstants.LONG);
        this.registerType(this.schema, "byteType", SchemaConstants.BYTE);
        this.registerType(this.schema, "booleanType", SchemaConstants.BOOLEAN);
        this.registerType(this.schema, "anyUriType", SchemaConstants.ANYURI);
        this.registerType(this.schema, "charType", SchemaConstants.STRING, 1, 1);
        return this.schema;
    }

    private void registerType(Schema schema, String name, QName base) {
        this.registerType(schema, name, base, -1, -1);
    }

    private void registerType(Schema schema, String name, QName base, int minlen, int maxlen) {
        TopLevelSimpleType simpleType = new TopLevelSimpleType();
        simpleType.setName(name);
        Union union = new Union();
        simpleType.setUnion(union);
        union.getSimpleType().add(this.createSimpleType(base, minlen, maxlen));
        union.getSimpleType().add(this.createExpressionAndPropertyPlaceHolderSimpleType());
        schema.getSimpleTypeOrComplexTypeOrGroup().add(simpleType);
    }

    private LocalSimpleType createSimpleType(QName base, int minlen, int maxlen) {
        JAXBElement element;
        LocalSimpleType simpleType = new LocalSimpleType();
        Restriction restriction = new Restriction();
        restriction.setBase(base);
        if (minlen != -1) {
            NumFacet minLenFacet = new NumFacet();
            minLenFacet.setValue(Integer.toString(minlen));
            element = this.objectFactory.createMinLength(minLenFacet);
            restriction.getFacets().add(element);
        }
        if (maxlen != -1) {
            NumFacet maxLenFacet = new NumFacet();
            maxLenFacet.setValue(Integer.toString(maxlen));
            element = this.objectFactory.createMaxLength(maxLenFacet);
            restriction.getFacets().add(element);
        }
        simpleType.setRestriction(restriction);
        return simpleType;
    }

    public SchemaBuilder registerConfigElement(Module module, GeneratedClass moduleClass) {
        TopLevelElement poolingProfile;
        HashMap<QName, String> otherAttributes = new HashMap<QName, String>();
        otherAttributes.put(SchemaConstants.MULE_DEVKIT_JAVA_CLASS_TYPE, moduleClass.fullName());
        ExtensionType config = this.registerExtension(module.getConfigElementName(), otherAttributes);
        Attribute nameAttribute = this.createAttribute("name", true, SchemaConstants.STRING, "Give a name to this configuration so it can be later referenced by config-ref.");
        config.getAttributeOrAttributeGroup().add(nameAttribute);
        ExplicitGroup all = new ExplicitGroup();
        config.setSequence(all);
        for (Field variable : module.getConfigurableFields()) {
            if (variable.asType().isCollection()) {
                this.generateCollectionElement(all, (Variable)variable, false);
                continue;
            }
            if (variable.asType().isComplexType()) {
                this.registerComplexTypeChildElement(all, (Variable)variable, true);
                continue;
            }
            config.getAttributeOrAttributeGroup().add(this.createAttribute((Variable)variable, false));
        }
        for (Field variable : module.getInjectFields()) {
            if (!((Object)variable.asTypeMirror()).toString().equals("org.mule.api.store.ObjectStore")) continue;
            config.getAttributeOrAttributeGroup().add(this.createAttribute("objectStore-ref", true, SchemaConstants.STRING, variable.getJavaDocSummary()));
        }
        if (module instanceof ManagedConnectionModule) {
            for (Parameter parameter : ((ManagedConnectionModule)module).getConnectMethod().getParameters()) {
                if (parameter.asType().isCollection()) {
                    this.generateCollectionElement(all, (Variable)parameter, true);
                    continue;
                }
                config.getAttributeOrAttributeGroup().add(this.createParameterAttribute((Variable)parameter, true));
            }
            poolingProfile = new TopLevelElement();
            poolingProfile.setName("connection-pooling-profile");
            poolingProfile.setType(SchemaConstants.MULE_POOLING_PROFILE_TYPE);
            poolingProfile.setMinOccurs(BigInteger.ZERO);
            poolingProfile.setAnnotation(this.createDocAnnotation("Characteristics of the connection pool."));
            all.getParticle().add(this.objectFactory.createElement(poolingProfile));
            TopLevelElement abstractReconnectStrategy = new TopLevelElement();
            abstractReconnectStrategy.setRef(SchemaConstants.MULE_ABSTRACT_RECONNECTION_STRATEGY);
            abstractReconnectStrategy.setMinOccurs(BigInteger.ZERO);
            abstractReconnectStrategy.setAnnotation(this.createDocAnnotation("Reconnection strategy that defines how Mule should handle a connection failure."));
            all.getParticle().add(this.objectFactory.createElement(abstractReconnectStrategy));
        }
        if (module instanceof OAuthModule) {
            this.generateHttpCallbackElement("oauth-callback-config", all);
            if (((OAuthModule)module).getUserIdentifierMethod() == null) {
                this.generateOauthAccessTokenElement("oauth-save-access-token", "A chain of message processors processed synchronously that can be used to save OAuth state. They will be executed once the connector acquires an OAuth access token.", all);
                this.generateOauthAccessTokenElement("oauth-restore-access-token", "A chain of message processors processed synchronously that can be used to restore OAuth state. They will be executed whenever access to a protected resource is requested and the connector is not authorized yet.", all);
            } else {
                this.generateOAuthStoreConfigElement(all);
            }
            Attribute accessTokenUrlAttribute = this.createAttribute("accessTokenUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider to obtain an access token", ((OAuthModule)module).getAccessTokenUrl());
            config.getAttributeOrAttributeGroup().add(accessTokenUrlAttribute);
            Attribute authorizationUrlAttribute = this.createAttribute("authorizationUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider where the resource owner will be redirected to grant authorization to the connector", ((OAuthModule)module).getAuthorizationUrl());
            config.getAttributeOrAttributeGroup().add(authorizationUrlAttribute);
            if (((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A) {
                Attribute requestTokenUrlAttribute = this.createAttribute("requestTokenUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider used to obtain an un-authorized request token", ((OAuthModule)module).getRequestTokenUrl());
                config.getAttributeOrAttributeGroup().add(requestTokenUrlAttribute);
            }
        }
        if (module.hasProcessorMethodWithParameter(HttpCallback.class)) {
            this.generateHttpCallbackElement("http-callback-config", all);
        }
        if (module.usesPooling()) {
            poolingProfile = new TopLevelElement();
            poolingProfile.setName("pooling-profile");
            poolingProfile.setType(SchemaConstants.MULE_POOLING_PROFILE_TYPE);
            poolingProfile.setMinOccurs(BigInteger.ZERO);
            poolingProfile.setAnnotation(this.createDocAnnotation("Characteristics of the object pool."));
            all.getParticle().add(this.objectFactory.createElement(poolingProfile));
        }
        config.setAnnotation(this.createDocAnnotation(module.getJavaDocSummary()));
        if (all.getParticle().size() == 0) {
            config.setSequence(null);
        }
        return this;
    }

    public SchemaBuilder registerProcessorsAndSources(Module module) {
        String typeName;
        String name;
        if (module instanceof OAuthModule) {
            this.registerProcessorElement(false, "authorize", "AuthorizeType", "Starts OAuth authorization process. It must be called from a flow with an http:inbound-endpoint.");
            this.registerProcessorElement(false, "unauthorize", "UnauthorizeType", "Unauthorizes the connector, forcing to re-use authorize again before accessing any protected message processor.");
            this.registerAuthorizeType(module);
            this.registerUnauthorizeType((OAuthModule)module);
        }
        for (ProcessorMethod method : module.getProcessorMethods()) {
            name = method.getName();
            Processor processor = (Processor)method.getAnnotation(Processor.class);
            if (processor.name().length() > 0) {
                name = processor.name();
            }
            if (this.registeredMethods.contains(name)) continue;
            this.registeredMethods.add(name);
            typeName = StringUtils.capitalize((String)name) + "Type";
            this.registerProcessorElement(method.isIntercepting(), name, typeName, method.getJavaDocSummary());
            this.registerProcessorType(method.isIntercepting(), typeName, (Method)method);
        }
        for (ProcessorMethod method : module.getSourceMethods()) {
            name = method.getName();
            Source source = (Source)method.getAnnotation(Source.class);
            if (source.name().length() > 0) {
                name = source.name();
            }
            if (this.registeredMethods.contains(name)) continue;
            this.registeredMethods.add(name);
            typeName = StringUtils.capitalize((String)name) + "Type";
            this.registerSourceElement(name, typeName, (Method)method);
            this.registerExtendedType(SchemaConstants.MULE_ABSTRACT_INBOUND_ENDPOINT_TYPE, typeName, (Method<? extends Type>)method);
        }
        return this;
    }

    public SchemaBuilder registerTransformers(Module module) {
        for (TransformerMethod method : module.getTransformerMethods()) {
            TopLevelElement transformerElement = new TopLevelElement();
            transformerElement.setName(NameUtils.uncamel((String)method.getName()));
            transformerElement.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_TRANSFORMER);
            transformerElement.setType(SchemaConstants.MULE_ABSTRACT_TRANSFORMER_TYPE);
            this.schema.getSimpleTypeOrComplexTypeOrGroup().add(transformerElement);
        }
        return this;
    }

    private void registerComplexType(Type type) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName(type.getName() + "ObjectType");
        ExplicitGroup all = new ExplicitGroup();
        complexType.setSequence(all);
        for (Field field : type.getFields()) {
            if (this.skipField(field)) continue;
            if (field.asType().isCollection()) {
                this.generateCollectionElement(all, (Variable)field, true);
                continue;
            }
            if (this.generateNestedProcessor(field)) {
                this.generateNestedProcessorElement(all, (Variable)field);
                continue;
            }
            if (field.isText()) {
                this.createParameterElement(all, (Variable)field);
                continue;
            }
            if (field.asType().isComplexType()) {
                this.registerComplexTypeChildElement(all, (Variable)field, true);
                continue;
            }
            complexType.getAttributeOrAttributeGroup().add(this.createAttribute((Variable)field, true));
        }
        Attribute ref = this.createAttribute("ref", true, SchemaConstants.STRING, "The reference object for this parameter");
        complexType.getAttributeOrAttributeGroup().add(ref);
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(complexType);
    }

    public SchemaBuilder registerEnums() {
        for (EnumType enumToBeRegistered : this.registeredEnums) {
            this.registerEnum(this.schema, enumToBeRegistered);
        }
        return this;
    }

    private void registerEnum(Schema schema, EnumType enumType) {
        TopLevelSimpleType enumSimpleType = new TopLevelSimpleType();
        enumSimpleType.setName(enumType.getName() + "EnumType");
        enumSimpleType.setAnnotation(this.createDocAnnotation(enumType.getJavaDocSummary()));
        Union union = new Union();
        union.getSimpleType().add(this.createEnumSimpleType(enumType));
        union.getSimpleType().add(this.createExpressionAndPropertyPlaceHolderSimpleType());
        enumSimpleType.setUnion(union);
        schema.getSimpleTypeOrComplexTypeOrGroup().add(enumSimpleType);
    }

    private LocalSimpleType createExpressionAndPropertyPlaceHolderSimpleType() {
        LocalSimpleType expression = new LocalSimpleType();
        Restriction restriction = new Restriction();
        expression.setRestriction(restriction);
        restriction.setBase(SchemaConstants.MULE_PROPERTY_PLACEHOLDER_TYPE);
        return expression;
    }

    private LocalSimpleType createEnumSimpleType(EnumType enumType) {
        LocalSimpleType enumValues = new LocalSimpleType();
        Restriction restriction = new Restriction();
        enumValues.setRestriction(restriction);
        restriction.setBase(SchemaConstants.STRING);
        for (Identifiable identifiable : enumType.getEnumConstants()) {
            NoFixedFacet noFixedFacet = this.objectFactory.createNoFixedFacet();
            noFixedFacet.setValue(identifiable.getName());
            noFixedFacet.setAnnotation(this.createDocAnnotation(identifiable.getJavaDocSummary()));
            JAXBElement enumeration = this.objectFactory.createEnumeration(noFixedFacet);
            enumValues.getRestriction().getFacets().add(enumeration);
        }
        return enumValues;
    }

    private void registerComplexTypeChildElement(ExplicitGroup all, Variable variable, boolean forceOptional) {
        LocalComplexType objectComplexType = new LocalComplexType();
        objectComplexType.setComplexContent(new ComplexContent());
        objectComplexType.getComplexContent().setExtension(new ExtensionType());
        objectComplexType.getComplexContent().getExtension().setBase(new QName(this.schema.getTargetNamespace(), variable.asType().getName() + "ObjectType"));
        TopLevelElement objectElement = new TopLevelElement();
        objectElement.setName(NameUtils.uncamel((String)variable.getName()));
        objectElement.setMinOccurs(!forceOptional && !variable.isOptional() ? BigInteger.ONE : BigInteger.ZERO);
        objectElement.setMaxOccurs("1");
        objectElement.setComplexType(objectComplexType);
        objectElement.setAnnotation(this.createDocAnnotation(variable.parent().getJavaDocParameterSummary(variable.getName())));
        all.getParticle().add(this.objectFactory.createElement(objectElement));
        if (!this.registeredComplexTypes.contains(variable.asType())) {
            this.registeredComplexTypes.add(variable.asType());
            this.registerComplexType(variable.asType());
        }
    }

    private ExtensionType registerExtension(String name, Map<QName, String> otherAttributes) {
        LocalComplexType complexType = new LocalComplexType();
        TopLevelElement extension = new TopLevelElement();
        extension.setName(name);
        extension.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_EXTENSION);
        extension.setComplexType(complexType);
        extension.getOtherAttributes().putAll(otherAttributes);
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE);
        complexContent.setExtension(complexContentExtension);
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(extension);
        return complexContentExtension;
    }

    private Attribute createAttribute(Variable variable, boolean forceOptional) {
        return this.createAttribute(variable, forceOptional, false);
    }

    private Attribute createParameterAttribute(Variable variable, boolean forceOptional) {
        return this.createAttribute(variable, forceOptional, true);
    }

    private Attribute createAttribute(Variable variable, boolean forceOptional, boolean isParameter) {
        Named named = (Named)variable.getAnnotation(Named.class);
        String name = variable.getName();
        if (named != null && named.value().length() > 0) {
            name = named.value();
        }
        Attribute attribute = new Attribute();
        String optional = "optional";
        if (!forceOptional && !variable.isOptional()) {
            optional = "required";
        }
        attribute.setUse(optional);
        if (this.isTypeSupported(variable.asTypeMirror())) {
            attribute.setName(name);
            attribute.setType(SchemaTypeConversion.convertType((String)this.schema.getTargetNamespace(), (String)((Object)variable.asTypeMirror()).toString()));
        } else if (variable.asType().isEnum()) {
            attribute.setName(name);
            attribute.setType(new QName(this.schema.getTargetNamespace(), variable.asType().getName() + "EnumType"));
            this.registeredEnums.add((EnumType)variable.asType());
        } else if (isParameter && variable.asType().isHttpCallback()) {
            attribute.setName(NameUtils.uncamel((String)name) + "-flow-ref");
            attribute.setType(SchemaConstants.STRING);
        } else {
            attribute.setName(name + "-ref");
            attribute.setType(SchemaConstants.STRING);
        }
        String doc = isParameter ? variable.parent().getJavaDocParameterSummary(variable.getName()) : variable.getJavaDocSummary();
        attribute.setAnnotation(this.createDocAnnotation(doc));
        if (variable.hasDefaultValue()) {
            attribute.setDefault(variable.getDefaultValue());
        }
        return attribute;
    }

    private void generateCollectionElement(ExplicitGroup all, Variable variable, boolean forceOptional) {
        String name = NameUtils.uncamel((String)variable.getName());
        BigInteger minOccurs = BigInteger.ZERO;
        if (!forceOptional && !variable.isOptional()) {
            minOccurs = BigInteger.ONE;
        }
        String collectionName = NameUtils.uncamel((String)NameUtils.singularize((String)name));
        LocalComplexType collectionComplexType = this.generateCollectionComplexType(collectionName, (Identifiable)variable);
        TopLevelElement collectionElement = new TopLevelElement();
        collectionElement.setName(name);
        collectionElement.setMinOccurs(minOccurs);
        collectionElement.setMaxOccurs("1");
        collectionElement.setAnnotation(this.createDocAnnotation(variable.parent().getJavaDocParameterSummary(variable.getName())));
        all.getParticle().add(this.objectFactory.createElement(collectionElement));
        collectionElement.setComplexType(collectionComplexType);
    }

    private LocalComplexType generateCollectionComplexType(String name, Identifiable type) {
        LocalComplexType collectionComplexType = new LocalComplexType();
        ExplicitGroup sequence = new ExplicitGroup();
        ExplicitGroup choice = new ExplicitGroup();
        if (type.asType().isMap()) {
            collectionComplexType.setChoice(choice);
            choice.getParticle().add(this.objectFactory.createSequence(sequence));
            Any any = new Any();
            any.setProcessContents("lax");
            any.setMinOccurs(new BigInteger("0"));
            any.setMaxOccurs("unbounded");
            ExplicitGroup anySequence = new ExplicitGroup();
            anySequence.getParticle().add(any);
            choice.getParticle().add(this.objectFactory.createSequence(anySequence));
        } else if (type.asType().isArrayOrList()) {
            collectionComplexType.setSequence(sequence);
        }
        TopLevelElement collectionItemElement = new TopLevelElement();
        collectionItemElement.setName(name);
        collectionItemElement.setMinOccurs(BigInteger.ZERO);
        collectionItemElement.setMaxOccurs("unbounded");
        collectionItemElement.setComplexType(this.generateComplexType(name, type));
        sequence.getParticle().add(this.objectFactory.createElement(collectionItemElement));
        Attribute ref = this.createAttribute("ref", true, SchemaConstants.STRING, "The reference object for this parameter");
        collectionComplexType.getAttributeOrAttributeGroup().add(ref);
        return collectionComplexType;
    }

    private LocalComplexType generateComplexType(String name, Identifiable typeMirror) {
        if (typeMirror.asType().isArrayOrList()) {
            List variableTypeParameters = typeMirror.getTypeArguments();
            if (variableTypeParameters.size() != 0 && variableTypeParameters.get(0) != null) {
                Type genericType = (Type)variableTypeParameters.get(0);
                if (this.isTypeSupported(genericType.asTypeMirror())) {
                    return this.generateComplexTypeWithRef((Identifiable)genericType);
                }
                if (genericType.isArrayOrList() || genericType.isMap()) {
                    return this.generateCollectionComplexType("inner-" + name, (Identifiable)genericType);
                }
                if (genericType.isEnum()) {
                    return this.generateEnumComplexType((Identifiable)genericType);
                }
                return this.generateExtendedRefComplexType(genericType, "value-ref");
            }
            return this.generateRefComplexType("value-ref");
        }
        if (typeMirror.asType().isMap()) {
            List variableTypeParameters = typeMirror.getTypeArguments();
            LocalComplexType mapComplexType = new LocalComplexType();
            Attribute keyAttribute = new Attribute();
            if (variableTypeParameters.size() > 0 && this.isTypeSupported(((Type)variableTypeParameters.get(0)).asTypeMirror())) {
                keyAttribute.setName("key");
                keyAttribute.setType(SchemaTypeConversion.convertType((String)this.schema.getTargetNamespace(), (String)((Object)((Type)variableTypeParameters.get(0)).asTypeMirror()).toString()));
            } else if (variableTypeParameters.size() > 0 && ((Type)variableTypeParameters.get(0)).isEnum()) {
                keyAttribute.setName("key");
                keyAttribute.setType(new QName(this.schema.getTargetNamespace(), ((Type)variableTypeParameters.get(0)).getName() + "EnumType"));
                this.registeredEnums.add((EnumType)((Type)variableTypeParameters.get(0)).asType());
            } else {
                keyAttribute.setUse("required");
                keyAttribute.setName("key-ref");
                keyAttribute.setType(SchemaConstants.STRING);
            }
            QName baseType = variableTypeParameters.size() > 1 && this.isTypeSupported(((Type)variableTypeParameters.get(1)).asTypeMirror()) ? SchemaTypeConversion.convertType((String)this.schema.getTargetNamespace(), (String)((Object)((Type)variableTypeParameters.get(1)).asTypeMirror()).toString()) : new QName("http://www.w3.org/2001/XMLSchema", "string", "xs");
            SimpleContent simpleContent = new SimpleContent();
            mapComplexType.setSimpleContent(simpleContent);
            SimpleExtensionType complexContentExtension = new SimpleExtensionType();
            complexContentExtension.setBase(baseType);
            simpleContent.setExtension(complexContentExtension);
            Attribute refAttribute = this.createAttribute("value-ref", true, SchemaConstants.STRING, null);
            complexContentExtension.getAttributeOrAttributeGroup().add(refAttribute);
            complexContentExtension.getAttributeOrAttributeGroup().add(keyAttribute);
            return mapComplexType;
        }
        return null;
    }

    private LocalComplexType generateEnumComplexType(Identifiable genericType) {
        LocalComplexType complexType = new LocalComplexType();
        SimpleContent simpleContent = new SimpleContent();
        complexType.setSimpleContent(simpleContent);
        SimpleExtensionType simpleContentExtension = new SimpleExtensionType();
        simpleContentExtension.setBase(new QName(this.schema.getTargetNamespace(), genericType.getName() + "EnumType"));
        simpleContent.setExtension(simpleContentExtension);
        this.registeredEnums.add((EnumType)genericType.asType());
        return complexType;
    }

    private LocalComplexType generateComplexTypeWithRef(Identifiable genericType) {
        LocalComplexType complexType = new LocalComplexType();
        SimpleContent simpleContent = new SimpleContent();
        complexType.setSimpleContent(simpleContent);
        SimpleExtensionType simpleContentExtension = new SimpleExtensionType();
        QName extensionBase = SchemaTypeConversion.convertType((String)this.schema.getTargetNamespace(), (String)((Object)genericType.asTypeMirror()).toString());
        simpleContentExtension.setBase(extensionBase);
        simpleContent.setExtension(simpleContentExtension);
        Attribute refAttribute = this.createAttribute("value-ref", true, SchemaConstants.STRING, null);
        simpleContentExtension.getAttributeOrAttributeGroup().add(refAttribute);
        return complexType;
    }

    private LocalComplexType generateExtendedRefComplexType(Type type, String name) {
        LocalComplexType itemComplexType = new LocalComplexType();
        itemComplexType.setComplexContent(new ComplexContent());
        itemComplexType.getComplexContent().setExtension(new ExtensionType());
        itemComplexType.getComplexContent().getExtension().setBase(new QName(this.schema.getTargetNamespace(), type.getName() + "ObjectType"));
        if (!this.registeredComplexTypes.contains(type)) {
            this.registeredComplexTypes.add(type);
            this.registerComplexType(type);
        }
        Attribute refAttribute = this.createAttribute(name, true, SchemaConstants.STRING, null);
        itemComplexType.getComplexContent().getExtension().getAttributeOrAttributeGroup().add(refAttribute);
        return itemComplexType;
    }

    private void generateHttpCallbackElement(String elementName, ExplicitGroup all) {
        Attribute domainAttribute = this.createAttribute("domain", true, SchemaConstants.STRING, null);
        Attribute localPortAttribute = this.createAttribute("localPort", true, SchemaConstants.STRING, null);
        Attribute remotePortAttribute = this.createAttribute("remotePort", true, SchemaConstants.STRING, null);
        Attribute asyncAttribute = this.createAttribute("async", true, SchemaConstants.BOOLEAN, null);
        asyncAttribute.setDefault("false");
        Attribute pathAttribute = this.createAttribute("path", true, SchemaConstants.STRING, null);
        Attribute connectorRefAttribute = this.createAttribute("connector-ref", true, SchemaConstants.STRING, null);
        TopLevelElement httpCallbackConfig = new TopLevelElement();
        httpCallbackConfig.setName(elementName);
        httpCallbackConfig.setMinOccurs(BigInteger.ONE);
        httpCallbackConfig.setMaxOccurs("1");
        httpCallbackConfig.setAnnotation(this.createDocAnnotation("Config for http callbacks."));
        ExtensionType extensionType = new ExtensionType();
        extensionType.setBase(SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE);
        extensionType.getAttributeOrAttributeGroup().add(localPortAttribute);
        extensionType.getAttributeOrAttributeGroup().add(remotePortAttribute);
        extensionType.getAttributeOrAttributeGroup().add(domainAttribute);
        extensionType.getAttributeOrAttributeGroup().add(asyncAttribute);
        extensionType.getAttributeOrAttributeGroup().add(pathAttribute);
        extensionType.getAttributeOrAttributeGroup().add(connectorRefAttribute);
        ComplexContent complexContent = new ComplexContent();
        complexContent.setExtension(extensionType);
        LocalComplexType localComplexType = new LocalComplexType();
        localComplexType.setComplexContent(complexContent);
        httpCallbackConfig.setComplexType(localComplexType);
        all.getParticle().add(this.objectFactory.createElement(httpCallbackConfig));
    }

    private LocalComplexType generateRefComplexType(String name) {
        LocalComplexType itemComplexType = new LocalComplexType();
        Attribute refAttribute = this.createAttribute(name, false, SchemaConstants.STRING, null);
        itemComplexType.getAttributeOrAttributeGroup().add(refAttribute);
        return itemComplexType;
    }

    private void generateOAuthStoreConfigElement(ExplicitGroup all) {
        Attribute objectStoreRefAttribute = new Attribute();
        objectStoreRefAttribute.setUse("required");
        objectStoreRefAttribute.setName("objectStore-ref");
        objectStoreRefAttribute.setType(SchemaConstants.STRING);
        ExtensionType extensionType = new ExtensionType();
        extensionType.setBase(SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE);
        extensionType.getAttributeOrAttributeGroup().add(objectStoreRefAttribute);
        ComplexContent complexContent = new ComplexContent();
        complexContent.setExtension(extensionType);
        LocalComplexType localComplexType = new LocalComplexType();
        localComplexType.setComplexContent(complexContent);
        TopLevelElement collectionElement = new TopLevelElement();
        collectionElement.setName("oauth-store-config");
        collectionElement.setMinOccurs(BigInteger.ZERO);
        collectionElement.setMaxOccurs("1");
        collectionElement.setComplexType(localComplexType);
        collectionElement.setAnnotation(this.createDocAnnotation("Configuration element for storage of access tokens"));
        all.getParticle().add(this.objectFactory.createElement(collectionElement));
    }

    private void generateOauthAccessTokenElement(String name, String docDescription, ExplicitGroup all) {
        LocalComplexType collectionComplexType = new LocalComplexType();
        GroupRef group = this.generateNestedProcessorGroup();
        collectionComplexType.setGroup(group);
        TopLevelElement collectionElement = new TopLevelElement();
        collectionElement.setName(name);
        collectionElement.setMinOccurs(BigInteger.ZERO);
        collectionElement.setMaxOccurs("1");
        collectionElement.setComplexType(collectionComplexType);
        collectionElement.setAnnotation(this.createDocAnnotation(docDescription));
        all.getParticle().add(this.objectFactory.createElement(collectionElement));
    }

    private void registerProcessorElement(boolean intercepting, String name, String typeName, String docText) {
        TopLevelElement element = new TopLevelElement();
        element.setName(NameUtils.uncamel((String)name));
        element.setType(new QName(this.schema.getTargetNamespace(), typeName));
        element.setAnnotation(this.createDocAnnotation(docText));
        element.setSubstitutionGroup(intercepting ? SchemaConstants.MULE_ABSTRACT_INTERCEPTING_MESSAGE_PROCESSOR : SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR);
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(element);
    }

    private void registerSourceElement(String name, String typeName, Method executableElement) {
        TopLevelElement element = new TopLevelElement();
        element.setName(NameUtils.uncamel((String)name));
        element.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_INBOUND_ENDPOINT);
        element.setType(new QName(this.schema.getTargetNamespace(), typeName));
        element.setAnnotation(this.createDocAnnotation(executableElement.getJavaDocSummary()));
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(element);
    }

    private void registerAuthorizeType(Module module) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName("AuthorizeType");
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR_TYPE);
        complexContent.setExtension(complexContentExtension);
        Attribute configRefAttr = this.createAttribute("config-ref", true, SchemaConstants.STRING, "Specify which configuration to use for this invocation.");
        complexContentExtension.getAttributeOrAttributeGroup().add(configRefAttr);
        ExplicitGroup all = new ExplicitGroup();
        complexContentExtension.setSequence(all);
        if (module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V2) {
            complexContentExtension.getAttributeOrAttributeGroup().add(this.createAttribute("state", true, new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"), "Any value that you wish to be sent with the callback"));
        }
        if (((OAuthModule)module).getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : ((OAuthModule)module).getAuthorizationParameters()) {
                if (!this.isTypeSupported(parameter.getType().asTypeMirror()) && !parameter.getType().isEnum()) continue;
                complexContentExtension.getAttributeOrAttributeGroup().add(this.createTypeAttribute(parameter.getName(), parameter.getType(), parameter.isOptional(), parameter.getDefaultValue()));
            }
        }
        Attribute accessTokenUrlAttribute = this.createAttribute("accessTokenUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider to obtain an access token");
        complexContentExtension.getAttributeOrAttributeGroup().add(accessTokenUrlAttribute);
        Attribute authorizationUrlAttribute = this.createAttribute("authorizationUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider where the resource owner will be redirected to grant authorization to the connector");
        complexContentExtension.getAttributeOrAttributeGroup().add(authorizationUrlAttribute);
        if (((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A) {
            Attribute requestTokenUrlAttribute = this.createAttribute("requestTokenUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider used to obtain an un-authorized request token");
            complexContentExtension.getAttributeOrAttributeGroup().add(requestTokenUrlAttribute);
        }
        if (all.getParticle().size() == 0) {
            complexContentExtension.setSequence(null);
        }
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(complexType);
    }

    private Attribute createTypeAttribute(String name, Type type, boolean isOptional, String defaultValue) {
        Attribute attribute = new Attribute();
        attribute.setUse(isOptional ? "optional" : "required");
        if (this.isTypeSupported(type.asTypeMirror())) {
            attribute.setName(name);
            attribute.setType(SchemaTypeConversion.convertType((String)this.schema.getTargetNamespace(), (String)((Object)type.asTypeMirror()).toString()));
        } else if (type.isEnum()) {
            attribute.setName(name);
            attribute.setType(new QName(this.schema.getTargetNamespace(), type.asType().getName() + "EnumType"));
            this.registeredEnums.add((EnumType)type.asType());
        }
        attribute.setAnnotation(this.createDocAnnotation(type.getJavaDocSummary()));
        if (StringUtils.isNotBlank((String)defaultValue)) {
            attribute.setDefault(defaultValue);
        }
        return attribute;
    }

    private void registerProcessorType(boolean intercepting, String name, Method element) {
        if (intercepting) {
            this.registerExtendedType(SchemaConstants.MULE_ABSTRACT_INTERCEPTING_MESSAGE_PROCESSOR_TYPE, name, (Method<? extends Type>)element);
        } else {
            this.registerExtendedType(SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR_TYPE, name, (Method<? extends Type>)element);
        }
    }

    private void registerExtendedType(QName base, String name, Method<? extends Type> element) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName(name);
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(base);
        complexContent.setExtension(complexContentExtension);
        boolean optionalConfig = true;
        if (!(element.parent() instanceof Module)) {
            optionalConfig = false;
        }
        Attribute configRefAttr = this.createAttribute("config-ref", optionalConfig, SchemaConstants.STRING, "Specify which configuration to use for this invocation.");
        complexContentExtension.getAttributeOrAttributeGroup().add(configRefAttr);
        ExplicitGroup all = new ExplicitGroup();
        complexContentExtension.setSequence(all);
        if (element != null) {
            ConnectMethod connectMethod;
            int requiredChildElements = 0;
            for (Parameter variable : element.getParameters()) {
                if (variable.shouldBeIgnored()) continue;
                if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
                    ++requiredChildElements;
                    continue;
                }
                if (!variable.asType().isCollection()) continue;
                ++requiredChildElements;
            }
            for (Parameter variable : element.getParameters()) {
                if (variable.shouldBeIgnored()) continue;
                if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
                    if (requiredChildElements == 1) {
                        GroupRef groupRef = this.generateNestedProcessorGroup();
                        complexContentExtension.setGroup(groupRef);
                        complexContentExtension.setAll(null);
                        continue;
                    }
                    this.generateNestedProcessorElement(all, (Variable)variable);
                    continue;
                }
                if (variable.asType().isCollection()) {
                    this.generateCollectionElement(all, (Variable)variable, false);
                    continue;
                }
                if (this.isTypeSupported(variable.asTypeMirror()) || variable.asType().isEnum() || variable.asType().isHttpCallback()) {
                    if (variable.isText()) {
                        this.createParameterElement(all, (Variable)variable);
                        continue;
                    }
                    complexContentExtension.getAttributeOrAttributeGroup().add(this.createParameterAttribute((Variable)variable, false));
                    continue;
                }
                if (variable.asType().isComplexType()) {
                    this.registerComplexTypeChildElement(all, (Variable)variable, false);
                    continue;
                }
                complexContentExtension.getAttributeOrAttributeGroup().add(this.createParameterAttribute((Variable)variable, false));
            }
            if (element instanceof ProcessorMethod && ((ProcessorMethod)element).canBeUsedInConnectionManagement() && (connectMethod = ((ProcessorMethod)element).getManagedConnectionModule().getConnectMethod()) != null) {
                for (Parameter parameter : connectMethod.getParameters()) {
                    if (parameter.asType().isCollection()) {
                        this.generateCollectionElement(all, (Variable)parameter, true);
                        continue;
                    }
                    complexContentExtension.getAttributeOrAttributeGroup().add(this.createParameterAttribute((Variable)parameter, true));
                }
            }
            if (element instanceof ProcessorMethod && ((ProcessorMethod)element).canBeUsedInOAuthManagement()) {
                complexContentExtension.getAttributeOrAttributeGroup().add(this.createAttribute("accessTokenId", true, SchemaTypeConversion.convertType((String)this.schema.getTargetNamespace(), (String)"java.lang.String"), "The id of the access token that will be used to authenticate the call"));
            }
        }
        if (all.getParticle().size() == 0) {
            complexContentExtension.setSequence(null);
        }
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(complexType);
    }

    private void registerUnauthorizeType(OAuthModule module) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName("UnauthorizeType");
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR_TYPE);
        complexContent.setExtension(complexContentExtension);
        if (module.getUserIdentifierMethod() != null) {
            complexContentExtension.getAttributeOrAttributeGroup().add(this.createAttribute("accessTokenId", true, SchemaTypeConversion.convertType((String)this.schema.getTargetNamespace(), (String)"java.lang.String"), "The id of the access token that will be used to authenticate the call"));
        }
        Attribute configRefAttr = this.createAttribute("config-ref", true, SchemaConstants.STRING, "Specify which configuration to use for this invocation.");
        complexContentExtension.getAttributeOrAttributeGroup().add(configRefAttr);
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(complexType);
    }

    private void createParameterElement(ExplicitGroup all, Variable variable) {
        Named named = (Named)variable.getAnnotation(Named.class);
        String name = NameUtils.uncamel((String)variable.getName());
        if (named != null && named.value().length() > 0) {
            name = named.value();
        }
        TopLevelElement textElement = new TopLevelElement();
        textElement.setName(name);
        textElement.setMinOccurs(variable.isOptional() ? BigInteger.ZERO : BigInteger.ONE);
        textElement.setType(SchemaTypeConversion.convertType((String)this.schema.getTargetNamespace(), (String)((Object)variable.asTypeMirror()).toString()));
        textElement.setDefault(variable.getDefaultValue());
        textElement.setAnnotation(this.createDocAnnotation(variable.parent().getJavaDocParameterSummary(variable.getName())));
        all.getParticle().add(this.objectFactory.createElement(textElement));
    }

    private void generateNestedProcessorElement(ExplicitGroup all, Variable variable) {
        LocalComplexType collectionComplexType = new LocalComplexType();
        GroupRef group = this.generateNestedProcessorGroup();
        collectionComplexType.setGroup(group);
        TopLevelElement collectionElement = new TopLevelElement();
        collectionElement.setName(NameUtils.uncamel((String)variable.getName()));
        collectionElement.setMinOccurs(variable.isOptional() ? BigInteger.ZERO : BigInteger.ONE);
        collectionElement.setComplexType(collectionComplexType);
        collectionElement.setAnnotation(this.createDocAnnotation(variable.parent().getJavaDocParameterSummary(variable.getName())));
        all.getParticle().add(this.objectFactory.createElement(collectionElement));
        Attribute attribute = this.createAttribute("text", true, SchemaConstants.STRING, null);
        collectionComplexType.getAttributeOrAttributeGroup().add(attribute);
    }

    private GroupRef generateNestedProcessorGroup() {
        GroupRef group = new GroupRef();
        group.generateNestedProcessorGroup(SchemaConstants.MULE_MESSAGE_PROCESSOR_OR_OUTBOUND_ENDPOINT_TYPE);
        group.setMinOccurs(BigInteger.valueOf(0L));
        group.setMaxOccurs("unbounded");
        return group;
    }

    private Attribute createAttribute(String name, boolean optional, QName type, String description) {
        Attribute attr = new Attribute();
        attr.setName(name);
        attr.setUse(optional ? "optional" : "required");
        attr.setType(type);
        if (description != null) {
            attr.setAnnotation(this.createDocAnnotation(description));
        }
        return attr;
    }

    private Attribute createAttribute(String name, boolean optional, QName type, String description, String defaultValue) {
        Attribute attr = new Attribute();
        attr.setName(name);
        attr.setUse(optional ? "optional" : "required");
        attr.setType(type);
        if (description != null) {
            attr.setAnnotation(this.createDocAnnotation(description));
        }
        if (defaultValue != null) {
            attr.setDefault(defaultValue);
        }
        return attr;
    }

    private Annotation createDocAnnotation(String content) {
        Annotation annotation = new Annotation();
        Documentation doc = new Documentation();
        doc.getContent().add(content);
        annotation.getAppinfoOrDocumentation().add(doc);
        return annotation;
    }

    private boolean isTypeSupported(TypeMirror typeMirror) {
        return SchemaTypeConversion.isSupported((String)((Object)typeMirror).toString());
    }

    private boolean skipField(Field field) {
        return !field.hasGetter() || !field.hasSetter() || field.shouldBeIgnored();
    }

    private boolean generateNestedProcessor(Field field) {
        return field.asType().isNestedProcessor() || field.asType().isArrayOrList() && field.getTypeArguments().size() > 0 && ((Type)field.getTypeArguments().get(0)).isNestedProcessor();
    }
}

