/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.retry;

import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicy;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedDoLoop;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.retry.DefaultRetryContext;
import org.mule.retry.PolicyStatus;

@JustOnce
public class RetryProcessInterceptorGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Collections.emptyList();
    private static final List<Product> PRODUCES = Arrays.asList(Product.RETRY_PROCESS_INTERCEPTOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof ManagedConnectionModule;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass processCallbackProcessInterceptorClass = this.getRetryProcessInterceptorClass(module);
        TypeVariable t = processCallbackProcessInterceptorClass.generify("T");
        TypeVariable o = processCallbackProcessInterceptorClass.generify("O");
        processCallbackProcessInterceptorClass._implements(this.ref(ProcessInterceptor.class).narrow((TypeReference)t).narrow((TypeReference)o));
        GeneratedField logger = this.generateLoggerField(processCallbackProcessInterceptorClass);
        GeneratedField next = processCallbackProcessInterceptorClass.field(12, (Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)t).narrow((TypeReference)o), "next");
        GeneratedField retryPolicyTemplate = processCallbackProcessInterceptorClass.field(12, (Type)this.ref(RetryPolicyTemplate.class), "retryPolicyTemplate");
        GeneratedField metaInfo = processCallbackProcessInterceptorClass.field(12, (Type)this.ref(Map.class).narrow(Object.class).narrow(Object.class), "metaInfo", ExpressionFactory._null());
        GeneratedField muleContext = processCallbackProcessInterceptorClass.muleContextField();
        this.generateConstructor(processCallbackProcessInterceptorClass, t, o, next, retryPolicyTemplate, muleContext);
        GeneratedMethod execute = processCallbackProcessInterceptorClass.method(1, (Type)t, "execute");
        execute._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = execute.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)t).narrow((TypeReference)o), "processCallback");
        GeneratedVariable object = execute.param((Type)o, "object");
        GeneratedVariable messageProcessor = execute.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = execute.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedVariable retryPolicy = execute.body().decl((Type)this.ref(RetryPolicy.class), "retryPolicy", (GeneratedExpression)retryPolicyTemplate.invoke("createRetryInstance"));
        GeneratedVariable retryContext = execute.body().decl((Type)this.ref(DefaultRetryContext.class), "retryContext", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultRetryContext.class)).arg("Work Descriptor").arg((GeneratedExpression)metaInfo));
        execute.body().add((Statement)retryContext.invoke("setMuleContext").arg((GeneratedExpression)muleContext));
        GeneratedVariable status = execute.body().decl((Type)this.ref(PolicyStatus.class), "status", ExpressionFactory._null());
        GeneratedVariable result = execute.body().decl((Type)t, "result", ExpressionFactory._null());
        GeneratedTry bigTry = execute.body()._try();
        GeneratedVariable cause = bigTry.body().decl((Type)this.ref(Exception.class), "cause", ExpressionFactory._null());
        GeneratedDoLoop doLoop = bigTry.body()._do((GeneratedExpression)status.invoke("isOk"));
        GeneratedTry smallTry = doLoop.body()._try();
        smallTry.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._this().ref((GeneratedVariable)next).invoke("execute").arg((GeneratedExpression)processCallback).arg((GeneratedExpression)object).arg((GeneratedExpression)messageProcessor).arg((GeneratedExpression)event));
        smallTry.body()._if(retryPolicyTemplate.invoke("getNotifier").isNotNull())._then().add((Statement)retryPolicyTemplate.invoke("getNotifier").invoke("onSuccess").arg((GeneratedExpression)retryContext));
        smallTry.body()._return((GeneratedExpression)result);
        GeneratedCatchBlock catchSmallTryException = smallTry._catch(this.ref(Exception.class));
        GeneratedVariable e = catchSmallTryException.param("e");
        catchSmallTryException.body().assign((AssignmentTarget)cause, (GeneratedExpression)e);
        catchSmallTryException.body()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)cause.invoke("getMessage")).arg((GeneratedExpression)cause));
        catchSmallTryException.body()._if(retryPolicyTemplate.invoke("getNotifier").isNotNull())._then().add((Statement)retryPolicyTemplate.invoke("getNotifier").invoke("onFailure").arg((GeneratedExpression)retryContext).arg((GeneratedExpression)cause));
        GeneratedConditional ifInterrupted = catchSmallTryException.body()._if(Op.cand((GeneratedExpression)cause._instanceof((Type)this.ref(InterruptedException.class)), (GeneratedExpression)cause._instanceof((Type)this.ref(InterruptedIOException.class))));
        ifInterrupted._then().add((Statement)logger.invoke("error").arg("Process was interrupted (InterruptedException), ceasing process"));
        ifInterrupted._then()._break();
        ifInterrupted._else().assign((AssignmentTarget)status, (GeneratedExpression)retryPolicy.invoke("applyPolicy").arg((GeneratedExpression)cause));
        GeneratedConditional ifFailed = bigTry.body()._if(Op.cand((GeneratedExpression)status.isNotNull(), (GeneratedExpression)Op.not((GeneratedExpression)status.invoke("isOk"))));
        ifFailed._then().add((Statement)retryContext.invoke("setFailed").arg((GeneratedExpression)cause));
        ifFailed._then()._throw((GeneratedExpression)cause);
        GeneratedBlock fin = bigTry._finally();
        GeneratedConditional ifStatusNotNull = fin._if(Op.cand((GeneratedExpression)status.isNotNull(), (GeneratedExpression)status.invoke("getThrowable").isNotNull()));
        ifStatusNotNull._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg((GeneratedExpression)status.invoke("getThrowable").invoke("getMessage")).arg((GeneratedExpression)status.invoke("getThrowable")));
        execute.body()._return(ExpressionFactory._null());
    }

    private void generateConstructor(GeneratedClass processCallbackProcessInterceptorClass, TypeVariable t, TypeVariable o, GeneratedField next, GeneratedField retryPolicyTemplate, GeneratedField muleContext) {
        GeneratedMethod constructor = processCallbackProcessInterceptorClass.constructor(1);
        GeneratedVariable thisNext = constructor.param((Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)t).narrow((TypeReference)o), "next");
        GeneratedVariable thisMuleContext = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable thisRetryPolicyTemplate = constructor.param((Type)this.ref(RetryPolicyTemplate.class), "retryPolicyTemplate");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)next), (GeneratedExpression)thisNext);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)muleContext), (GeneratedExpression)thisMuleContext);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)retryPolicyTemplate), (GeneratedExpression)thisRetryPolicyTemplate);
    }

    private GeneratedClass getRetryProcessInterceptorClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".process");
        GeneratedClass clazz = pkg._class(1, "RetryProcessInterceptor");
        this.ctx().registerProduct(Product.RETRY_PROCESS_INTERCEPTOR, (Object)clazz);
        return clazz;
    }
}

