/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.module.Module;

public class RegistryBootstrapGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.REGISTRY_BOOTSTRAP_ENTRY);
    private static final List<Product> PRODUCES = Arrays.asList(Product.REGISTRY_BOOTSTRAP);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        try {
            OutputStream registryBootstrapStream = this.ctx().getCodeModel().getRegistryBootstrapStream();
            OutputStreamWriter registryBootstrapStreamOut = new OutputStreamWriter(registryBootstrapStream, "UTF-8");
            for (GeneratedClass clazz : this.ctx().getProductList(Product.REGISTRY_BOOTSTRAP_ENTRY)) {
                this.ctx().note("Adding registry bootstrap entry for " + clazz.fullName() + " as " + clazz.name());
                registryBootstrapStreamOut.write(clazz.name() + "=" + clazz.fullName() + "\n");
            }
            registryBootstrapStreamOut.flush();
        }
        catch (IOException ioe) {
            throw new GenerationException((Throwable)ioe);
        }
    }
}

