/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.NestedProcessor;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

@JustOnce
public class NestedProcessorChainGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Collections.emptyList();
    private static final List<Product> PRODUCES = Arrays.asList(Product.NESTED_PROCESSOR_CHAIN);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.GENERIC || module.getKind() == ModuleKind.CONNECTOR;
    }

    public void generate(Module module) {
        GeneratedClass callbackClass = this.getNestedProcessorChainClass(module);
        callbackClass._implements(this.ref(NestedProcessor.class));
        GeneratedField muleContext = callbackClass.field(4, (Type)this.ref(MuleContext.class), "muleContext");
        muleContext.javadoc().add((Object)"Mule Context");
        callbackClass.setter(muleContext);
        GeneratedField chain = callbackClass.field(4, (Type)this.ref(MessageProcessor.class), "chain");
        chain.javadoc().add((Object)"Chain that will be executed upon calling process");
        callbackClass.setter(chain);
        GeneratedField event = callbackClass.field(4, (Type)this.ref(MuleEvent.class), "event");
        event.javadoc().add((Object)"Event that will be cloned for dispatching");
        callbackClass.setter(event);
        this.generateCallbackConstructor(callbackClass, chain, event, muleContext);
        this.generateCallbackProcess(callbackClass, chain, event);
        this.generateCallbackProcessWithPayload(callbackClass, chain, event, muleContext);
        this.generateCallbackProcessWithProperties(callbackClass, chain, event);
        this.generateCallbackProcessWithPayloadAndProperties(callbackClass, chain, event, muleContext);
    }

    private void generateCallbackProcessWithPayload(GeneratedClass callbackClass, GeneratedField chain, GeneratedField event, GeneratedField muleContext) {
        GeneratedMethod process = callbackClass.method(1, (Type)this.ref(Object.class), "process");
        process._throws(this.ref(Exception.class));
        GeneratedVariable payload = process.param((Type)this.ref(Object.class), "payload");
        GeneratedVariable muleMessage = process.body().decl((Type)this.ref(MuleMessage.class), "muleMessage");
        GeneratedInvocation newMuleMessage = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleMessage.class));
        newMuleMessage.arg((GeneratedExpression)payload);
        newMuleMessage.arg((GeneratedExpression)muleContext);
        process.body().assign((AssignmentTarget)muleMessage, (GeneratedExpression)newMuleMessage);
        GeneratedVariable muleEvent = process.body().decl((Type)this.ref(MuleEvent.class), "muleEvent");
        GeneratedInvocation newMuleEvent = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleEvent.class));
        newMuleEvent.arg((GeneratedExpression)muleMessage);
        newMuleEvent.arg((GeneratedExpression)event);
        process.body().assign((AssignmentTarget)muleEvent, (GeneratedExpression)newMuleEvent);
        process.body()._return((GeneratedExpression)chain.invoke("process").arg((GeneratedExpression)muleEvent).invoke("getMessage").invoke("getPayload"));
    }

    private void generateCallbackProcessWithPayloadAndProperties(GeneratedClass callbackClass, GeneratedField chain, GeneratedField event, GeneratedField muleContext) {
        GeneratedMethod process = callbackClass.method(1, (Type)this.ref(Object.class), "process");
        process._throws(this.ref(Exception.class));
        GeneratedVariable payload = process.param((Type)this.ref(Object.class), "payload");
        GeneratedVariable properties = process.param((Type)this.ref(Map.class).narrow(this.ref(String.class)).narrow(this.ref(Object.class)), "properties");
        GeneratedVariable muleMessage = process.body().decl((Type)this.ref(MuleMessage.class), "muleMessage");
        GeneratedInvocation newMuleMessage = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleMessage.class));
        newMuleMessage.arg((GeneratedExpression)payload);
        newMuleMessage.arg((GeneratedExpression)muleContext);
        process.body().assign((AssignmentTarget)muleMessage, (GeneratedExpression)newMuleMessage);
        GeneratedForEach forEachProperty = process.body().forEach((Type)this.ref(String.class), "property", (GeneratedExpression)properties.invoke("keySet"));
        forEachProperty.body().add((Statement)muleMessage.invoke("setInvocationProperty").arg((GeneratedExpression)forEachProperty.var()).arg((GeneratedExpression)properties.invoke("get").arg((GeneratedExpression)forEachProperty.var())));
        GeneratedVariable muleEvent = process.body().decl((Type)this.ref(MuleEvent.class), "muleEvent");
        GeneratedInvocation newMuleEvent = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleEvent.class));
        newMuleEvent.arg((GeneratedExpression)muleMessage);
        newMuleEvent.arg((GeneratedExpression)event);
        process.body().assign((AssignmentTarget)muleEvent, (GeneratedExpression)newMuleEvent);
        process.body()._return((GeneratedExpression)chain.invoke("process").arg((GeneratedExpression)muleEvent).invoke("getMessage").invoke("getPayload"));
    }

    private void generateCallbackProcessWithProperties(GeneratedClass callbackClass, GeneratedField chain, GeneratedField event) {
        GeneratedMethod process = callbackClass.method(1, (Type)this.ref(Object.class), "processWithExtraProperties");
        process._throws(this.ref(Exception.class));
        GeneratedVariable properties = process.param((Type)this.ref(Map.class).narrow(this.ref(String.class)).narrow(this.ref(Object.class)), "properties");
        GeneratedVariable muleMessage = process.body().decl((Type)this.ref(MuleMessage.class), "muleMessage");
        process.body().assign((AssignmentTarget)muleMessage, (GeneratedExpression)event.invoke("getMessage"));
        GeneratedForEach forEachProperty = process.body().forEach((Type)this.ref(String.class), "property", (GeneratedExpression)properties.invoke("keySet"));
        forEachProperty.body().add((Statement)muleMessage.invoke("setInvocationProperty").arg((GeneratedExpression)forEachProperty.var()).arg((GeneratedExpression)properties.invoke("get").arg((GeneratedExpression)forEachProperty.var())));
        GeneratedVariable muleEvent = process.body().decl((Type)this.ref(MuleEvent.class), "muleEvent");
        GeneratedInvocation newMuleEvent = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleEvent.class));
        newMuleEvent.arg((GeneratedExpression)muleMessage);
        newMuleEvent.arg((GeneratedExpression)event);
        process.body().assign((AssignmentTarget)muleEvent, (GeneratedExpression)newMuleEvent);
        process.body()._return((GeneratedExpression)chain.invoke("process").arg((GeneratedExpression)muleEvent).invoke("getMessage").invoke("getPayload"));
    }

    private void generateCallbackProcess(GeneratedClass callbackClass, GeneratedField chain, GeneratedField event) {
        GeneratedMethod process = callbackClass.method(1, (Type)this.ref(Object.class), "process");
        process._throws(this.ref(Exception.class));
        GeneratedVariable muleEvent = process.body().decl((Type)this.ref(MuleEvent.class), "muleEvent");
        GeneratedInvocation newMuleEvent = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleEvent.class));
        newMuleEvent.arg((GeneratedExpression)event.invoke("getMessage"));
        newMuleEvent.arg((GeneratedExpression)event);
        process.body().assign((AssignmentTarget)muleEvent, (GeneratedExpression)newMuleEvent);
        process.body()._return((GeneratedExpression)chain.invoke("process").arg((GeneratedExpression)muleEvent).invoke("getMessage").invoke("getPayload"));
    }

    private void generateCallbackConstructor(GeneratedClass callbackClass, GeneratedField chain, GeneratedField event, GeneratedField muleContext) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        GeneratedVariable event2 = constructor.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedVariable muleContext2 = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable chain2 = constructor.param((Type)this.ref(MessageProcessor.class), "chain");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)event), (GeneratedExpression)event2);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)chain), (GeneratedExpression)chain2);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)muleContext), (GeneratedExpression)muleContext2);
    }

    private GeneratedClass getNestedProcessorChainClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".process");
        GeneratedClass clazz = pkg._class("NestedProcessorChain", new Class[]{MuleContextAware.class});
        this.ctx().registerProduct(Product.NESTED_PROCESSOR_CHAIN, (Object)clazz);
        return clazz;
    }
}

