/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.adapter.HttpCallbackAdapter;
import org.mule.api.adapter.PoolManager;
import org.mule.api.annotations.Mime;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.callback.HttpCallback;
import org.mule.api.callback.SourceCallback;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedArray;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;

public class MessageProcessorGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.INJECTION_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.HTTP_CALLBACK_ADAPTER, Product.OAUTH_ADAPTER, Product.CONNECTION_KEY, Product.NESTED_PROCESSOR_CHAIN, Product.POOL_MANAGER, Product.CONNECTION_MANAGER, Product.ABSTRACT_LISTENING_MESSAGE_PROCESSOR, Product.ABSTRACT_CONNECTED_PROCESSOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MESSAGE_PROCESSOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.hasProcessors() && (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC);
    }

    public void generate(Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            this.generateMessageProcessor(module, processorMethod);
        }
    }

    private void generateMessageProcessor(Module module, ProcessorMethod processorMethod) {
        if (this.ctx().getProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName()) != null) {
            return;
        }
        GeneratedClass messageProcessorClass = processorMethod.isIntercepting() ? this.getInterceptingMessageProcessorClass(processorMethod) : this.getMessageProcessorClass(processorMethod);
        this.ctx().note("Generating message processor as " + messageProcessorClass.fullName() + " for method " + processorMethod.getName() + " in " + module.getName());
        this.generateMessageProcessorClassDoc(processorMethod, messageProcessorClass);
        Map<String, AbstractMuleGenerator.FieldVariableElement> fields = this.generateProcessorFieldForEachParameter(messageProcessorClass, (Method)processorMethod);
        this.generateInitialiseMethod(messageProcessorClass, fields, module);
        this.generateStartMethod(messageProcessorClass, fields);
        this.generateStopMethod(messageProcessorClass, fields);
        this.generateDiposeMethod(messageProcessorClass, fields);
        this.generateSetMuleContextMethod(messageProcessorClass, fields);
        this.generateSetFlowConstructMethod(messageProcessorClass, fields);
        for (String fieldName : fields.keySet()) {
            messageProcessorClass.setter(fields.get(fieldName).getField());
        }
        if (module.usesPooling()) {
            GeneratedClass poolObjectClass = ((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass();
            this.generateProcessMethod(processorMethod, messageProcessorClass, fields, poolObjectClass);
        } else {
            this.generateProcessMethod(processorMethod, messageProcessorClass, fields);
        }
    }

    private void generateMessageProcessorClassDoc(ProcessorMethod executableElement, GeneratedClass messageProcessorClass) {
        messageProcessorClass.javadoc().add((Object)(messageProcessorClass.name() + " invokes the "));
        messageProcessorClass.javadoc().add((Object)("{@link " + ((org.mule.devkit.model.Type)executableElement.parent()).getQualifiedName().toString() + "#"));
        messageProcessorClass.javadoc().add((Object)(executableElement.getName() + "("));
        boolean first = true;
        for (Parameter variable : executableElement.getParameters()) {
            if (!first) {
                messageProcessorClass.javadoc().add((Object)", ");
            }
            messageProcessorClass.javadoc().add((Object)((Object)variable.asTypeMirror()).toString().replaceAll("<[a-zA-Z\\-\\.\\<\\>\\s\\,]*>", ""));
            first = false;
        }
        messageProcessorClass.javadoc().add((Object)")} method in ");
        messageProcessorClass.javadoc().add((Object)this.ref(((org.mule.devkit.model.Type)executableElement.parent()).asTypeMirror()));
        messageProcessorClass.javadoc().add((Object)". For each argument there is a field in this processor to match it. ");
        messageProcessorClass.javadoc().add((Object)" Before invoking the actual method the processor will evaluate and transform");
        messageProcessorClass.javadoc().add((Object)" where possible to the expected argument type.");
    }

    private void generateProcessMethod(ProcessorMethod processorMethod, GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        this.generateProcessMethod(processorMethod, messageProcessorClass, fields, null);
    }

    private void generateProcessMethod(ProcessorMethod processorMethod, GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields, GeneratedClass poolObjectClass) {
        GeneratedInvocation findOrCreate;
        String methodName = processorMethod.getName();
        TypeReference muleEvent = this.ref(MuleEvent.class);
        boolean injectParameters = processorMethod.getAnnotation(Inject.class) != null;
        GeneratedMethod process = messageProcessorClass.method(1, (Type)muleEvent, "process");
        process.javadoc().add((Object)"Invokes the MessageProcessor.");
        process.javadoc().addParam("event MuleEvent to be processed");
        process.javadoc().addThrows(this.ref(MuleException.class));
        process._throws(MuleException.class);
        GeneratedVariable event = null;
        event = process.param(8, (Type)muleEvent, "event");
        GeneratedVariable sourceCallback = null;
        if (processorMethod.isIntercepting()) {
            sourceCallback = process.body().decl(8, (Type)this.ref(SourceCallback.class), "sourceCallback", ExpressionFactory._this());
        }
        GeneratedVariable poolObject = this.declarePoolObjectIfClassNotNull(poolObjectClass, process);
        GeneratedTry callProcessor = process.body()._try();
        if (this.getModuleObject((org.mule.devkit.model.Type)processorMethod.parent()) != null) {
            findOrCreate = ExpressionFactory.invoke((String)"findOrCreate").arg(this.getModuleObject((org.mule.devkit.model.Type)processorMethod.parent()).dotclass());
            if (processorMethod.parent() instanceof Module && ((Module)processorMethod.parent()).needsConfig()) {
                findOrCreate.arg(ExpressionFactory.FALSE);
            } else {
                findOrCreate.arg(ExpressionFactory.TRUE);
            }
            findOrCreate.arg((GeneratedExpression)event);
            callProcessor.body().add((Statement)findOrCreate);
        } else {
            findOrCreate = ExpressionFactory.invoke((String)"findOrCreate").arg(this.ref(ProcessAdapter.class).dotclass());
            findOrCreate.arg(ExpressionFactory.FALSE);
            findOrCreate.arg((GeneratedExpression)event);
            callProcessor.body().add((Statement)findOrCreate);
        }
        for (String fieldName : fields.keySet()) {
            AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
            if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
            GeneratedField callbackFlowName = fields.get(fieldName).getField();
            GeneratedBlock ifCallbackFlowNameIsNull = callProcessor.body()._if(Op.cand((GeneratedExpression)callbackFlowName.isNotNull(), (GeneratedExpression)variableElement.getFieldType().isNull()))._then();
            GeneratedVariable castedModuleObject = ifCallbackFlowNameIsNull.decl((Type)this.ref(HttpCallbackAdapter.class), "castedModuleObject", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(HttpCallbackAdapter.class), (GeneratedExpression)ExpressionFactory.invoke((String)"getModuleObject")));
            GeneratedInvocation domain = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"domain"));
            GeneratedInvocation localPort = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"localPort"));
            GeneratedInvocation remotePort = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"remotePort"));
            GeneratedInvocation async = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"async"));
            ifCallbackFlowNameIsNull.assign((AssignmentTarget)variableElement.getFieldType(), (GeneratedExpression)ExpressionFactory._new((TypeReference)((TypeReference)this.ctx().getProduct(Product.DEFAULT_HTTP_CALLBACK))).arg((GeneratedExpression)callbackFlowName).arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext")).arg((GeneratedExpression)domain).arg((GeneratedExpression)localPort).arg((GeneratedExpression)remotePort).arg((GeneratedExpression)async));
            ifCallbackFlowNameIsNull.add((Statement)variableElement.getFieldType().invoke("start"));
        }
        ArrayList<GeneratedExpression> parameters = new ArrayList<GeneratedExpression>();
        GeneratedVariable interceptCallback = null;
        GeneratedVariable outboundHeadersMap = null;
        for (Parameter variable : processorMethod.getParameters()) {
            String fieldName = variable.getName();
            if (((Object)variable.asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) {
                parameters.add((GeneratedExpression)fields.get(fieldName).getFieldType());
                continue;
            }
            if (((Object)variable.asTypeMirror()).toString().startsWith(SourceCallback.class.getName())) {
                parameters.add((GeneratedExpression)sourceCallback);
                continue;
            }
            if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
                parameters.add((GeneratedExpression)this.declareNestedProcessorParameter((GeneratedExpression)fields.get(fieldName).getField(), (GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"), event, callProcessor.body(), variable.asType().isArrayOrList(), fieldName));
                continue;
            }
            if (((Object)variable.asTypeMirror()).toString().startsWith(MuleMessage.class.getName()) && injectParameters) {
                parameters.add((GeneratedExpression)event.invoke("getMessage"));
                continue;
            }
            if (((Object)variable.asTypeMirror()).toString().startsWith(MuleEvent.class.getName()) && injectParameters) {
                parameters.add((GeneratedExpression)event);
                continue;
            }
            outboundHeadersMap = this.declareStandardParameter((Variable)variable, messageProcessorClass, event, callProcessor, parameters, outboundHeadersMap);
        }
        Type returnType = this.ref(processorMethod.getReturnType());
        this.generateMethodCall(processorMethod, callProcessor.body(), methodName, parameters, event, returnType, interceptCallback, (org.mule.devkit.model.Type)processorMethod.parent());
        for (Parameter variable : processorMethod.getParameters()) {
            OutboundHeaders outboundHeaders = (OutboundHeaders)variable.getAnnotation(OutboundHeaders.class);
            if (outboundHeaders == null) continue;
            GeneratedConditional ifNotEmpty = callProcessor.body()._if(Op.cand((GeneratedExpression)outboundHeadersMap.isNotNull(), (GeneratedExpression)Op.not((GeneratedExpression)outboundHeadersMap.invoke("isEmpty"))));
            ifNotEmpty._then().add((Statement)event.invoke("getMessage").invoke("addProperties").arg((GeneratedExpression)outboundHeadersMap).arg((GeneratedExpression)this.ref(PropertyScope.class).staticRef("OUTBOUND")));
        }
        if (processorMethod.getAnnotation(Mime.class) != null) {
            GeneratedCast defaultMuleMessage = ExpressionFactory.cast((Type)this.ref(DefaultMuleMessage.class), (GeneratedExpression)event.invoke("getMessage"));
            GeneratedInvocation setMimeType = defaultMuleMessage.invoke("setMimeType").arg(ExpressionFactory.lit((String)((Mime)processorMethod.getAnnotation(Mime.class)).value()));
            callProcessor.body().add((Statement)setMimeType);
        }
        callProcessor.body()._return((GeneratedExpression)event);
        GeneratedCatchBlock catchMessagingException = callProcessor._catch(this.ref(MessagingException.class));
        GeneratedVariable messagingException = catchMessagingException.param("messagingException");
        catchMessagingException.body().invoke((GeneratedExpression)messagingException, "setProcessedEvent").arg((GeneratedExpression)event);
        catchMessagingException.body()._throw((GeneratedExpression)messagingException);
        this.generateThrow("failedToInvoke", MessagingException.class, callProcessor._catch(this.ref(Exception.class)), (GeneratedExpression)event, methodName);
        if (poolObjectClass != null) {
            GeneratedBlock fin = callProcessor._finally();
            GeneratedBlock poolObjectNotNull = fin._if(poolObject.isNotNull())._then();
            poolObjectNotNull.add((Statement)ExpressionFactory.cast((Type)this.ref(PoolManager.class), (GeneratedExpression)ExpressionFactory.invoke((String)"getModuleObject")).invoke("getLifecyleEnabledObjectPool").invoke("returnObject").arg((GeneratedExpression)poolObject));
        }
    }

    private GeneratedVariable declareStandardParameter(Variable variable, GeneratedClass messageProcessorClass, GeneratedVariable muleEvent, GeneratedTry callProcessor, List<GeneratedExpression> parameters, GeneratedVariable outboundHeadersMap) {
        OutboundHeaders outboundHeaders = (OutboundHeaders)variable.getAnnotation(OutboundHeaders.class);
        if (outboundHeaders == null) {
            GeneratedVariable transformed = this.declareTransformedVariable(variable, (GeneratedExpression)ExpressionFactory.ref((String)variable.getName()), (Type)messageProcessorClass, muleEvent, callProcessor.body(), (GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"));
            parameters.add((GeneratedExpression)transformed);
        } else {
            TypeReference type = this.ref(HashMap.class).narrow(new TypeReference[]{this.ref(String.class), this.ref(Object.class)});
            String name = "_transformed" + StringUtils.capitalize((String)variable.getName());
            outboundHeadersMap = callProcessor.body().decl(8, (Type)type, name, (GeneratedExpression)ExpressionFactory._new((Type)type));
            parameters.add((GeneratedExpression)outboundHeadersMap);
        }
        return outboundHeadersMap;
    }

    private GeneratedVariable declarePoolObjectIfClassNotNull(GeneratedClass poolObjectClass, GeneratedMethod process) {
        if (poolObjectClass != null) {
            return process.body().decl((Type)poolObjectClass, "_poolObject", ExpressionFactory._null());
        }
        return null;
    }

    private GeneratedVariable generateMethodCall(ProcessorMethod executableElement, GeneratedBlock body, String methodName, List<GeneratedExpression> parameters, GeneratedVariable event, Type returnType, GeneratedVariable interceptCallback, org.mule.devkit.model.Type module) {
        GeneratedVariable resultPayload = null;
        if (returnType != this.ctx().getCodeModel().VOID) {
            resultPayload = body.decl((Type)this.ref(Object.class), "resultPayload");
        }
        GeneratedVariable processTemplate = body.decl((Type)this.ref(ProcessTemplate.class).narrow(this.ref(Object.class)).narrow(this.ref(Object.class)), "processTemplate", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ProcessAdapter.class).narrow(this.ref(Object.class)), (GeneratedExpression)ExpressionFactory.invoke((String)"getModuleObject")).invoke("getProcessTemplate"));
        GeneratedClass executionCallback = this.ctx().getCodeModel().anonymousClass(this.ref(ProcessCallback.class).narrow(this.ref(Object.class)).narrow(this.ref(Object.class)));
        GeneratedMethod getManagedExceptions = executionCallback.method(1, (Type)this.ref(List.class).narrow(Class.class), "getManagedExceptions");
        if (executableElement.invalidateConnectionOn() != null || executableElement.invalidateAccessTokenOn() != null) {
            GeneratedArray newExceptionArray = ExpressionFactory.newArray((Type)this.ref(Class.class));
            if (executableElement.invalidateConnectionOn() != null) {
                newExceptionArray.add(this.ref(executableElement.invalidateConnectionOn()).boxify().dotclass());
            } else if (executableElement.invalidateAccessTokenOn() != null) {
                newExceptionArray.add(this.ref(executableElement.invalidateAccessTokenOn()).boxify().dotclass());
            }
            getManagedExceptions.body()._return((GeneratedExpression)this.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)newExceptionArray));
        } else {
            getManagedExceptions.body()._return(ExpressionFactory._null());
        }
        GeneratedMethod isProtected = executionCallback.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isProtected");
        if (executableElement.isOAuthProtected()) {
            isProtected.body()._return(ExpressionFactory.TRUE);
        } else {
            isProtected.body()._return(ExpressionFactory.FALSE);
        }
        GeneratedMethod process = executionCallback.method(1, (Type)this.ref(Object.class), "process");
        GeneratedVariable object2 = process.param((Type)this.ref(Object.class), "object");
        process._throws(this.ref(Exception.class));
        GeneratedInvocation methodCall = ExpressionFactory.cast((Type)this.ref(module), (GeneratedExpression)object2).invoke(methodName);
        for (GeneratedExpression parameter : parameters) {
            methodCall.arg(parameter);
        }
        if (returnType != this.ctx().getCodeModel().VOID) {
            process.body()._return((GeneratedExpression)methodCall);
            body.assign((AssignmentTarget)resultPayload, (GeneratedExpression)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._this()).arg((GeneratedExpression)event));
        } else {
            process.body().add((Statement)methodCall);
            process.body()._return(ExpressionFactory._null());
            body.add((Statement)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._this()).arg((GeneratedExpression)event));
        }
        GeneratedBlock scope = body;
        if (interceptCallback != null) {
            GeneratedConditional shallContinue = body._if(Op.cand((GeneratedExpression)interceptCallback.invoke("getShallContinue"), (GeneratedExpression)ExpressionFactory.invoke((String)"getListener").isNotNull()));
            shallContinue._then().assign((AssignmentTarget)event, (GeneratedExpression)ExpressionFactory.invoke((String)"getListener").invoke("process").arg((GeneratedExpression)event));
            scope = shallContinue._else();
        }
        if (returnType != this.ctx().getCodeModel().VOID) {
            scope.invoke("overwritePayload").arg((GeneratedExpression)event).arg((GeneratedExpression)resultPayload);
        }
        return resultPayload;
    }

    private GeneratedClass getMessageProcessorClass(ProcessorMethod processorMethod) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((org.mule.devkit.model.Type)processorMethod.parent()).getPackage().getName() + ".processors");
        GeneratedClass abstractMessageProcessor = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_MESSAGE_PROCESSOR);
        GeneratedClass clazz = pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", abstractMessageProcessor.narrow(this.ref(Object.class)), new Class[]{MessageProcessor.class, Initialisable.class, Startable.class, Disposable.class, Stoppable.class});
        this.ctx().registerProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName(), (Object)clazz);
        return clazz;
    }

    private GeneratedClass getInterceptingMessageProcessorClass(ProcessorMethod processorMethod) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((org.mule.devkit.model.Type)processorMethod.parent()).getPackage().getName() + ".processors");
        GeneratedClass abstractListeningMessageProcessor = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_LISTENING_MESSAGE_PROCESSOR);
        GeneratedClass clazz = pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", abstractListeningMessageProcessor.narrow(this.ref(Object.class)), new Class[]{InterceptingMessageProcessor.class, Initialisable.class, Startable.class, Disposable.class, Stoppable.class});
        this.ctx().registerProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName(), (Object)clazz);
        return clazz;
    }

    private void generateStartMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod startMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        startMethod._throws(this.ref(MuleException.class));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (variableElement.getVariable().asType().isNestedProcessor() || variableElement.getVariable().asType().isArrayOrList() && variableElement.getVariable().getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor()) {
                    boolean isList = variableElement.getVariable().asType().isArrayOrList();
                    if (!isList) {
                        GeneratedConditional ifStartable = startMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Startable.class)));
                        ifStartable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)variableElement.getField()).invoke("start"));
                        continue;
                    }
                    GeneratedConditional ifIsList = startMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                    GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                    GeneratedConditional ifStartable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Startable.class)));
                    ifStartable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)forEachProcessor.var()).invoke("start"));
                    continue;
                }
                if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
                startMethod.body()._if(variableElement.getFieldType().isNotNull())._then().invoke((GeneratedExpression)variableElement.getFieldType(), "start");
            }
        }
    }

    private void generateStopMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod stopMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
        stopMethod._throws(this.ref(MuleException.class));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (variableElement.getVariable().asType().isNestedProcessor() || variableElement.getVariable().asType().isArrayOrList() && variableElement.getVariable().getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor()) {
                    boolean isList = variableElement.getVariable().asType().isArrayOrList();
                    if (!isList) {
                        GeneratedConditional ifStoppable = stopMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Stoppable.class)));
                        ifStoppable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)variableElement.getField()).invoke("stop"));
                        continue;
                    }
                    GeneratedConditional ifIsList = stopMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                    GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                    GeneratedConditional ifStoppable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Stoppable.class)));
                    ifStoppable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)forEachProcessor.var()).invoke("stop"));
                    continue;
                }
                if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
                stopMethod.body()._if(variableElement.getFieldType().isNotNull())._then().invoke((GeneratedExpression)variableElement.getFieldType(), "stop");
            }
        }
    }

    private void generateDiposeMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod diposeMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "dispose");
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (!variableElement.getVariable().asType().isNestedProcessor() && (!variableElement.getVariable().asType().isArrayOrList() || variableElement.getVariable().getTypeArguments().size() <= 0 || !((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor())) continue;
                boolean isList = variableElement.getVariable().asType().isArrayOrList();
                if (!isList) {
                    GeneratedConditional ifDisposable = diposeMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Disposable.class)));
                    ifDisposable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)variableElement.getField()).invoke("dispose"));
                    continue;
                }
                GeneratedConditional ifIsList = diposeMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                GeneratedConditional ifDisposable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Disposable.class)));
                ifDisposable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)forEachProcessor.var()).invoke("dispose"));
            }
        }
    }
}

