/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;

public class ExpressionHolderGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Collections.emptyList();
    private static final List<Product> PRODUCES = Arrays.asList(Product.EXPRESSION_HOLDER);
    private Set<String> registeredExpressionHolders = new HashSet<String>();

    public List<Product> consumes() {
        return Collections.unmodifiableList(CONSUMES);
    }

    public List<Product> produces() {
        return Collections.unmodifiableList(PRODUCES);
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void generate(Module module) throws GenerationException {
        for (ProcessorMethod method : module.getProcessorMethods()) {
            for (Parameter parameter : method.getParameters()) {
                this.registerExpressionHolderFor((Identifiable<? extends Element>)parameter);
            }
        }
        for (ProcessorMethod method : module.getSourceMethods()) {
            for (Parameter variable : method.getParameters()) {
                this.registerExpressionHolderFor((Identifiable<? extends Element>)variable);
            }
        }
    }

    private void registerExpressionHolderFor(Identifiable<? extends Element> parameter) {
        block3: {
            block2: {
                if (!parameter.asType().isCollection()) break block2;
                for (Type variableTypeParameter : parameter.getTypeArguments()) {
                    this.registerExpressionHolderFor((Identifiable<? extends Element>)variableTypeParameter);
                }
                break block3;
            }
            if (!parameter.asType().isComplexType() || this.isExpressionHolderRegistered(parameter.asTypeMirror())) break block3;
            this.registerExpressionHolder(parameter.asType());
            for (Field field : parameter.asType().getFields()) {
                this.registerExpressionHolderFor((Identifiable<? extends Element>)field);
            }
        }
    }

    private void registerExpressionHolder(Type type) {
        GeneratedClass expressionHolderClass = this.getExpressionHolderClass(type);
        this.ctx().note("Generating expression holder for " + type.getName() + " as " + expressionHolderClass.binaryName());
        for (Field field : type.getFields()) {
            if (!field.hasGetter() || !field.hasSetter()) continue;
            String fieldName = field.getName();
            GeneratedField expressionField = new FieldBuilder(expressionHolderClass).protectedVisibility().type(Object.class).name(fieldName).build();
            GeneratedField expressionFieldType = new FieldBuilder(expressionHolderClass).protectedVisibility().type(this.ref(field.asTypeMirror())).name("_" + fieldName + "Type").build();
            expressionHolderClass.setter(expressionField);
            expressionHolderClass.getter(expressionField);
        }
        this.registeredExpressionHolders.add(((Object)type.asTypeMirror()).toString());
    }

    private GeneratedClass getExpressionHolderClass(Type type) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(type.getPackage().getName() + ".holders");
        GeneratedClass expressionHolderClass = pkg._class(type.getClassName() + "ExpressionHolder");
        this.ctx().registerProduct(Product.EXPRESSION_HOLDER, (Identifiable)type, (Object)expressionHolderClass);
        return expressionHolderClass;
    }

    private boolean isExpressionHolderRegistered(TypeMirror typeMirror) {
        return this.registeredExpressionHolders.contains(((Object)typeMirror).toString());
    }
}

