/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.config.ConfigurationException;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.MessageFactory;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.transformer.TransformerTemplate;
import org.mule.transport.NullPayload;

@JustOnce
public class AbstractMessageProcessorGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.ABSTRACT_EXPRESSION_EVALUATOR, Product.ABSTRACT_CONNECTED_PROCESSOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.ABSTRACT_MESSAGE_PROCESSOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.hasProcessors() || module.hasSources();
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass abstractMessageProcessorClass = this.getAbstractMessageProcessorClass(module);
        TypeVariable moduleObject = abstractMessageProcessorClass.generify("O");
        GeneratedField object = this.generateFieldForModuleObject(abstractMessageProcessorClass, moduleObject);
        GeneratedField muleContext = abstractMessageProcessorClass.muleContextField();
        GeneratedField flowConstruct = abstractMessageProcessorClass.flowConstructField();
        abstractMessageProcessorClass.setter(object);
        abstractMessageProcessorClass.getter(object);
        this.generateFindOrCreateMethod(abstractMessageProcessorClass, moduleObject, object, muleContext);
        this.generateOverwritePayloadMethod(abstractMessageProcessorClass);
    }

    private GeneratedClass getAbstractMessageProcessorClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".processors");
        GeneratedClass baseClass = null;
        baseClass = module instanceof ManagedConnectionModule || module instanceof OAuthModule && ((OAuthModule)module).getUserIdentifierMethod() != null ? (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_CONNECTED_PROCESSOR) : (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_EXPRESSION_EVALUATOR);
        GeneratedClass clazz = pkg._class(33, "AbstractMessageProcessor", baseClass, new Class[]{MuleContextAware.class, FlowConstructAware.class});
        this.ctx().registerProduct(Product.ABSTRACT_MESSAGE_PROCESSOR, (Object)clazz);
        return clazz;
    }

    protected GeneratedMethod generateFindOrCreateMethod(GeneratedClass messageProcessorClass, TypeVariable typeVar, GeneratedField object, GeneratedField muleContext) {
        GeneratedMethod findOrCreateMethod = messageProcessorClass.method(2, (Type)this.ctx().getCodeModel().VOID, "findOrCreate");
        findOrCreateMethod.javadoc().add((Object)"Obtains the expression manager from the Mule context and initialises the connector. If a target object ");
        findOrCreateMethod.javadoc().add((Object)" has not been set already it will search the Mule registry for a default one.");
        findOrCreateMethod.javadoc().addThrows(this.ref(ConfigurationException.class));
        findOrCreateMethod.javadoc().addThrows(this.ref(RegistrationException.class));
        findOrCreateMethod.javadoc().addThrows(this.ref(InstantiationException.class));
        findOrCreateMethod.javadoc().addThrows(this.ref(IllegalAccessException.class));
        findOrCreateMethod._throws(ConfigurationException.class);
        findOrCreateMethod._throws(RegistrationException.class);
        findOrCreateMethod._throws(InstantiationException.class);
        findOrCreateMethod._throws(IllegalAccessException.class);
        GeneratedVariable moduleClass = findOrCreateMethod.param((Type)this.ref(Class.class), "moduleClass");
        GeneratedVariable shouldAutoCreate = findOrCreateMethod.param((Type)this.ctx().getCodeModel().BOOLEAN, "shouldAutoCreate");
        GeneratedVariable muleEvent = findOrCreateMethod.param((Type)this.ref(MuleEvent.class), "muleEvent");
        GeneratedConditional ifNoObject = findOrCreateMethod.body()._if(object.isNull());
        ifNoObject._then().assign((AssignmentTarget)object, (GeneratedExpression)ExpressionFactory.cast((Type)typeVar, (GeneratedExpression)muleContext.invoke("getRegistry").invoke("lookupObject").arg((GeneratedExpression)moduleClass)));
        GeneratedConditional ifObjectNoFound = ifNoObject._then()._if(object.isNull());
        GeneratedConditional ifShouldAutoCreate = ifObjectNoFound._then()._if((GeneratedExpression)shouldAutoCreate);
        ifShouldAutoCreate._then().assign((AssignmentTarget)object, (GeneratedExpression)ExpressionFactory.cast((Type)typeVar, (GeneratedExpression)moduleClass.invoke("newInstance")));
        ifShouldAutoCreate._then().add((Statement)muleContext.invoke("getRegistry").invoke("registerObject").arg((GeneratedExpression)moduleClass.invoke("getName")).arg((GeneratedExpression)object));
        ifShouldAutoCreate._else()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ConfigurationException.class)).arg((GeneratedExpression)this.ref(MessageFactory.class).staticInvoke("createStaticMessage").arg("Cannot find object")));
        GeneratedConditional ifObjectIsString = findOrCreateMethod.body()._if(Op._instanceof((GeneratedExpression)object, (Type)this.ref(String.class)));
        ifObjectIsString._then().assign((AssignmentTarget)object, (GeneratedExpression)ExpressionFactory.cast((Type)typeVar, (GeneratedExpression)muleContext.invoke("getExpressionManager").invoke("evaluate").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)object)).arg((GeneratedExpression)muleEvent).arg(ExpressionFactory.TRUE)));
        ifObjectIsString._then()._if(object.isNull())._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ConfigurationException.class)).arg((GeneratedExpression)this.ref(MessageFactory.class).staticInvoke("createStaticMessage").arg("Cannot find object by config name")));
        return findOrCreateMethod;
    }

    private void generateOverwritePayloadMethod(GeneratedClass messageProcessorClass) {
        GeneratedMethod overwritePayload = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "overwritePayload");
        overwritePayload.javadoc().add((Object)"Overwrites the event payload with the specified one");
        overwritePayload._throws(this.ref(Exception.class));
        GeneratedVariable event = overwritePayload.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedVariable resultPayload = overwritePayload.param((Type)this.ref(Object.class), "resultPayload");
        GeneratedInvocation applyTransformers = event.invoke("getMessage").invoke("applyTransformers");
        applyTransformers.arg((GeneratedExpression)event);
        GeneratedInvocation newTransformerTemplate = ExpressionFactory._new((TypeReference)this.ref(TransformerTemplate.class));
        GeneratedVariable overwritePayloadCallback = overwritePayload.body().decl((Type)this.ref(TransformerTemplate.OverwitePayloadCallback.class), "overwritePayloadCallback", ExpressionFactory._null());
        GeneratedConditional ifPayloadIsNull = overwritePayload.body()._if(resultPayload.isNull());
        GeneratedInvocation newOverwritePayloadCallback = ExpressionFactory._new((TypeReference)this.ref(TransformerTemplate.OverwitePayloadCallback.class));
        newOverwritePayloadCallback.arg((GeneratedExpression)resultPayload);
        GeneratedInvocation newOverwritePayloadCallbackWithNull = ExpressionFactory._new((TypeReference)this.ref(TransformerTemplate.OverwitePayloadCallback.class));
        newOverwritePayloadCallbackWithNull.arg((GeneratedExpression)this.ref(NullPayload.class).staticInvoke("getInstance"));
        ifPayloadIsNull._else().assign((AssignmentTarget)overwritePayloadCallback, (GeneratedExpression)newOverwritePayloadCallback);
        ifPayloadIsNull._then().assign((AssignmentTarget)overwritePayloadCallback, (GeneratedExpression)newOverwritePayloadCallbackWithNull);
        newTransformerTemplate.arg((GeneratedExpression)overwritePayloadCallback);
        GeneratedVariable transformerList = overwritePayload.body().decl((Type)this.ref(List.class).narrow(Transformer.class), "transformerList");
        overwritePayload.body().assign((AssignmentTarget)transformerList, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(Transformer.class)));
        overwritePayload.body().add((Statement)transformerList.invoke("add").arg((GeneratedExpression)newTransformerTemplate));
        applyTransformers.arg((GeneratedExpression)transformerList);
        overwritePayload.body().add((Statement)applyTransformers);
    }
}

