/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.callback.SourceCallback;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.session.DefaultMuleSession;

@JustOnce
public class AbstractListeningMessageProcessorGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.ABSTRACT_MESSAGE_PROCESSOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.ABSTRACT_LISTENING_MESSAGE_PROCESSOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.hasProcessors() || module.hasSources();
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass abstractListeningMessageProcessorClass = this.getAbstractListeningMessageProcessorClass(module);
        GeneratedField messageProcessorListener = this.generateFieldForMessageProcessorListener(abstractListeningMessageProcessorClass);
        abstractListeningMessageProcessorClass.getter(messageProcessorListener);
        this.generateSetListenerMethod(abstractListeningMessageProcessorClass, messageProcessorListener);
        this.generateSourceCallbackProcessMethod(abstractListeningMessageProcessorClass, messageProcessorListener);
        this.generateSourceCallbackProcessWithPropertiesMethod(abstractListeningMessageProcessorClass, messageProcessorListener);
        this.generateSourceCallbackProcessMethodWithNoPayload(abstractListeningMessageProcessorClass, messageProcessorListener);
    }

    private GeneratedClass getAbstractListeningMessageProcessorClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".processors");
        GeneratedClass abstractMessageProcessor = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_MESSAGE_PROCESSOR);
        GeneratedClass clazz = pkg._class(33, "AbstractListeningMessageProcessor");
        TypeVariable o = clazz.generify("O");
        clazz._extends(abstractMessageProcessor.narrow((TypeReference)o));
        clazz._implements(this.ref(SourceCallback.class));
        this.ctx().registerProduct(Product.ABSTRACT_LISTENING_MESSAGE_PROCESSOR, (Object)clazz);
        return clazz;
    }

    private GeneratedField generateFieldForMessageProcessorListener(GeneratedClass abstractListeningMessageProcessorClass) {
        GeneratedField messageProcessor = abstractListeningMessageProcessorClass.field(4, (Type)this.ref(MessageProcessor.class), "messageProcessor");
        messageProcessor.javadoc().add((Object)"Message processor that will get called for processing incoming events");
        return messageProcessor;
    }

    private GeneratedMethod generateSetListenerMethod(GeneratedClass abstractListeningMessageProcessorClass, GeneratedField messageProcessor) {
        GeneratedMethod setListener = abstractListeningMessageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setListener");
        setListener.javadoc().add((Object)"Sets the message processor that will \"listen\" the events generated by this message source");
        setListener.javadoc().addParam("listener Message processor");
        GeneratedVariable listener = setListener.param((Type)this.ref(MessageProcessor.class), "listener");
        setListener.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)messageProcessor), (GeneratedExpression)listener);
        return setListener;
    }

    private void generateSourceCallbackProcessMethod(GeneratedClass abstractListeningMessageProcessorClass, GeneratedField messageProcessor) {
        GeneratedMethod process = abstractListeningMessageProcessorClass.method(1, (Type)this.ref(Object.class), "process");
        process.javadoc().add((Object)"Implements {@link SourceCallback#process(org.mule.api.MuleEvent)}. This message source will be passed on to ");
        process.javadoc().add((Object)"the actual pojo's method as a callback mechanism.");
        process._throws(this.ref(Exception.class));
        GeneratedVariable message = process.param((Type)this.ref(Object.class), "message");
        GeneratedVariable muleMessage = process.body().decl((Type)this.ref(MuleMessage.class), "muleMessage");
        GeneratedInvocation newMuleMessage = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleMessage.class));
        newMuleMessage.arg((GeneratedExpression)message);
        newMuleMessage.arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"));
        process.body().assign((AssignmentTarget)muleMessage, (GeneratedExpression)newMuleMessage);
        GeneratedVariable muleSession = process.body().decl((Type)this.ref(MuleSession.class), "muleSession");
        GeneratedInvocation newMuleSession = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleSession.class));
        newMuleSession.arg((GeneratedExpression)ExpressionFactory.invoke((String)"getFlowConstruct"));
        newMuleSession.arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"));
        process.body().assign((AssignmentTarget)muleSession, (GeneratedExpression)newMuleSession);
        GeneratedVariable muleEvent = process.body().decl((Type)this.ref(MuleEvent.class), "muleEvent");
        GeneratedInvocation newMuleEvent = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleEvent.class));
        newMuleEvent.arg((GeneratedExpression)muleMessage);
        newMuleEvent.arg((GeneratedExpression)this.ref(MessageExchangePattern.class).staticRef("ONE_WAY"));
        newMuleEvent.arg((GeneratedExpression)muleSession);
        process.body().assign((AssignmentTarget)muleEvent, (GeneratedExpression)newMuleEvent);
        GeneratedTry tryBlock = process.body()._try();
        GeneratedVariable responseEvent = tryBlock.body().decl((Type)this.ref(MuleEvent.class), "responseEvent");
        GeneratedInvocation messageProcess = messageProcessor.invoke("process");
        messageProcess.arg((GeneratedExpression)muleEvent);
        tryBlock.body().assign((AssignmentTarget)responseEvent, (GeneratedExpression)messageProcess);
        GeneratedConditional ifResponse = tryBlock.body()._if(Op.cand((GeneratedExpression)responseEvent.isNotNull(), (GeneratedExpression)responseEvent.invoke("getMessage").isNotNull()));
        ifResponse._then()._return((GeneratedExpression)responseEvent.invoke("getMessage").invoke("getPayload"));
        GeneratedCatchBlock catchException = tryBlock._catch(this.ref(Exception.class));
        GeneratedVariable exception = catchException.param("e");
        catchException.body()._throw((GeneratedExpression)exception);
        process.body()._return(ExpressionFactory._null());
    }

    private void generateSourceCallbackProcessMethodWithNoPayload(GeneratedClass abstractListeningMessageProcessorClass, GeneratedField messageProcessor) {
        GeneratedMethod process = abstractListeningMessageProcessorClass.method(1, (Type)this.ref(Object.class), "process");
        process.javadoc().add((Object)"Implements {@link SourceCallback#process()}. This message source will be passed on to ");
        process.javadoc().add((Object)"the actual pojo's method as a callback mechanism.");
        process._throws(this.ref(Exception.class));
        GeneratedTry tryBlock = process.body()._try();
        GeneratedVariable responseEvent = tryBlock.body().decl((Type)this.ref(MuleEvent.class), "responseEvent");
        GeneratedInvocation messageProcess = messageProcessor.invoke("process");
        messageProcess.arg((GeneratedExpression)this.ref(RequestContext.class).staticInvoke("getEvent"));
        tryBlock.body().assign((AssignmentTarget)responseEvent, (GeneratedExpression)messageProcess);
        GeneratedConditional ifResponse = tryBlock.body()._if(Op.cand((GeneratedExpression)responseEvent.isNotNull(), (GeneratedExpression)responseEvent.invoke("getMessage").isNotNull()));
        ifResponse._then()._return((GeneratedExpression)responseEvent.invoke("getMessage").invoke("getPayload"));
        GeneratedCatchBlock catchException = tryBlock._catch(this.ref(Exception.class));
        GeneratedVariable exception = catchException.param("e");
        catchException.body()._throw((GeneratedExpression)exception);
        process.body()._return(ExpressionFactory._null());
    }

    private void generateSourceCallbackProcessWithPropertiesMethod(GeneratedClass abstractListeningMessageProcessorClass, GeneratedField messageProcessor) {
        GeneratedMethod process = abstractListeningMessageProcessorClass.method(1, (Type)this.ref(Object.class), "process");
        process.javadoc().add((Object)"Implements {@link SourceCallback#process(org.mule.api.MuleEvent)}. This message source will be passed on to ");
        process.javadoc().add((Object)"the actual pojo's method as a callback mechanism.");
        process._throws(this.ref(Exception.class));
        GeneratedVariable message = process.param((Type)this.ref(Object.class), "message");
        GeneratedVariable properties = process.param((Type)this.ref(Map.class).narrow(String.class).narrow(Object.class), "properties");
        GeneratedVariable muleMessage = process.body().decl((Type)this.ref(MuleMessage.class), "muleMessage");
        GeneratedInvocation newMuleMessage = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleMessage.class));
        newMuleMessage.arg((GeneratedExpression)message);
        newMuleMessage.arg((GeneratedExpression)properties);
        newMuleMessage.arg(ExpressionFactory._null());
        newMuleMessage.arg(ExpressionFactory._null());
        newMuleMessage.arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"));
        process.body().assign((AssignmentTarget)muleMessage, (GeneratedExpression)newMuleMessage);
        GeneratedVariable muleSession = process.body().decl((Type)this.ref(MuleSession.class), "muleSession");
        GeneratedInvocation newMuleSession = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleSession.class));
        newMuleSession.arg((GeneratedExpression)ExpressionFactory.invoke((String)"getFlowConstruct"));
        newMuleSession.arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"));
        process.body().assign((AssignmentTarget)muleSession, (GeneratedExpression)newMuleSession);
        GeneratedVariable muleEvent = process.body().decl((Type)this.ref(MuleEvent.class), "muleEvent");
        GeneratedInvocation newMuleEvent = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleEvent.class));
        newMuleEvent.arg((GeneratedExpression)muleMessage);
        newMuleEvent.arg((GeneratedExpression)this.ref(MessageExchangePattern.class).staticRef("ONE_WAY"));
        newMuleEvent.arg((GeneratedExpression)muleSession);
        process.body().assign((AssignmentTarget)muleEvent, (GeneratedExpression)newMuleEvent);
        GeneratedTry tryBlock = process.body()._try();
        GeneratedVariable responseEvent = tryBlock.body().decl((Type)this.ref(MuleEvent.class), "responseEvent");
        GeneratedInvocation messageProcess = messageProcessor.invoke("process");
        messageProcess.arg((GeneratedExpression)muleEvent);
        tryBlock.body().assign((AssignmentTarget)responseEvent, (GeneratedExpression)messageProcess);
        GeneratedConditional ifResponse = tryBlock.body()._if(Op.cand((GeneratedExpression)responseEvent.isNotNull(), (GeneratedExpression)responseEvent.invoke("getMessage").isNotNull()));
        ifResponse._then()._return((GeneratedExpression)responseEvent.invoke("getMessage").invoke("getPayload"));
        GeneratedCatchBlock catchException = tryBlock._catch(this.ref(Exception.class));
        GeneratedVariable exception = catchException.param("e");
        catchException.body()._throw((GeneratedExpression)exception);
        process.body()._return(ExpressionFactory._null());
    }
}

