/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedForLoop;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.TemplateParser;

@JustOnce
public class AbstractExpressionEvaluatorGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(new Product[0]);
    private static final List<Product> PRODUCES = Arrays.asList(Product.ABSTRACT_EXPRESSION_EVALUATOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC || module.getKind() == ModuleKind.EXPRESSION_LANGUAGE;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass abstractExpressionEvaluatorClass = this.getAbstractExpressionEvaluatorClass(module);
        this.generateComputeClassHierarchyMethod(abstractExpressionEvaluatorClass);
        this.generateIsListClassMethod(abstractExpressionEvaluatorClass);
        this.generateIsMapClassMethod(abstractExpressionEvaluatorClass);
        this.generateIsListMethod(abstractExpressionEvaluatorClass);
        this.generateIsMapMethod(abstractExpressionEvaluatorClass);
        this.generateIsAssignableFrom(abstractExpressionEvaluatorClass);
        this.generateEvaluateMethod(abstractExpressionEvaluatorClass);
        this.generateEvaluateAndTransformMethod(abstractExpressionEvaluatorClass);
        this.generateTransformMethod(abstractExpressionEvaluatorClass);
        this.generateTransformWithMimeMethod(abstractExpressionEvaluatorClass);
    }

    private GeneratedClass getAbstractExpressionEvaluatorClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".processors");
        GeneratedClass clazz = pkg._class(33, "AbstractExpressionEvaluator");
        this.ctx().registerProduct(Product.ABSTRACT_EXPRESSION_EVALUATOR, (Object)clazz);
        return clazz;
    }

    private void generateComputeClassHierarchyMethod(GeneratedClass abstractExpressionEvaluatorClass) {
        GeneratedMethod computeClassHierarchy = abstractExpressionEvaluatorClass.method(2, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "computeClassHierarchy");
        computeClassHierarchy.javadoc().add((Object)"Get all superclasses and interfaces recursively.");
        computeClassHierarchy.javadoc().addParam("clazz   The class to start the search with.");
        computeClassHierarchy.javadoc().addParam("classes List of classes to which to add all found super classes and interfaces.");
        GeneratedVariable clazz = computeClassHierarchy.param(Class.class, "clazz");
        GeneratedVariable classes = computeClassHierarchy.param(List.class, "classes");
        GeneratedForLoop iterateClasses = computeClassHierarchy.body()._for();
        GeneratedVariable current = iterateClasses.init((org.mule.devkit.model.code.Type)this.ref(Class.class), "current", (GeneratedExpression)clazz);
        iterateClasses.test(current.isNotNull());
        iterateClasses.update(current.assign((GeneratedExpression)current.invoke("getSuperclass")));
        GeneratedBlock ifContains = iterateClasses.body()._if((GeneratedExpression)classes.invoke("contains").arg((GeneratedExpression)current))._then();
        ifContains._return();
        iterateClasses.body().add((Statement)classes.invoke("add").arg((GeneratedExpression)current));
        GeneratedForEach iterateInterfaces = iterateClasses.body().forEach((org.mule.devkit.model.code.Type)this.ref(Class.class), "currentInterface", (GeneratedExpression)current.invoke("getInterfaces"));
        iterateInterfaces.body().invoke("computeClassHierarchy").arg((GeneratedExpression)iterateInterfaces.var()).arg((GeneratedExpression)classes);
    }

    private void generateIsListClassMethod(GeneratedClass abstractExpressionEvaluatorClass) {
        GeneratedMethod isListClass = abstractExpressionEvaluatorClass.method(2, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().BOOLEAN, "isListClass");
        isListClass.javadoc().add((Object)"Checks whether the specified class parameter is an instance of ");
        isListClass.javadoc().add((Object)this.ref(List.class));
        isListClass.javadoc().addParam("clazz <code>Class</code> to check.");
        isListClass.javadoc().addReturn("<code>true</code> is <code>clazz</code> is instance of a collection class, <code>false</code> otherwise.");
        GeneratedVariable clazz = isListClass.param((org.mule.devkit.model.code.Type)this.ref(Class.class), "clazz");
        GeneratedVariable classes = isListClass.body().decl((org.mule.devkit.model.code.Type)this.ref(List.class).narrow(this.ref(Class.class)), "classes", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(this.ref(Class.class))));
        isListClass.body().invoke("computeClassHierarchy").arg((GeneratedExpression)clazz).arg((GeneratedExpression)classes);
        isListClass.body()._return((GeneratedExpression)classes.invoke("contains").arg(this.ref(List.class).dotclass()));
    }

    private void generateIsMapClassMethod(GeneratedClass abstractExpressionEvaluatorClass) {
        GeneratedMethod isMapClass = abstractExpressionEvaluatorClass.method(2, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().BOOLEAN, "isMapClass");
        isMapClass.javadoc().add((Object)"Checks whether the specified class parameter is an instance of ");
        isMapClass.javadoc().add((Object)this.ref(Map.class));
        isMapClass.javadoc().addParam("clazz <code>Class</code> to check.");
        isMapClass.javadoc().addReturn("<code>true</code> is <code>clazz</code> is instance of a collection class, <code>false</code> otherwise.");
        GeneratedVariable clazz = isMapClass.param((org.mule.devkit.model.code.Type)this.ref(Class.class), "clazz");
        GeneratedVariable classes = isMapClass.body().decl((org.mule.devkit.model.code.Type)this.ref(List.class).narrow(this.ref(Class.class)), "classes", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(this.ref(Class.class))));
        isMapClass.body().invoke("computeClassHierarchy").arg((GeneratedExpression)clazz).arg((GeneratedExpression)classes);
        isMapClass.body()._return((GeneratedExpression)classes.invoke("contains").arg(this.ref(Map.class).dotclass()));
    }

    private void generateIsListMethod(GeneratedClass abstractExpressionEvaluatorClass) {
        GeneratedMethod isList = abstractExpressionEvaluatorClass.method(2, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().BOOLEAN, "isList");
        GeneratedVariable type = isList.param((org.mule.devkit.model.code.Type)this.ref(Type.class), "type");
        GeneratedConditional isClass = isList.body()._if(Op.cand((GeneratedExpression)Op._instanceof((GeneratedExpression)type, (org.mule.devkit.model.code.Type)this.ref(Class.class)), (GeneratedExpression)ExpressionFactory.invoke((String)"isListClass").arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)type))));
        isClass._then()._return(ExpressionFactory.TRUE);
        GeneratedConditional isParameterizedType = isList.body()._if(Op._instanceof((GeneratedExpression)type, (org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class)));
        isParameterizedType._then()._return((GeneratedExpression)ExpressionFactory.invoke((String)"isList").arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (GeneratedExpression)type).invoke("getRawType")));
        GeneratedConditional isWildcardType = isList.body()._if(Op._instanceof((GeneratedExpression)type, (org.mule.devkit.model.code.Type)this.ref(WildcardType.class)));
        GeneratedVariable upperBounds = isWildcardType._then().decl((org.mule.devkit.model.code.Type)this.ref(Type.class).array(), "upperBounds", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(WildcardType.class), (GeneratedExpression)type).invoke("getUpperBounds"));
        isWildcardType._then()._return(Op.cand((GeneratedExpression)Op.ne((GeneratedExpression)upperBounds.ref("length"), (GeneratedExpression)ExpressionFactory.lit((int)0)), (GeneratedExpression)ExpressionFactory.invoke((String)"isList").arg((GeneratedExpression)upperBounds.component(ExpressionFactory.lit((int)0)))));
        isList.body()._return(ExpressionFactory.FALSE);
    }

    private void generateIsMapMethod(GeneratedClass abstractExpressionEvaluatorClass) {
        GeneratedMethod isMap = abstractExpressionEvaluatorClass.method(2, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().BOOLEAN, "isMap");
        GeneratedVariable type = isMap.param((org.mule.devkit.model.code.Type)this.ref(Type.class), "type");
        GeneratedConditional isClass = isMap.body()._if(Op.cand((GeneratedExpression)Op._instanceof((GeneratedExpression)type, (org.mule.devkit.model.code.Type)this.ref(Class.class)), (GeneratedExpression)ExpressionFactory.invoke((String)"isMapClass").arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)type))));
        isClass._then()._return(ExpressionFactory.TRUE);
        GeneratedConditional isParameterizedType = isMap.body()._if(Op._instanceof((GeneratedExpression)type, (org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class)));
        isParameterizedType._then()._return((GeneratedExpression)ExpressionFactory.invoke((String)"isMap").arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (GeneratedExpression)type).invoke("getRawType")));
        GeneratedConditional isWildcardType = isMap.body()._if(Op._instanceof((GeneratedExpression)type, (org.mule.devkit.model.code.Type)this.ref(WildcardType.class)));
        GeneratedVariable upperBounds = isWildcardType._then().decl((org.mule.devkit.model.code.Type)this.ref(Type.class).array(), "upperBounds", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(WildcardType.class), (GeneratedExpression)type).invoke("getUpperBounds"));
        isWildcardType._then()._return(Op.cand((GeneratedExpression)Op.ne((GeneratedExpression)upperBounds.ref("length"), (GeneratedExpression)ExpressionFactory.lit((int)0)), (GeneratedExpression)ExpressionFactory.invoke((String)"isMap").arg((GeneratedExpression)upperBounds.component(ExpressionFactory.lit((int)0)))));
        isMap.body()._return(ExpressionFactory.FALSE);
    }

    private void generateIsAssignableFrom(GeneratedClass abstractExpressionEvaluatorClass) {
        GeneratedMethod isAssignableFrom = abstractExpressionEvaluatorClass.method(2, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().BOOLEAN, "isAssignableFrom");
        GeneratedVariable expectedType = isAssignableFrom.param((org.mule.devkit.model.code.Type)this.ref(Type.class), "expectedType");
        GeneratedVariable clazz = isAssignableFrom.param((org.mule.devkit.model.code.Type)this.ref(Class.class), "clazz");
        GeneratedBlock isClass = isAssignableFrom.body()._if(Op._instanceof((GeneratedExpression)expectedType, (org.mule.devkit.model.code.Type)this.ref(Class.class)))._then();
        GeneratedConditional isPrimitive = isClass._if((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType).invoke("isPrimitive"));
        isPrimitive._then()._if(Op.cand((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType).invoke("getName").invoke("equals").arg(ExpressionFactory.lit((String)"boolean")), (GeneratedExpression)Op.eq((GeneratedExpression)clazz, (GeneratedExpression)this.ref(Boolean.class).dotclass())))._then()._return(ExpressionFactory.TRUE);
        isPrimitive._then()._if(Op.cand((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType).invoke("getName").invoke("equals").arg(ExpressionFactory.lit((String)"byte")), (GeneratedExpression)Op.eq((GeneratedExpression)clazz, (GeneratedExpression)this.ref(Byte.class).dotclass())))._then()._return(ExpressionFactory.TRUE);
        isPrimitive._then()._if(Op.cand((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType).invoke("getName").invoke("equals").arg(ExpressionFactory.lit((String)"short")), (GeneratedExpression)Op.eq((GeneratedExpression)clazz, (GeneratedExpression)this.ref(Short.class).dotclass())))._then()._return(ExpressionFactory.TRUE);
        isPrimitive._then()._if(Op.cand((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType).invoke("getName").invoke("equals").arg(ExpressionFactory.lit((String)"char")), (GeneratedExpression)Op.eq((GeneratedExpression)clazz, (GeneratedExpression)this.ref(Character.class).dotclass())))._then()._return(ExpressionFactory.TRUE);
        isPrimitive._then()._if(Op.cand((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType).invoke("getName").invoke("equals").arg(ExpressionFactory.lit((String)"int")), (GeneratedExpression)Op.eq((GeneratedExpression)clazz, (GeneratedExpression)this.ref(Integer.class).dotclass())))._then()._return(ExpressionFactory.TRUE);
        isPrimitive._then()._if(Op.cand((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType).invoke("getName").invoke("equals").arg(ExpressionFactory.lit((String)"float")), (GeneratedExpression)Op.eq((GeneratedExpression)clazz, (GeneratedExpression)this.ref(Float.class).dotclass())))._then()._return(ExpressionFactory.TRUE);
        isPrimitive._then()._if(Op.cand((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType).invoke("getName").invoke("equals").arg(ExpressionFactory.lit((String)"long")), (GeneratedExpression)Op.eq((GeneratedExpression)clazz, (GeneratedExpression)this.ref(Long.class).dotclass())))._then()._return(ExpressionFactory.TRUE);
        isPrimitive._then()._if(Op.cand((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType).invoke("getName").invoke("equals").arg(ExpressionFactory.lit((String)"double")), (GeneratedExpression)Op.eq((GeneratedExpression)clazz, (GeneratedExpression)this.ref(Double.class).dotclass())))._then()._return(ExpressionFactory.TRUE);
        isPrimitive._then()._return(ExpressionFactory.FALSE);
        isPrimitive._else()._return((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType).invoke("isAssignableFrom").arg((GeneratedExpression)clazz));
        GeneratedBlock isParameterizedType = isAssignableFrom.body()._if(Op._instanceof((GeneratedExpression)expectedType, (org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class)))._then();
        isParameterizedType._return((GeneratedExpression)ExpressionFactory.invoke((String)"isAssignableFrom").arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (GeneratedExpression)expectedType).invoke("getRawType")).arg((GeneratedExpression)clazz));
        GeneratedBlock isWildcardType = isAssignableFrom.body()._if(Op._instanceof((GeneratedExpression)expectedType, (org.mule.devkit.model.code.Type)this.ref(WildcardType.class)))._then();
        GeneratedVariable upperBounds = isWildcardType.decl((org.mule.devkit.model.code.Type)this.ref(Type.class).array(), "upperBounds", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(WildcardType.class), (GeneratedExpression)expectedType).invoke("getUpperBounds"));
        GeneratedBlock ifHasUpperBounds = isWildcardType._if(Op.ne((GeneratedExpression)upperBounds.ref("length"), (GeneratedExpression)ExpressionFactory.lit((int)0)))._then();
        ifHasUpperBounds._return((GeneratedExpression)ExpressionFactory.invoke((String)"isAssignableFrom").arg((GeneratedExpression)upperBounds.component(ExpressionFactory.lit((int)0))).arg((GeneratedExpression)clazz));
        isAssignableFrom.body()._return(ExpressionFactory.FALSE);
    }

    private void generateEvaluateMethod(GeneratedClass abstractExpressionEvaluatorClass) {
        GeneratedMethod evaluate = abstractExpressionEvaluatorClass.method(2, (org.mule.devkit.model.code.Type)this.ref(Object.class), "evaluate");
        GeneratedVariable patternInfo = evaluate.param((org.mule.devkit.model.code.Type)this.ref(TemplateParser.PatternInfo.class), "patternInfo");
        GeneratedVariable expressionManager = evaluate.param((org.mule.devkit.model.code.Type)this.ref(ExpressionManager.class), "expressionManager");
        GeneratedVariable muleMessage = evaluate.param((org.mule.devkit.model.code.Type)this.ref(MuleMessage.class), "muleMessage");
        GeneratedVariable source = evaluate.param((org.mule.devkit.model.code.Type)this.ref(Object.class), "source");
        GeneratedBlock ifString = evaluate.body()._if(Op._instanceof((GeneratedExpression)source, (org.mule.devkit.model.code.Type)this.ref(String.class)))._then();
        GeneratedVariable stringSource = ifString.decl((org.mule.devkit.model.code.Type)this.ref(String.class), "stringSource", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(String.class), (GeneratedExpression)source));
        GeneratedConditional isPattern = ifString._if(Op.cand((GeneratedExpression)stringSource.invoke("startsWith").arg((GeneratedExpression)patternInfo.invoke("getPrefix")), (GeneratedExpression)stringSource.invoke("endsWith").arg((GeneratedExpression)patternInfo.invoke("getSuffix"))));
        isPattern._then()._return((GeneratedExpression)expressionManager.invoke("evaluate").arg((GeneratedExpression)stringSource).arg((GeneratedExpression)muleMessage));
        isPattern._else()._return((GeneratedExpression)expressionManager.invoke("parse").arg((GeneratedExpression)stringSource).arg((GeneratedExpression)muleMessage));
        evaluate.body()._return((GeneratedExpression)source);
    }

    private void generateEvaluateAndTransformMethod(GeneratedClass abstractExpressionEvaluatorClass) {
        GeneratedMethod evaluateAndTransform = abstractExpressionEvaluatorClass.method(2, (org.mule.devkit.model.code.Type)this.ref(Object.class), "evaluateAndTransform");
        evaluateAndTransform._throws(this.ref(TransformerException.class));
        evaluateAndTransform._throws(this.ref(TransformerMessagingException.class));
        GeneratedVariable muleContext = evaluateAndTransform.param((org.mule.devkit.model.code.Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable muleEvent = evaluateAndTransform.param((org.mule.devkit.model.code.Type)this.ref(MuleEvent.class), "event");
        GeneratedVariable expectedType = evaluateAndTransform.param((org.mule.devkit.model.code.Type)this.ref(Type.class), "expectedType");
        GeneratedVariable expectedMimeType = evaluateAndTransform.param((org.mule.devkit.model.code.Type)this.ref(String.class), "expectedMimeType");
        GeneratedVariable source = evaluateAndTransform.param((org.mule.devkit.model.code.Type)this.ref(Object.class), "source");
        evaluateAndTransform.body()._if(source.isNull())._then()._return((GeneratedExpression)source);
        GeneratedVariable target = evaluateAndTransform.body().decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "target", ExpressionFactory._null());
        GeneratedConditional isList = evaluateAndTransform.body()._if((GeneratedExpression)ExpressionFactory.invoke((String)"isList").arg((GeneratedExpression)source.invoke("getClass")));
        GeneratedConditional isExpectedList = isList._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"isList").arg((GeneratedExpression)expectedType));
        GeneratedVariable newList = isExpectedList._then().decl((org.mule.devkit.model.code.Type)this.ref(List.class), "newList", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class)));
        GeneratedVariable listParameterizedType = isExpectedList._then().decl((org.mule.devkit.model.code.Type)this.ref(Type.class), "valueType", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (GeneratedExpression)expectedType).invoke("getActualTypeArguments").component(ExpressionFactory.lit((int)0)));
        GeneratedVariable listIterator = isExpectedList._then().decl((org.mule.devkit.model.code.Type)this.ref(ListIterator.class), "iterator", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(List.class), (GeneratedExpression)source).invoke("listIterator"));
        GeneratedBlock whileHasNext = isExpectedList._then()._while((GeneratedExpression)listIterator.invoke("hasNext")).body();
        GeneratedVariable subTarget = whileHasNext.decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "subTarget", (GeneratedExpression)listIterator.invoke("next"));
        whileHasNext.add((Statement)newList.invoke("add").arg((GeneratedExpression)ExpressionFactory.invoke((String)"evaluateAndTransform").arg((GeneratedExpression)muleContext).arg((GeneratedExpression)muleEvent).arg((GeneratedExpression)listParameterizedType).arg((GeneratedExpression)expectedMimeType).arg((GeneratedExpression)subTarget)));
        isExpectedList._then().assign((AssignmentTarget)target, (GeneratedExpression)newList);
        isExpectedList._else().assign((AssignmentTarget)target, (GeneratedExpression)source);
        GeneratedConditional isMap = isList._elseif((GeneratedExpression)ExpressionFactory.invoke((String)"isMap").arg((GeneratedExpression)source.invoke("getClass")));
        GeneratedConditional isExpectedMap = isMap._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"isMap").arg((GeneratedExpression)expectedType));
        GeneratedBlock isExpectedMapBlock = isExpectedMap._then();
        GeneratedVariable keyType = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Type.class), "keyType", this.ref(Object.class).dotclass());
        GeneratedVariable valueType = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Type.class), "valueType", this.ref(Object.class).dotclass());
        GeneratedBlock isGenericMap = isExpectedMapBlock._if(Op._instanceof((GeneratedExpression)expectedType, (org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class)))._then();
        isGenericMap.assign((AssignmentTarget)keyType, (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (GeneratedExpression)expectedType).invoke("getActualTypeArguments").component(ExpressionFactory.lit((int)0)));
        isGenericMap.assign((AssignmentTarget)valueType, (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (GeneratedExpression)expectedType).invoke("getActualTypeArguments").component(ExpressionFactory.lit((int)1)));
        GeneratedVariable map = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Map.class), "map", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Map.class), (GeneratedExpression)source));
        GeneratedVariable newMap = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Map.class), "newMap", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HashMap.class)));
        GeneratedForEach forEach = isExpectedMapBlock.forEach((org.mule.devkit.model.code.Type)this.ref(Object.class), "entryObj", (GeneratedExpression)map.invoke("entrySet"));
        GeneratedBlock forEachBlock = forEach.body().block();
        GeneratedVariable entry = forEachBlock.decl((org.mule.devkit.model.code.Type)this.ref(Map.Entry.class), "entry", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Map.Entry.class), (GeneratedExpression)forEach.var()));
        GeneratedVariable newKey = forEachBlock.decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "newKey", (GeneratedExpression)ExpressionFactory.invoke((String)"evaluateAndTransform").arg((GeneratedExpression)muleContext).arg((GeneratedExpression)muleEvent).arg((GeneratedExpression)keyType).arg((GeneratedExpression)expectedMimeType).arg((GeneratedExpression)entry.invoke("getKey")));
        GeneratedVariable newValue = forEachBlock.decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "newValue", (GeneratedExpression)ExpressionFactory.invoke((String)"evaluateAndTransform").arg((GeneratedExpression)muleContext).arg((GeneratedExpression)muleEvent).arg((GeneratedExpression)valueType).arg((GeneratedExpression)expectedMimeType).arg((GeneratedExpression)entry.invoke("getValue")));
        forEachBlock.invoke((GeneratedExpression)newMap, "put").arg((GeneratedExpression)newKey).arg((GeneratedExpression)newValue);
        isExpectedMapBlock.assign((AssignmentTarget)target, (GeneratedExpression)newMap);
        isExpectedMap._else().assign((AssignmentTarget)target, (GeneratedExpression)source);
        GeneratedBlock otherwise = isMap._else();
        otherwise.assign((AssignmentTarget)target, (GeneratedExpression)ExpressionFactory.invoke((String)"evaluate").arg((GeneratedExpression)this.ref(TemplateParser.class).staticInvoke("createMuleStyleParser").invoke("getStyle")).arg((GeneratedExpression)muleContext.invoke("getExpressionManager")).arg((GeneratedExpression)muleEvent.invoke("getMessage")).arg((GeneratedExpression)source));
        evaluateAndTransform.body()._return((GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)muleContext).arg((GeneratedExpression)muleEvent).arg((GeneratedExpression)expectedType).arg((GeneratedExpression)expectedMimeType).arg((GeneratedExpression)target));
    }

    private void generateTransformWithMimeMethod(GeneratedClass abstractExpressionEvaluatorClass) {
        GeneratedMethod transform = abstractExpressionEvaluatorClass.method(2, (org.mule.devkit.model.code.Type)this.ref(Object.class), "transform");
        GeneratedVariable muleContext = transform.param((org.mule.devkit.model.code.Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable muleEvent = transform.param((org.mule.devkit.model.code.Type)this.ref(MuleEvent.class), "event");
        GeneratedVariable expectedType = transform.param((org.mule.devkit.model.code.Type)this.ref(Type.class), "expectedType");
        GeneratedVariable expectedMimeType = transform.param((org.mule.devkit.model.code.Type)this.ref(String.class), "expectedMimeType");
        GeneratedVariable source = transform.param((org.mule.devkit.model.code.Type)this.ref(Object.class), "source");
        transform._throws(this.ref(TransformerException.class));
        transform._throws(this.ref(TransformerMessagingException.class));
        GeneratedConditional shouldTransform = transform.body()._if(Op.cand((GeneratedExpression)source.isNotNull(), (GeneratedExpression)Op.not((GeneratedExpression)ExpressionFactory.invoke((String)"isAssignableFrom").arg((GeneratedExpression)expectedType).arg((GeneratedExpression)source.invoke("getClass")))));
        GeneratedVariable sourceDataType = shouldTransform._then().decl((org.mule.devkit.model.code.Type)this.ref(DataType.class), "sourceDataType", (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg((GeneratedExpression)source.invoke("getClass")));
        GeneratedVariable targetDataType = shouldTransform._then().decl((org.mule.devkit.model.code.Type)this.ref(DataType.class), "targetDataType", ExpressionFactory._null());
        GeneratedConditional ifParameterizedType = shouldTransform._then()._if(Op._instanceof((GeneratedExpression)expectedType, (org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class)));
        ifParameterizedType._then().assign((AssignmentTarget)expectedType, (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (GeneratedExpression)expectedType).invoke("getRawType"));
        GeneratedConditional ifExpectedMimeTypeNotNull = shouldTransform._then()._if(expectedMimeType.isNotNull());
        ifExpectedMimeTypeNotNull._then().assign((AssignmentTarget)targetDataType, (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType)).arg((GeneratedExpression)expectedMimeType));
        ifExpectedMimeTypeNotNull._else().assign((AssignmentTarget)targetDataType, (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType)));
        GeneratedVariable transformer = shouldTransform._then().decl((org.mule.devkit.model.code.Type)this.ref(Transformer.class), "t", (GeneratedExpression)muleContext.invoke("getRegistry").invoke("lookupTransformer").arg((GeneratedExpression)sourceDataType).arg((GeneratedExpression)targetDataType));
        GeneratedConditional ifMessageTransformer = shouldTransform._then()._if(Op._instanceof((GeneratedExpression)transformer, (org.mule.devkit.model.code.Type)this.ref(MessageTransformer.class)));
        ifMessageTransformer._then()._return((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(MessageTransformer.class), (GeneratedExpression)transformer).invoke("transform").arg((GeneratedExpression)source).arg((GeneratedExpression)muleEvent));
        ifMessageTransformer._else()._return((GeneratedExpression)transformer.invoke("transform").arg((GeneratedExpression)source));
        shouldTransform._else()._return((GeneratedExpression)source);
    }

    private void generateTransformMethod(GeneratedClass abstractExpressionEvaluatorClass) {
        GeneratedMethod transform = abstractExpressionEvaluatorClass.method(2, (org.mule.devkit.model.code.Type)this.ref(Object.class), "transform");
        transform._throws(this.ref(TransformerException.class));
        GeneratedVariable muleMessage = transform.param((org.mule.devkit.model.code.Type)this.ref(MuleMessage.class), "muleMessage");
        GeneratedVariable expectedType = transform.param((org.mule.devkit.model.code.Type)this.ref(Type.class), "expectedType");
        GeneratedVariable source = transform.param((org.mule.devkit.model.code.Type)this.ref(Object.class), "source");
        transform.body()._if(source.isNull())._then()._return((GeneratedExpression)source);
        GeneratedVariable target = transform.body().decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "target", ExpressionFactory._null());
        GeneratedConditional isList = transform.body()._if((GeneratedExpression)ExpressionFactory.invoke((String)"isList").arg((GeneratedExpression)source.invoke("getClass")));
        GeneratedConditional isExpectedList = isList._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"isList").arg((GeneratedExpression)expectedType));
        GeneratedVariable newList = isExpectedList._then().decl((org.mule.devkit.model.code.Type)this.ref(List.class), "newList", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class)));
        GeneratedVariable listParameterizedType = isExpectedList._then().decl((org.mule.devkit.model.code.Type)this.ref(Type.class), "valueType", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (GeneratedExpression)expectedType).invoke("getActualTypeArguments").component(ExpressionFactory.lit((int)0)));
        GeneratedVariable listIterator = isExpectedList._then().decl((org.mule.devkit.model.code.Type)this.ref(ListIterator.class), "iterator", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(List.class), (GeneratedExpression)source).invoke("listIterator"));
        GeneratedBlock whileHasNext = isExpectedList._then()._while((GeneratedExpression)listIterator.invoke("hasNext")).body();
        GeneratedVariable subTarget = whileHasNext.decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "subTarget", (GeneratedExpression)listIterator.invoke("next"));
        whileHasNext.add((Statement)newList.invoke("add").arg((GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)muleMessage).arg((GeneratedExpression)listParameterizedType).arg((GeneratedExpression)subTarget)));
        isExpectedList._then().assign((AssignmentTarget)target, (GeneratedExpression)newList);
        isExpectedList._else().assign((AssignmentTarget)target, (GeneratedExpression)source);
        GeneratedConditional isMap = isList._elseif((GeneratedExpression)ExpressionFactory.invoke((String)"isMap").arg((GeneratedExpression)source.invoke("getClass")));
        GeneratedConditional isExpectedMap = isMap._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"isMap").arg((GeneratedExpression)expectedType));
        GeneratedBlock isExpectedMapBlock = isExpectedMap._then();
        GeneratedVariable keyType = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Type.class), "keyType", this.ref(Object.class).dotclass());
        GeneratedVariable valueType = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Type.class), "valueType", this.ref(Object.class).dotclass());
        GeneratedBlock isGenericMap = isExpectedMapBlock._if(Op._instanceof((GeneratedExpression)expectedType, (org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class)))._then();
        isGenericMap.assign((AssignmentTarget)keyType, (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (GeneratedExpression)expectedType).invoke("getActualTypeArguments").component(ExpressionFactory.lit((int)0)));
        isGenericMap.assign((AssignmentTarget)valueType, (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (GeneratedExpression)expectedType).invoke("getActualTypeArguments").component(ExpressionFactory.lit((int)1)));
        GeneratedVariable map = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Map.class), "map", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Map.class), (GeneratedExpression)source));
        GeneratedVariable newMap = isExpectedMapBlock.decl((org.mule.devkit.model.code.Type)this.ref(Map.class), "newMap", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HashMap.class)));
        GeneratedForEach forEach = isExpectedMapBlock.forEach((org.mule.devkit.model.code.Type)this.ref(Object.class), "entryObj", (GeneratedExpression)map.invoke("entrySet"));
        GeneratedBlock forEachBlock = forEach.body().block();
        GeneratedVariable entry = forEachBlock.decl((org.mule.devkit.model.code.Type)this.ref(Map.Entry.class), "entry", (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Map.Entry.class), (GeneratedExpression)forEach.var()));
        GeneratedVariable newKey = forEachBlock.decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "newKey", (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)muleMessage).arg((GeneratedExpression)keyType).arg((GeneratedExpression)entry.invoke("getKey")));
        GeneratedVariable newValue = forEachBlock.decl((org.mule.devkit.model.code.Type)this.ref(Object.class), "newValue", (GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)muleMessage).arg((GeneratedExpression)valueType).arg((GeneratedExpression)entry.invoke("getValue")));
        forEachBlock.invoke((GeneratedExpression)newMap, "put").arg((GeneratedExpression)newKey).arg((GeneratedExpression)newValue);
        isExpectedMapBlock.assign((AssignmentTarget)target, (GeneratedExpression)newMap);
        isExpectedMap._else().assign((AssignmentTarget)target, (GeneratedExpression)source);
        isMap._else().assign((AssignmentTarget)target, (GeneratedExpression)source);
        GeneratedConditional shouldTransform = transform.body()._if(Op.cand((GeneratedExpression)target.isNotNull(), (GeneratedExpression)Op.not((GeneratedExpression)ExpressionFactory.invoke((String)"isAssignableFrom").arg((GeneratedExpression)expectedType).arg((GeneratedExpression)target.invoke("getClass")))));
        GeneratedVariable sourceDataType = shouldTransform._then().decl((org.mule.devkit.model.code.Type)this.ref(DataType.class), "sourceDataType", (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg((GeneratedExpression)target.invoke("getClass")));
        GeneratedConditional ifParameterizedType = shouldTransform._then()._if(Op._instanceof((GeneratedExpression)expectedType, (org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class)));
        ifParameterizedType._then().assign((AssignmentTarget)expectedType, (GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(ParameterizedType.class), (GeneratedExpression)expectedType).invoke("getRawType"));
        GeneratedVariable targetDataType = shouldTransform._then().decl((org.mule.devkit.model.code.Type)this.ref(DataType.class), "targetDataType", (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Class.class), (GeneratedExpression)expectedType)));
        GeneratedVariable transformer = shouldTransform._then().decl((org.mule.devkit.model.code.Type)this.ref(Transformer.class), "t", (GeneratedExpression)muleMessage.invoke("getMuleContext").invoke("getRegistry").invoke("lookupTransformer").arg((GeneratedExpression)sourceDataType).arg((GeneratedExpression)targetDataType));
        shouldTransform._then()._return((GeneratedExpression)transformer.invoke("transform").arg((GeneratedExpression)target));
        shouldTransform._else()._return((GeneratedExpression)target);
    }
}

