/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.List;
import org.mule.api.ConnectionManager;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessInterceptor;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

@JustOnce
public class ManagedConnectionProcessTemplateGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.INJECTION_ADAPTER, Product.HTTP_CALLBACK_ADAPTER, Product.CONNECTION_KEY, Product.OAUTH_ADAPTER, Product.PROCESS_CALLBACK_PROCESS_INTERCEPTOR, Product.MANAGED_CONNECTION_PROCESS_INTERCEPTOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MANAGED_CONNECTION_PROCESS_TEMPLATE);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof ManagedConnectionModule;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass connectionKeyClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module);
        GeneratedClass connectionIdentifierAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, (Identifiable)module);
        GeneratedClass processTemplateClass = this.getManagedConnectionProcessTemplateClass(module, connectionIdentifierAdapterClass);
        GeneratedField processInterceptor = processTemplateClass.field(12, (Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "processInterceptor");
        this.generateConstructor(connectionKeyClass, connectionIdentifierAdapterClass, processTemplateClass, processInterceptor);
        GeneratedMethod executeMethod = processTemplateClass.method(1, (Type)this.ref(Object.class), "execute");
        executeMethod.type((Type)processTemplateClass.typeParams()[0]);
        executeMethod._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = executeMethod.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "processCallback");
        GeneratedVariable messageProcessor = executeMethod.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = executeMethod.param((Type)this.ref(MuleEvent.class), "event");
        executeMethod.body()._return((GeneratedExpression)processInterceptor.invoke("execute").arg((GeneratedExpression)processCallback).arg(ExpressionFactory._null()).arg((GeneratedExpression)messageProcessor).arg((GeneratedExpression)event));
    }

    private GeneratedClass getManagedConnectionProcessTemplateClass(Module module, GeneratedClass connectionIdentifierAdapterClass) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".connectivity");
        GeneratedClass processTemplateClass = pkg._class(1, "ManagedConnectionProcessTemplate");
        TypeVariable payload = processTemplateClass.generify("P");
        processTemplateClass._implements(this.ref(ProcessTemplate.class).narrow((TypeReference)payload).narrow((TypeReference)connectionIdentifierAdapterClass));
        this.ctx().registerProduct(Product.MANAGED_CONNECTION_PROCESS_TEMPLATE, (Object)processTemplateClass);
        return processTemplateClass;
    }

    private void generateConstructor(GeneratedClass connectionKeyClass, GeneratedClass connectionIdentifierAdapterClass, GeneratedClass processTemplateClass, GeneratedField processInterceptor) {
        GeneratedClass processCallbackProcessInterceptorClass = (GeneratedClass)this.ctx().getProduct(Product.PROCESS_CALLBACK_PROCESS_INTERCEPTOR);
        GeneratedClass managedConnectionProcessInterceptorClass = (GeneratedClass)this.ctx().getProduct(Product.MANAGED_CONNECTION_PROCESS_INTERCEPTOR);
        GeneratedClass retryProcessInterceptorClass = (GeneratedClass)this.ctx().getProduct(Product.RETRY_PROCESS_INTERCEPTOR);
        GeneratedMethod constructor = processTemplateClass.constructor(1);
        GeneratedVariable connectionManager = constructor.param((Type)this.ref(ConnectionManager.class).narrow(new TypeReference[]{connectionKeyClass, connectionIdentifierAdapterClass}), "connectionManager");
        GeneratedVariable muleContext = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable processCallbackProcessInterceptor = constructor.body().decl((Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "processCallbackProcessInterceptor", (GeneratedExpression)ExpressionFactory._new((TypeReference)processCallbackProcessInterceptorClass.narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass)));
        GeneratedVariable managedConnectionProcessInterceptor = constructor.body().decl((Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "managedConnectionProcessInterceptor", (GeneratedExpression)ExpressionFactory._new((TypeReference)managedConnectionProcessInterceptorClass.narrow((TypeReference)processTemplateClass.typeParams()[0])).arg((GeneratedExpression)processCallbackProcessInterceptor).arg((GeneratedExpression)connectionManager).arg((GeneratedExpression)muleContext));
        GeneratedVariable retryProcessInterceptor = constructor.body().decl((Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "retryProcessInterceptor", (GeneratedExpression)ExpressionFactory._new((TypeReference)retryProcessInterceptorClass.narrow((TypeReference)processTemplateClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass)).arg((GeneratedExpression)managedConnectionProcessInterceptor).arg((GeneratedExpression)muleContext).arg((GeneratedExpression)connectionManager.invoke("getRetryPolicyTemplate")));
        constructor.body().assign((AssignmentTarget)processInterceptor, (GeneratedExpression)retryProcessInterceptor);
    }
}

