/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.api.ConnectionManager;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.UnableToAcquireConnectionException;
import org.mule.api.UnableToReleaseConnectionException;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

@JustOnce
public class ManagedConnectionProcessInterceptorGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CONNECTION_KEY, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.ABSTRACT_CONNECTED_PROCESSOR, Product.ABSTRACT_EXPRESSION_EVALUATOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MANAGED_CONNECTION_PROCESS_INTERCEPTOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof ManagedConnectionModule;
    }

    public void generate(Module module) throws GenerationException {
        ManagedConnectionModule managedConnectionType = (ManagedConnectionModule)module;
        GeneratedClass connectionKeyClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module);
        GeneratedClass connectionIdentifierAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, (Identifiable)module);
        GeneratedClass managedConnectionProcessInterceptorClass = this.getManagedConnectionProcessInterceptorClass(managedConnectionType);
        TypeVariable t = managedConnectionProcessInterceptorClass.generify("T");
        managedConnectionProcessInterceptorClass._implements(this.ref(ProcessInterceptor.class).narrow((TypeReference)t).narrow((TypeReference)connectionIdentifierAdapterClass));
        GeneratedField logger = this.generateLoggerField(managedConnectionProcessInterceptorClass);
        GeneratedField connectionManager = this.generateConnectionManagerField(connectionKeyClass, connectionIdentifierAdapterClass, managedConnectionProcessInterceptorClass);
        GeneratedField muleContext = managedConnectionProcessInterceptorClass.field(12, (Type)this.ref(MuleContext.class), "muleContext");
        GeneratedField next = managedConnectionProcessInterceptorClass.field(12, (Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)t).narrow((TypeReference)connectionIdentifierAdapterClass), "next");
        this.generateConstructor(managedConnectionProcessInterceptorClass, managedConnectionType, next, connectionManager, muleContext);
        this.generateExecuteMethod(managedConnectionType, connectionKeyClass, connectionIdentifierAdapterClass, managedConnectionProcessInterceptorClass, t, logger, connectionManager, next, muleContext);
    }

    private void generateExecuteMethod(ManagedConnectionModule managedConnectionType, GeneratedClass connectionKeyClass, GeneratedClass connectionIdentifierAdapterClass, GeneratedClass managedConnectionProcessInterceptorClass, TypeVariable t, GeneratedField logger, GeneratedField connectionManager, GeneratedField next, GeneratedField muleContext) {
        GeneratedMethod execute = managedConnectionProcessInterceptorClass.method(1, (Type)t, "execute");
        execute._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = execute.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)t).narrow((TypeReference)connectionIdentifierAdapterClass), "processCallback");
        GeneratedVariable object = execute.param((Type)connectionIdentifierAdapterClass, "object");
        GeneratedVariable messageProcessor = execute.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = execute.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedVariable connection = execute.body().decl((Type)connectionIdentifierAdapterClass, "connection", ExpressionFactory._null());
        GeneratedVariable key = execute.body().decl((Type)connectionKeyClass, "key", ExpressionFactory._null());
        GeneratedClass abstractConnectedProcessor = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_CONNECTED_PROCESSOR);
        GeneratedConditional ifConnectionKeyNotNull = execute.body()._if(Op.cand((GeneratedExpression)messageProcessor.isNotNull(), (GeneratedExpression)Op.cand((GeneratedExpression)Op._instanceof((GeneratedExpression)messageProcessor, (Type)abstractConnectedProcessor), (GeneratedExpression)ExpressionFactory.cast((Type)abstractConnectedProcessor, (GeneratedExpression)messageProcessor).invoke("get" + StringUtils.capitalize((String)managedConnectionType.getConnectMethod().getConnectionKey().getName())).isNotNull())));
        GeneratedInvocation newKey = ExpressionFactory._new((TypeReference)connectionKeyClass);
        for (Parameter parameter : managedConnectionType.getConnectMethod().getParameters()) {
            newKey.arg((GeneratedExpression)this.declareTransformedVariable((Variable)parameter, (GeneratedExpression)ExpressionFactory.cast((Type)abstractConnectedProcessor, (GeneratedExpression)messageProcessor).invoke("get" + StringUtils.capitalise((String)parameter.getName())), (Type)abstractConnectedProcessor, event, ifConnectionKeyNotNull._then(), (GeneratedExpression)muleContext));
        }
        ifConnectionKeyNotNull._then().assign((AssignmentTarget)key, (GeneratedExpression)newKey);
        ifConnectionKeyNotNull._else().assign((AssignmentTarget)key, (GeneratedExpression)connectionManager.invoke("getDefaultConnectionKey"));
        GeneratedTry tryCatch = execute.body()._try();
        tryCatch.body()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg(Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"Attempting to acquire connection using "), (GeneratedExpression)key.invoke("toString"))));
        tryCatch.body().assign((AssignmentTarget)connection, (GeneratedExpression)connectionManager.invoke("acquireConnection").arg((GeneratedExpression)key));
        GeneratedConditional isConnectionNull = tryCatch.body()._if(connection.isNull());
        isConnectionNull._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnableToAcquireConnectionException.class)));
        isConnectionNull._else()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg(Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"Connection has been acquired with [id="), (GeneratedExpression)connection.invoke("getConnectionIdentifier")), (GeneratedExpression)ExpressionFactory.lit((String)"]"))));
        tryCatch.body()._return((GeneratedExpression)next.invoke("execute").arg((GeneratedExpression)processCallback).arg((GeneratedExpression)connection).arg((GeneratedExpression)messageProcessor).arg((GeneratedExpression)event));
        GeneratedCatchBlock catchBlock = tryCatch._catch(this.ref(Exception.class));
        GeneratedVariable e = catchBlock.param("e");
        GeneratedConditional ifManagedExceptionsAreNotNull = catchBlock.body()._if(processCallback.invoke("getManagedExceptions").isNotNull());
        GeneratedForEach forEachException = ifManagedExceptionsAreNotNull._then().forEach((Type)this.ref(Class.class), "exceptionClass", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(Class.class), (GeneratedExpression)processCallback.invoke("getManagedExceptions")));
        GeneratedConditional ifIsInstance = forEachException.body()._if((GeneratedExpression)forEachException.var().invoke("isInstance").arg((GeneratedExpression)e));
        ifIsInstance._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg(Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"An exception ( "), (GeneratedExpression)forEachException.var().invoke("getName")), (GeneratedExpression)ExpressionFactory.lit((String)") has been thrown. Destroying the connection with [id=")), (GeneratedExpression)connection.invoke("getConnectionIdentifier")), (GeneratedExpression)ExpressionFactory.lit((String)"]"))));
        GeneratedTry tryToDestroy = ifIsInstance._then()._try();
        tryToDestroy.body().add((Statement)connectionManager.invoke("destroyConnection").arg((GeneratedExpression)key).arg((GeneratedExpression)connection));
        tryToDestroy.body().assign((AssignmentTarget)connection, ExpressionFactory._null());
        GeneratedCatchBlock releaseCatch = tryToDestroy._catch(this.ref(Exception.class));
        GeneratedVariable innerException = releaseCatch.param("innerException");
        releaseCatch.body().add((Statement)logger.invoke("error").arg((GeneratedExpression)innerException.invoke("getMessage")).arg((GeneratedExpression)innerException));
        catchBlock.body()._throw((GeneratedExpression)e);
        GeneratedTry tryToRelease = tryCatch._finally()._try();
        GeneratedConditional connectionIsNotNull = tryToRelease.body()._if(connection.isNotNull());
        connectionIsNotNull._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg(Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"Releasing the connection back into the pool [id="), (GeneratedExpression)connection.invoke("getConnectionIdentifier")), (GeneratedExpression)ExpressionFactory.lit((String)"]"))));
        connectionIsNotNull._then().add((Statement)connectionManager.invoke("releaseConnection").arg((GeneratedExpression)key).arg((GeneratedExpression)connection));
        GeneratedCatchBlock catchException = tryToRelease._catch(this.ref(Exception.class));
        GeneratedVariable exception = catchException.param("e");
        catchException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnableToReleaseConnectionException.class)).arg((GeneratedExpression)exception));
    }

    private void generateConstructor(GeneratedClass managedConnectionProcessInterceptorClass, ManagedConnectionModule module, GeneratedField nextField, GeneratedField connectionManagerField, GeneratedField muleContextField) {
        GeneratedClass connectionKeyClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module);
        GeneratedClass connectionIdentifierAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, (Identifiable)module);
        GeneratedMethod constructor = managedConnectionProcessInterceptorClass.constructor(1);
        GeneratedVariable next = constructor.param((Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)managedConnectionProcessInterceptorClass.typeParams()[0]).narrow((TypeReference)connectionIdentifierAdapterClass), "next");
        GeneratedVariable connectionManager = constructor.param((Type)this.ref(ConnectionManager.class).narrow(new TypeReference[]{connectionKeyClass, connectionIdentifierAdapterClass}), "connectionManager");
        GeneratedVariable muleContext = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)nextField), (GeneratedExpression)next);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)connectionManagerField), (GeneratedExpression)connectionManager);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)muleContextField), (GeneratedExpression)muleContext);
    }

    private GeneratedClass getManagedConnectionProcessInterceptorClass(ManagedConnectionModule module) {
        GeneratedClass abstractExpressionEvaluatorClass = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_EXPRESSION_EVALUATOR);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".process");
        GeneratedClass clazz = pkg._class(1, "ManagedConnectionProcessInterceptor");
        clazz._extends((TypeReference)abstractExpressionEvaluatorClass);
        this.ctx().registerProduct(Product.MANAGED_CONNECTION_PROCESS_INTERCEPTOR, (Object)clazz);
        return clazz;
    }

    private GeneratedField generateConnectionManagerField(GeneratedClass connectionKeyClass, GeneratedClass connectionIdentifierAdapterClass, GeneratedClass processTemplateClass) {
        return processTemplateClass.field(12, (Type)this.ref(ConnectionManager.class).narrow(new TypeReference[]{connectionKeyClass, connectionIdentifierAdapterClass}), "connectionManager");
    }
}

