/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.Capabilities;
import org.mule.api.ConnectionManager;
import org.mule.api.MetadataAware;
import org.mule.api.config.MuleProperties;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.PoolingProfile;
import org.mule.devkit.generation.AbstractMetadataCodeGenerator;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

public class ConnectionManagerGenerator
extends AbstractMetadataCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.INJECTION_ADAPTER, Product.HTTP_CALLBACK_ADAPTER, Product.OAUTH_ADAPTER, Product.MANAGED_CONNECTION_PROCESS_TEMPLATE, Product.METADATA_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.CONNECTION_MANAGER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof ManagedConnectionModule;
    }

    public void generate(Module module) throws GenerationException {
        ManagedConnectionModule managedConnectionType = (ManagedConnectionModule)module;
        ConnectMethod connectMethod = managedConnectionType.getConnectMethod();
        Method disconnectMethod = managedConnectionType.getDisconnectMethod();
        Method validateConnectionMethod = managedConnectionType.getValidateConnectionMethod();
        GeneratedClass connectionManagerClass = this.getConnectionManagerAdapterClass(managedConnectionType);
        Map<String, AbstractMuleGenerator.FieldVariableElement> fields = this.generateStandardFieldForEachParameter(connectionManagerClass, (Method)connectMethod);
        for (Field field : module.getConfigurableFields()) {
            GeneratedField configField = connectionManagerClass.field(4, this.ref(field.asTypeMirror()), field.getName());
            connectionManagerClass.setter(configField);
            connectionManagerClass.getter(configField);
        }
        GeneratedField muleContext = connectionManagerClass.muleContextField();
        GeneratedField flowConstruct = connectionManagerClass.flowConstructField();
        GeneratedField connectionPool = this.generateFieldForConnectionPool(connectionManagerClass);
        GeneratedField poolingProfile = connectionManagerClass.field(2, (Type)this.ref(PoolingProfile.class), "connectionPoolingProfile");
        GeneratedField retryPolicyTemplate = connectionManagerClass.field(2, (Type)this.ref(RetryPolicyTemplate.class), "retryPolicyTemplate");
        connectionManagerClass.setter(poolingProfile);
        connectionManagerClass.getter(poolingProfile);
        connectionManagerClass.setter(retryPolicyTemplate);
        connectionManagerClass.getter(retryPolicyTemplate);
        for (String fieldName : fields.keySet()) {
            connectionManagerClass.setter(fields.get(fieldName).getField());
            connectionManagerClass.getter(fields.get(fieldName).getField());
        }
        GeneratedClass connectionKeyClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module);
        GeneratedClass connectionFactoryClass = this.getConnectorFactoryClass(module);
        GeneratedField loggerFactory = this.generateLoggerField(connectionFactoryClass);
        GeneratedField connectionManagerInFactory = connectionFactoryClass.field(4, (Type)connectionManagerClass, "connectionManager");
        GeneratedMethod connectionFactoryConstructor = connectionFactoryClass.constructor(1);
        GeneratedVariable constructorConnectionManager = connectionFactoryConstructor.param((Type)connectionManagerClass, "connectionManager");
        connectionFactoryConstructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)connectionManagerInFactory), (GeneratedExpression)constructorConnectionManager);
        this.generateMakeObjectMethod(module, (Method)connectMethod, connectionFactoryClass, connectionKeyClass, connectionManagerInFactory);
        this.generateDestroyObjectMethod((Method)connectMethod, disconnectMethod, connectionKeyClass, connectionFactoryClass);
        this.generateValidateObjectMethod(connectionFactoryClass, loggerFactory, validateConnectionMethod);
        this.generateActivateObjectMethod(connectionFactoryClass, validateConnectionMethod, connectMethod, connectionKeyClass);
        this.generatePassivateObjectMethod(connectionFactoryClass);
        this.generateInitialiseMethod(connectionManagerClass, connectionPool, poolingProfile, retryPolicyTemplate, connectionFactoryClass);
        this.generateBorrowConnectionMethod((Method)connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateReturnConnectionMethod((Method)connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateDestroyConnectionMethod((Method)connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateIsCapableOfMethod(module, connectionManagerClass);
        this.generateGetProcessTemplateMethod(managedConnectionType, connectionManagerClass);
        this.generateGetDefaultConnectionKey(managedConnectionType, connectionManagerClass, connectionKeyClass);
        this.generateMetadataConstantsAndGetters(module, connectionManagerClass);
    }

    private void generateGetDefaultConnectionKey(ManagedConnectionModule module, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass) {
        GeneratedMethod getDefaultConnectionKey = connectionManagerClass.method(1, (Type)connectionKeyClass, "getDefaultConnectionKey");
        GeneratedInvocation newConnectionKey = ExpressionFactory._new((TypeReference)connectionKeyClass);
        for (Parameter parameter : module.getConnectMethod().getParameters()) {
            newConnectionKey.arg((GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)parameter.getName()))));
        }
        getDefaultConnectionKey.body()._return((GeneratedExpression)newConnectionKey);
    }

    private void generateGetProcessTemplateMethod(ManagedConnectionModule module, GeneratedClass connectionManagerClass) {
        GeneratedClass connectionIdentifierAdapterClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass managedConnectionProcessTemplateClass = (GeneratedClass)this.ctx().getProduct(Product.MANAGED_CONNECTION_PROCESS_TEMPLATE);
        GeneratedMethod getProcessTemplate = connectionManagerClass.method(1, (Type)this.ref(ProcessTemplate.class), "getProcessTemplate");
        getProcessTemplate.annotate(this.ref(Override.class));
        TypeVariable p = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)this.ref(ProcessTemplate.class).narrow((TypeReference)p).narrow((TypeReference)connectionIdentifierAdapterClass));
        getProcessTemplate.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)managedConnectionProcessTemplateClass).arg(ExpressionFactory._this()).arg((GeneratedExpression)ExpressionFactory.ref((String)"muleContext")));
    }

    private void generateBorrowConnectionMethod(Method connect, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod borrowConnector = connectionManagerClass.method(1, (Type)connectorClass, "acquireConnection");
        GeneratedVariable key = borrowConnector.param((Type)connectionKeyClass, "key");
        borrowConnector._throws(this.ref(Exception.class));
        borrowConnector.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)connectionPool.invoke("borrowObject").arg((GeneratedExpression)key)));
    }

    private void generateReturnConnectionMethod(Method connect, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod returnConnector = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "releaseConnection");
        GeneratedVariable key = returnConnector.param((Type)connectionKeyClass, "key");
        returnConnector._throws(this.ref(Exception.class));
        GeneratedVariable connection = returnConnector.param((Type)connectorClass, "connection");
        returnConnector.body().add((Statement)connectionPool.invoke("returnObject").arg((GeneratedExpression)key).arg((GeneratedExpression)connection));
    }

    private void generateDestroyConnectionMethod(Method connect, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod destroyConnector = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "destroyConnection");
        GeneratedVariable key = destroyConnector.param((Type)connectionKeyClass, "key");
        destroyConnector._throws(this.ref(Exception.class));
        GeneratedVariable connection = destroyConnector.param((Type)connectorClass, "connection");
        destroyConnector.body().add((Statement)connectionPool.invoke("invalidateObject").arg((GeneratedExpression)key).arg((GeneratedExpression)connection));
    }

    private void generateInitialiseMethod(GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedField connectionPoolingProfile, GeneratedField retryPolicyTemplate, GeneratedClass connectionFactoryClass) {
        GeneratedMethod initialisableMethod = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        GeneratedVariable config = initialisableMethod.body().decl((Type)this.ref(GenericKeyedObjectPool.Config.class), "config", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(GenericKeyedObjectPool.Config.class)));
        GeneratedConditional ifNotNull = initialisableMethod.body()._if(connectionPoolingProfile.isNotNull());
        ifNotNull._then().assign((AssignmentTarget)config.ref("maxIdle"), (GeneratedExpression)connectionPoolingProfile.invoke("getMaxIdle"));
        ifNotNull._then().assign((AssignmentTarget)config.ref("maxActive"), (GeneratedExpression)connectionPoolingProfile.invoke("getMaxActive"));
        ifNotNull._then().assign((AssignmentTarget)config.ref("maxWait"), (GeneratedExpression)connectionPoolingProfile.invoke("getMaxWait"));
        ifNotNull._then().assign((AssignmentTarget)config.ref("whenExhaustedAction"), (GeneratedExpression)ExpressionFactory.cast((Type)this.ctx().getCodeModel().BYTE, (GeneratedExpression)connectionPoolingProfile.invoke("getExhaustedAction")));
        GeneratedInvocation newObjectFactory = ExpressionFactory._new((TypeReference)connectionFactoryClass);
        newObjectFactory.arg(ExpressionFactory._this());
        initialisableMethod.body().assign((AssignmentTarget)connectionPool, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(GenericKeyedObjectPool.class)).arg((GeneratedExpression)newObjectFactory).arg((GeneratedExpression)config));
        GeneratedConditional ifRetryPolicyTemplateIsNull = initialisableMethod.body()._if(retryPolicyTemplate.isNull());
        ifRetryPolicyTemplateIsNull._then().assign((AssignmentTarget)retryPolicyTemplate, (GeneratedExpression)ExpressionFactory.ref((String)"muleContext").invoke("getRegistry").invoke("lookupObject").arg((GeneratedExpression)this.ref(MuleProperties.class).staticRef("OBJECT_DEFAULT_RETRY_POLICY_TEMPLATE")));
    }

    private void generateActivateObjectMethod(GeneratedClass connectionFactoryClass, Method validateConnectionMethod, ConnectMethod connect, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, validateConnectionMethod.parent())).topLevelClass();
        GeneratedMethod activateObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "activateObject");
        activateObject._throws(this.ref(Exception.class));
        GeneratedVariable key = activateObject.param(Object.class, "key");
        GeneratedVariable obj = activateObject.param(Object.class, "obj");
        GeneratedConditional ifNotKey = activateObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)connectionKeyClass)));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid key type"));
        GeneratedConditional ifNotObj = activateObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)obj, (Type)connectorClass)));
        ifNotObj._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid connector type"));
        GeneratedCast casterConnector = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj);
        GeneratedTry tryDisconnect = activateObject.body()._try();
        GeneratedConditional ifNotConnected = tryDisconnect.body()._if(Op.not((GeneratedExpression)casterConnector.invoke(validateConnectionMethod.getName())));
        GeneratedCast castedConnectionKey = ExpressionFactory.cast((Type)connectionKeyClass, (GeneratedExpression)key);
        GeneratedInvocation connectInvoke = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj).invoke(connect.getName());
        for (Parameter variable : connect.getParameters()) {
            String fieldName = variable.getName();
            connectInvoke.arg((GeneratedExpression)castedConnectionKey.invoke("get" + StringUtils.capitalize((String)fieldName)));
        }
        ifNotConnected._then().add((Statement)connectInvoke);
        GeneratedCatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        GeneratedVariable e = catchAndRethrow.param("e");
        catchAndRethrow.body()._throw((GeneratedExpression)e);
    }

    private void generatePassivateObjectMethod(GeneratedClass connectionFactoryClass) {
        GeneratedMethod passivateObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "passivateObject");
        passivateObject._throws(this.ref(Exception.class));
        passivateObject.param(Object.class, "key");
        passivateObject.param(Object.class, "obj");
    }

    private void generateValidateObjectMethod(GeneratedClass connectionFactoryClass, GeneratedField logger, Method validateConnectionMethod) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, validateConnectionMethod.parent())).topLevelClass();
        GeneratedMethod validateObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "validateObject");
        validateObject.param(Object.class, "key");
        GeneratedVariable obj = validateObject.param(Object.class, "obj");
        GeneratedConditional ifNotObj = validateObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)obj, (Type)connectorClass)));
        ifNotObj._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid connector type"));
        GeneratedCast casterConnector = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj);
        GeneratedTry tryDisconnect = validateObject.body()._try();
        tryDisconnect.body()._return((GeneratedExpression)casterConnector.invoke(validateConnectionMethod.getName()));
        GeneratedCatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        GeneratedVariable e = catchAndRethrow.param("e");
        catchAndRethrow.body().add((Statement)logger.invoke("error").arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)e));
        catchAndRethrow.body()._return(ExpressionFactory.FALSE);
    }

    private void generateDestroyObjectMethod(Method connect, Method disconnect, GeneratedClass connectionKeyClass, GeneratedClass connectionFactoryClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod destroyObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "destroyObject");
        destroyObject._throws(this.ref(Exception.class));
        GeneratedVariable key = destroyObject.param(Object.class, "key");
        GeneratedVariable obj = destroyObject.param(Object.class, "obj");
        GeneratedConditional ifNotKey = destroyObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)connectionKeyClass)));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid key type"));
        GeneratedConditional ifNotObj = destroyObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)obj, (Type)connectorClass)));
        ifNotObj._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid connector type"));
        GeneratedCast casterConnector = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj);
        GeneratedTry tryDisconnect = destroyObject.body()._try();
        tryDisconnect.body().add((Statement)casterConnector.invoke(disconnect.getName()));
        GeneratedCatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        GeneratedVariable e = catchAndRethrow.param("e");
        catchAndRethrow.body()._throw((GeneratedExpression)e);
        tryDisconnect._finally()._if(Op._instanceof((GeneratedExpression)casterConnector, (Type)this.ref(Stoppable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)obj).invoke("stop"));
        tryDisconnect._finally()._if(Op._instanceof((GeneratedExpression)casterConnector, (Type)this.ref(Disposable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)obj).invoke("dispose"));
    }

    private void generateMakeObjectMethod(Module module, Method connect, GeneratedClass connectionFactoryClass, GeneratedClass connectionKey, GeneratedField connectionManagerInFactory) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod makeObject = connectionFactoryClass.method(1, Object.class, "makeObject");
        makeObject._throws(this.ref(Exception.class));
        GeneratedVariable key = makeObject.param(Object.class, "key");
        GeneratedConditional ifNotKey = makeObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)connectionKey)));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid key type"));
        GeneratedVariable connector = makeObject.body().decl((Type)connectorClass, "connector", (GeneratedExpression)ExpressionFactory._new((TypeReference)connectorClass));
        for (Field field : module.getConfigurableFields()) {
            makeObject.body().add((Statement)connector.invoke("set" + StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)connectionManagerInFactory.invoke("get" + StringUtils.capitalize((String)field.getName()))));
        }
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(Initialisable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Initialisable.class), (GeneratedExpression)connector).invoke("initialise"));
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(MuleContextAware.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleContextAware.class), (GeneratedExpression)connector).invoke("setMuleContext").arg((GeneratedExpression)connectionManagerInFactory.invoke("getMuleContext")));
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(Startable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)connector).invoke("start"));
        this.setMuleContextToConnectorIfNecessary(connectionManagerInFactory, connectorClass, makeObject, connector);
        makeObject.body()._return((GeneratedExpression)connector);
    }

    private void setMuleContextToConnectorIfNecessary(GeneratedField connectionManagerInFactory, GeneratedClass connectorClass, GeneratedMethod makeObject, GeneratedVariable connector) {
        Iterator implementsIterator = connectorClass._implements();
        while (implementsIterator.hasNext()) {
            TypeReference implementedInterface = (TypeReference)implementsIterator.next();
            if (!implementedInterface.equals((Object)this.ref(MuleContextAware.class))) continue;
            makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(MuleContextAware.class)))._then().add((Statement)connector.invoke("setMuleContext").arg(ExpressionFactory.direct((String)(connectionManagerInFactory.name() + "." + "muleContext"))));
        }
    }

    private GeneratedField generateFieldForConnectionPool(GeneratedClass connectionManagerClass) {
        GeneratedField connectionPool = connectionManagerClass.field(4, (Type)this.ref(GenericKeyedObjectPool.class), "connectionPool");
        connectionPool.javadoc().add((Object)"Connector Pool");
        return connectionPool;
    }

    private GeneratedClass getConnectionManagerAdapterClass(ManagedConnectionModule module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".connectivity");
        GeneratedClass connectionKeyClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module)).topLevelClass();
        GeneratedClass classToExtend = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass connectionManagerClass = pkg._class(module.getClassName() + "ConnectionManager");
        connectionManagerClass._implements(this.ref(Initialisable.class));
        connectionManagerClass._implements(this.ref(Capabilities.class));
        connectionManagerClass._implements(this.ref(MuleContextAware.class));
        connectionManagerClass._implements(this.ref(ConnectionManager.class).narrow((TypeReference)connectionKeyClass).narrow((TypeReference)classToExtend));
        connectionManagerClass._implements(this.ref(ProcessAdapter.class).narrow((TypeReference)classToExtend));
        connectionManagerClass._implements(this.ref(MetadataAware.class));
        this.ctx().registerProduct(Product.CONNECTION_MANAGER, (Identifiable)module, (Object)connectionManagerClass);
        connectionManagerClass.javadoc().add((Object)("A {@code " + connectionManagerClass.name() + "} is a wrapper around "));
        connectionManagerClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        connectionManagerClass.javadoc().add((Object)" that adds connection management capabilities to the pojo.");
        return connectionManagerClass;
    }

    private GeneratedClass getConnectorFactoryClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".connectivity");
        GeneratedClass objectFactory = pkg._class(1, module.getClassName() + "ConnectionFactory");
        objectFactory._implements(KeyedPoolableObjectFactory.class);
        return objectFactory;
    }
}

