/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;

@JustOnce
public class AbstractConnectedProcessorGenerator
extends AbstractMuleGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.ABSTRACT_EXPRESSION_EVALUATOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.ABSTRACT_CONNECTED_PROCESSOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule) && (!(module instanceof OAuthModule) || ((OAuthModule)module).getUserIdentifierMethod() == null)) continue;
            return true;
        }
        return false;
    }

    public void generate(List<Module> modules) throws GenerationException {
        GeneratedClass abstractConnectedProcessorClass = this.getAbstractConnectedProcessorClass(modules.get(0));
        for (Module module : modules) {
            if (module instanceof ManagedConnectionModule) {
                ManagedConnectionModule managedConnectionType = (ManagedConnectionModule)module;
                ConnectMethod connectMethod = managedConnectionType.getConnectMethod();
                Map<String, AbstractMuleGenerator.FieldVariableElement> connectFields = null;
                if (connectMethod != null) {
                    connectFields = this.generateProcessorFieldForEachParameter(abstractConnectedProcessorClass, (Method)connectMethod);
                }
                if (connectFields == null) continue;
                for (String fieldName : connectFields.keySet()) {
                    abstractConnectedProcessorClass.setter(connectFields.get(fieldName).getField());
                    abstractConnectedProcessorClass.getter(connectFields.get(fieldName).getField());
                }
                continue;
            }
            if (!(module instanceof OAuthModule) || ((OAuthModule)module).getUserIdentifierMethod() == null) continue;
            GeneratedField tokenField = abstractConnectedProcessorClass.field(4, (Type)this.ref(Object.class), "accessTokenId");
            abstractConnectedProcessorClass.getter(tokenField);
            abstractConnectedProcessorClass.setter(tokenField);
            GeneratedField tokenTypeField = abstractConnectedProcessorClass.field(4, (Type)this.ref(String.class), "_accessTokenIdType");
        }
    }

    private GeneratedClass getAbstractConnectedProcessorClass(Module type) {
        GeneratedClass abstractExpressionEvaluatorClass = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_EXPRESSION_EVALUATOR);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(type.getPackage().getName() + ".processors");
        GeneratedClass clazz = pkg._class(33, "AbstractConnectedProcessor", (TypeReference)abstractExpressionEvaluatorClass);
        this.ctx().registerProduct(Product.ABSTRACT_CONNECTED_PROCESSOR, (Object)clazz);
        return clazz;
    }
}

