/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;

public class ProcessAdapterGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.LIFECYCLE_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.PROCESS_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass processAdapterClass = this.getProcessAdapterClass(module);
        processAdapterClass.javadoc().add((Object)("A <code>" + processAdapterClass.name() + "</code> is a wrapper around "));
        processAdapterClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        processAdapterClass.javadoc().add((Object)" that enables custom processing strategies.");
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        GeneratedMethod getProcessTemplate = processAdapterClass.method(1, (Type)this.ref(ProcessTemplate.class), "getProcessTemplate");
        TypeVariable t = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)this.ref(ProcessTemplate.class).narrow((TypeReference)t).narrow((TypeReference)capabilitiesAdapterClass));
        GeneratedVariable object = getProcessTemplate.body().decl(8, (Type)capabilitiesAdapterClass, "object", ExpressionFactory._this());
        GeneratedClass anonClass = this.ctx().getCodeModel().anonymousClass(this.ref(ProcessTemplate.class).narrow((TypeReference)t).narrow((TypeReference)capabilitiesAdapterClass));
        GeneratedMethod execute = anonClass.method(1, (Type)t, "execute");
        execute.annotate(this.ref(Override.class));
        execute._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = execute.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)t).narrow((TypeReference)capabilitiesAdapterClass), "processCallback");
        GeneratedVariable messageProcessor = execute.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = execute.param((Type)this.ref(MuleEvent.class), "event");
        execute.body()._return((GeneratedExpression)processCallback.invoke("process").arg((GeneratedExpression)object));
        getProcessTemplate.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)anonClass));
    }

    private GeneratedClass getProcessAdapterClass(Module module) {
        GeneratedClass lifecycleAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.LIFECYCLE_ADAPTER, (Identifiable)module);
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + "ProcessAdapter");
        clazz._implements(this.ref(ProcessAdapter.class).narrow((TypeReference)capabilitiesAdapterClass));
        clazz._extends((TypeReference)lifecycleAdapterClass);
        this.ctx().registerProduct(Product.PROCESS_ADAPTER, (Identifiable)module, (Object)clazz);
        return clazz;
    }
}

