/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.config.MuleManifest;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedForLoop;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleAdapterGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.METADATA_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.LIFECYCLE_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC || module.getKind() == ModuleKind.EXPRESSION_LANGUAGE;
    }

    public void generate(Module module) {
        GeneratedClass lifecycleAdapter = this.getLifecycleAdapterClass(module);
        lifecycleAdapter.javadoc().add((Object)("A <code>" + lifecycleAdapter.name() + "</code> is a wrapper around "));
        lifecycleAdapter.javadoc().add((Object)this.ref(module.asTypeMirror()));
        lifecycleAdapter.javadoc().add((Object)" that adds lifecycle methods to the pojo.");
        this.generateStartMethod(module, lifecycleAdapter);
        this.generateStopMethod(module, lifecycleAdapter);
        this.generateInitMethod(module, lifecycleAdapter);
        this.generateDisposeMethod(module, lifecycleAdapter);
    }

    private void generateDisposeMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method disposeMethod = module.getLifecycleMethod("dispose");
        lifecycleAdapter._implements(Disposable.class);
        this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends Type>)disposeMethod, "dispose", null, false);
    }

    private void generateInitMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method initMethod = module.getLifecycleMethod("initialise");
        lifecycleAdapter._implements(Initialisable.class);
        this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends Type>)initMethod, "initialise", InitialisationException.class, true);
    }

    private void generateStopMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method stopMethod = module.getLifecycleMethod("stop");
        lifecycleAdapter._implements(Stoppable.class);
        GeneratedMethod stop = this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends Type>)stopMethod, "stop", MuleException.class, false);
    }

    private void generateStartMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method startMethod = module.getLifecycleMethod("start");
        lifecycleAdapter._implements(Startable.class);
        GeneratedMethod start = this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends Type>)startMethod, "start", MuleException.class, false);
    }

    private GeneratedClass getLifecycleAdapterClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        GeneratedClass previous = ((GeneratedClass)this.ctx().getProduct(Product.METADATA_ADAPTER, (Identifiable)module)).topLevelClass();
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + "LifecycleAdapter", (TypeReference)previous);
        this.ctx().registerProduct(Product.LIFECYCLE_ADAPTER, (Identifiable)module, (Object)clazz);
        return clazz;
    }

    private GeneratedMethod generateLifecycleInvocation(GeneratedClass lifecycleWrapper, Module module, Method<? extends Type> superExecutableElement, String name, Class<?> catchException, boolean addThis) {
        GeneratedMethod lifecycleMethod = lifecycleWrapper.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, name);
        lifecycleMethod.annotate(this.ref(Override.class));
        if (name.equals("initialise")) {
            GeneratedVariable log = lifecycleMethod.body().decl((org.mule.devkit.model.code.Type)this.ref(Logger.class), "log", (GeneratedExpression)this.ref(LoggerFactory.class).staticInvoke("getLogger").arg(lifecycleWrapper.dotclass()));
            GeneratedVariable runtimeVersion = lifecycleMethod.body().decl((org.mule.devkit.model.code.Type)this.ref(String.class), "runtimeVersion", (GeneratedExpression)this.ref(MuleManifest.class).staticInvoke("getProductVersion"));
            GeneratedConditional ifUnkownVersion = lifecycleMethod.body()._if((GeneratedExpression)runtimeVersion.invoke("equals").arg("Unknown"));
            ifUnkownVersion._then().add((Statement)log.invoke("warn").arg(ExpressionFactory.lit((String)"Unknown Mule runtime version. This module may not work properly!")));
            GeneratedBlock ifKnownVersion = ifUnkownVersion._else();
            GeneratedVariable expectedMinVersion = ifKnownVersion.decl((org.mule.devkit.model.code.Type)this.ref(String[].class), "expectedMinVersion", (GeneratedExpression)ExpressionFactory.lit((String)module.getMinMuleVersion()).invoke("split").arg("\\."));
            GeneratedBlock ifKnownVersionContainsDash = ifKnownVersion._if((GeneratedExpression)ExpressionFactory.invoke((GeneratedExpression)runtimeVersion, (String)"contains").arg("-"))._then();
            ifKnownVersionContainsDash.assign((AssignmentTarget)runtimeVersion, (GeneratedExpression)runtimeVersion.invoke("split").arg("-").component(ExpressionFactory.lit((int)0)));
            GeneratedVariable currentRuntimeVersion = ifKnownVersion.decl((org.mule.devkit.model.code.Type)this.ref(String[].class), "currentRuntimeVersion", (GeneratedExpression)runtimeVersion.invoke("split").arg("\\."));
            GeneratedForLoop forEachVersionComponent = ifKnownVersion._for();
            GeneratedVariable i = forEachVersionComponent.init((org.mule.devkit.model.code.Type)this.ctx().getCodeModel().INT, "i", ExpressionFactory.lit((int)0));
            forEachVersionComponent.test(Op.lt((GeneratedExpression)i, (GeneratedExpression)expectedMinVersion.ref("length")));
            forEachVersionComponent.update(Op.incr((GeneratedExpression)i));
            GeneratedTry tryToParseMuleVersion = forEachVersionComponent.body()._try();
            tryToParseMuleVersion.body()._if(Op.lt((GeneratedExpression)this.ref(Integer.class).staticInvoke("parseInt").arg((GeneratedExpression)currentRuntimeVersion.component((GeneratedExpression)i)), (GeneratedExpression)this.ref(Integer.class).staticInvoke("parseInt").arg((GeneratedExpression)expectedMinVersion.component((GeneratedExpression)i))))._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("This module is only valid for Mule " + module.getMinMuleVersion()));
            GeneratedCatchBlock catchBlock = tryToParseMuleVersion._catch(this.ref(NumberFormatException.class));
            catchBlock.param("nfe");
            catchBlock.body().invoke((GeneratedExpression)log, "warn").arg("Error parsing Mule version, cannot validate current Mule version");
        }
        if (catchException != null) {
            lifecycleMethod._throws(this.ref(catchException));
        }
        if (superExecutableElement != null) {
            GeneratedInvocation startInvocation = ExpressionFactory._super().invoke(superExecutableElement.getName());
            boolean foundNonCatchException = false;
            for (TypeMirror exception : superExecutableElement.getThrownTypes()) {
                if (catchException.getName().toString().equals(((Object)exception).toString())) continue;
                foundNonCatchException = true;
            }
            if (foundNonCatchException) {
                GeneratedTry tryBlock = lifecycleMethod.body()._try();
                tryBlock.body().add((Statement)startInvocation);
                int i = 0;
                for (TypeMirror exception : superExecutableElement.getThrownTypes()) {
                    GeneratedCatchBlock catchBlock = tryBlock._catch(this.ref(exception).boxify());
                    GeneratedVariable catchedException = catchBlock.param("e" + i);
                    GeneratedInvocation newMuleException = null;
                    newMuleException = catchException.getName().toString().equals(MuleException.class.getName()) ? ExpressionFactory._new((TypeReference)this.ref(DefaultMuleException.class)) : ExpressionFactory._new((TypeReference)this.ref(catchException));
                    newMuleException.arg((GeneratedExpression)catchedException);
                    if (addThis) {
                        newMuleException.arg(ExpressionFactory._this());
                    }
                    catchBlock.body()._throw((GeneratedExpression)newMuleException);
                    ++i;
                }
            } else {
                lifecycleMethod.body().add((Statement)startInvocation);
            }
        }
        return lifecycleMethod;
    }
}

