/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.Arrays;
import java.util.List;
import org.mule.api.Capabilities;
import org.mule.devkit.generation.AbstractCapabilityGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

public class CapabilitiesAdapterGenerator
extends AbstractCapabilityGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(new Product[0]);
    private static final List<Product> PRODUCES = Arrays.asList(Product.CAPABILITIES_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC || module.getKind() == ModuleKind.EXPRESSION_LANGUAGE;
    }

    public void generate(Module module) {
        GeneratedClass capabilitiesAdapter = this.getCapabilitiesAdapterClass(module);
        capabilitiesAdapter.javadoc().add((Object)("A <code>" + capabilitiesAdapter.name() + "</code> is a wrapper around "));
        capabilitiesAdapter.javadoc().add((Object)this.ref(module.asTypeMirror()));
        capabilitiesAdapter.javadoc().add((Object)" that implements {@link org.mule.api.Capabilities} interface.");
        this.generateIsCapableOfMethod(module, capabilitiesAdapter);
    }

    private GeneratedClass getCapabilitiesAdapterClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        TypeReference previous = (TypeReference)this.ref(module.asTypeMirror());
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + "CapabilitiesAdapter", previous);
        clazz._implements(Capabilities.class);
        this.ctx().registerProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module, (Object)clazz);
        return clazz;
    }
}

