/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.api.gatherer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.devkit.generation.api.gatherer.Details;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Notification;
import org.mule.devkit.generation.api.gatherer.NotificationGathererFactory;
import org.mule.devkit.generation.api.gatherer.NotificationLevel;
import org.mule.devkit.model.Identifiable;

public class DefaultGathererFactory
implements NotificationGathererFactory {
    public org.mule.devkit.generation.api.gatherer.NotificationGatherer create() {
        return new NotificationGatherer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotificationGatherer
    implements org.mule.devkit.generation.api.gatherer.NotificationGatherer {
        Set<Notification> notifications = new HashSet<Notification>();

        NotificationGatherer() {
        }

        @Override
        public boolean hasNotifications() {
            return this.notifications != null && !this.notifications.isEmpty();
        }

        @Override
        public List<Notification> getErrors() {
            return this.filterNotificationsWithLvl(NotificationLevel.ERROR);
        }

        @Override
        public List<Notification> getWarnings() {
            return this.filterNotificationsWithLvl(NotificationLevel.WARNING);
        }

        @Override
        public List<Notification> getNotes() {
            return this.filterNotificationsWithLvl(NotificationLevel.NOTE);
        }

        @Override
        public boolean hasErrors() {
            return this.hasNotificationsWithLvl(NotificationLevel.ERROR);
        }

        @Override
        public boolean hasWarnings() {
            return this.hasNotificationsWithLvl(NotificationLevel.WARNING);
        }

        @Override
        public boolean hasNotes() {
            return this.hasNotificationsWithLvl(NotificationLevel.NOTE);
        }

        @Override
        public void error(Identifiable element, DevkitNotification error, Object ... args) {
            this.notifications.add(new Notification(new Details(String.format(error.getMessage(), args), element), NotificationLevel.ERROR));
        }

        @Override
        public void warn(Identifiable element, DevkitNotification error, Object ... args) {
            this.notifications.add(new Notification(new Details(String.format(error.getMessage(), args), element), NotificationLevel.WARNING));
        }

        @Override
        public void note(Identifiable element, DevkitNotification error, Object ... args) {
            this.notifications.add(new Notification(new Details(String.format(error.getMessage(), args), element), NotificationLevel.NOTE));
        }

        @Override
        public void error(Identifiable element, Details details) {
            this.notifications.add(new Notification(details, NotificationLevel.ERROR));
        }

        @Override
        public void warn(Identifiable element, Details details) {
            this.notifications.add(new Notification(details, NotificationLevel.WARNING));
        }

        @Override
        public void note(Identifiable element, Details details) {
            this.notifications.add(new Notification(details, NotificationLevel.NOTE));
        }

        @Override
        public void errorAll(List<? extends Identifiable> elements, DevkitNotification error, Object ... args) {
            for (Identifiable identifiable : elements) {
                this.error(identifiable, error, args);
            }
        }

        @Override
        public void warnAll(List<? extends Identifiable> elements, DevkitNotification error, Object ... args) {
            for (Identifiable identifiable : elements) {
                this.warn(identifiable, error, args);
            }
        }

        @Override
        public void noteAll(List<? extends Identifiable> elements, DevkitNotification error, Object ... args) {
            for (Identifiable identifiable : elements) {
                this.note(identifiable, error, args);
            }
        }

        @Override
        public List<Notification> getNotifications() {
            return new ArrayList<Notification>(this.notifications);
        }

        private List<Notification> filterNotificationsWithLvl(NotificationLevel level) {
            ArrayList<Notification> filteredList = new ArrayList<Notification>();
            for (Notification notification : this.notifications) {
                if (!notification.getLevel().equals((Object)level)) continue;
                filteredList.add(notification);
            }
            return filteredList;
        }

        private boolean hasNotificationsWithLvl(NotificationLevel level) {
            for (Notification notification : this.notifications) {
                if (!notification.getLevel().equals((Object)level)) continue;
                return true;
            }
            return false;
        }
    }
}

