/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;

public class Modifiers
implements Generable {
    private static int VAR = 8;
    private static int FIELD = 799;
    private static int METHOD = 255;
    private static int CLASS = 63;
    private static int INTERFACE = 1;
    private int mods;

    private Modifiers(int mods) {
        this.mods = mods;
    }

    public int getValue() {
        return this.mods;
    }

    private static void check(int mods, int legal, String what) {
        if ((mods & ~legal) != 0) {
            throw new IllegalArgumentException("Illegal modifiers for " + what + ": " + new Modifiers(mods).toString());
        }
    }

    static Modifiers forVar(int mods) {
        Modifiers.check(mods, VAR, "variable");
        return new Modifiers(mods);
    }

    static Modifiers forField(int mods) {
        Modifiers.check(mods, FIELD, "field");
        return new Modifiers(mods);
    }

    static Modifiers forMethod(int mods) {
        Modifiers.check(mods, METHOD, "method");
        return new Modifiers(mods);
    }

    static Modifiers forClass(int mods) {
        Modifiers.check(mods, CLASS, "class");
        return new Modifiers(mods);
    }

    static Modifiers forInterface(int mods) {
        Modifiers.check(mods, INTERFACE, "class");
        return new Modifiers(mods);
    }

    public boolean isAbstract() {
        return (this.mods & 0x20) != 0;
    }

    public boolean isNative() {
        return (this.mods & 0x40) != 0;
    }

    public boolean isSynchronized() {
        return (this.mods & 0x80) != 0;
    }

    public void setSynchronized(boolean newValue) {
        this.setFlag(128, newValue);
    }

    public void setPrivate() {
        this.setFlag(1, false);
        this.setFlag(2, false);
        this.setFlag(4, true);
    }

    public void setProtected() {
        this.setFlag(1, false);
        this.setFlag(2, true);
        this.setFlag(4, false);
    }

    public void setPublic() {
        this.setFlag(1, true);
        this.setFlag(2, false);
        this.setFlag(4, false);
    }

    public void setFinal(boolean newValue) {
        this.setFlag(8, newValue);
    }

    private void setFlag(int bit, boolean newValue) {
        this.mods = this.mods & ~bit | (newValue ? bit : 0);
    }

    @Override
    public void generate(Formatter f) {
        if ((this.mods & 1) != 0) {
            f.p("public");
        }
        if ((this.mods & 2) != 0) {
            f.p("protected");
        }
        if ((this.mods & 4) != 0) {
            f.p("private");
        }
        if ((this.mods & 8) != 0) {
            f.p("final");
        }
        if ((this.mods & 0x10) != 0) {
            f.p("static");
        }
        if ((this.mods & 0x20) != 0) {
            f.p("abstract");
        }
        if ((this.mods & 0x40) != 0) {
            f.p("native");
        }
        if ((this.mods & 0x80) != 0) {
            f.p("synchronized");
        }
        if ((this.mods & 0x100) != 0) {
            f.p("transient");
        }
        if ((this.mods & 0x200) != 0) {
            f.p("volatile");
        }
    }

    public String toString() {
        StringWriter s = new StringWriter();
        Formatter f = new Formatter(new PrintWriter(s));
        this.generate(f);
        return s.toString();
    }
}

