/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Modifiers;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;

public class GeneratedForLoop
implements Statement {
    private List<Object> inits = new ArrayList<Object>();
    private GeneratedExpression test = null;
    private List<GeneratedExpression> updates = new ArrayList<GeneratedExpression>();
    private GeneratedBlock body = null;

    public GeneratedVariable init(int mods, Type type, String var, GeneratedExpression e) {
        GeneratedVariable v = new GeneratedVariable(Modifiers.forVar(mods), type, var, e);
        this.inits.add(v);
        return v;
    }

    public GeneratedVariable init(Type type, String var, GeneratedExpression e) {
        return this.init(0, type, var, e);
    }

    public void init(GeneratedVariable v, GeneratedExpression e) {
        this.inits.add(ExpressionFactory.assign(v, e));
    }

    public void test(GeneratedExpression e) {
        this.test = e;
    }

    public void update(GeneratedExpression e) {
        this.updates.add(e);
    }

    public GeneratedBlock body() {
        if (this.body == null) {
            this.body = new GeneratedBlock();
        }
        return this.body;
    }

    @Override
    public void state(Formatter f) {
        f.p("for (");
        boolean first = true;
        for (Object o : this.inits) {
            if (!first) {
                f.p(',');
            }
            if (o instanceof GeneratedVariable) {
                f.b((GeneratedVariable)o);
            } else {
                f.g((GeneratedExpression)o);
            }
            first = false;
        }
        f.p(';').g(this.test).p(';').g(this.updates).p(')');
        if (this.body != null) {
            f.g(this.body).nl();
        } else {
            f.p(';').nl();
        }
    }
}

