/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;

public class GeneratedFieldReference
extends AbstractExpression
implements AssignmentTarget {
    private Generable object;
    private String name;
    private GeneratedVariable var;
    private boolean explicitThis;

    GeneratedFieldReference(GeneratedExpression object, String name) {
        this((Generable)object, name, false);
    }

    GeneratedFieldReference(GeneratedExpression object, GeneratedVariable v) {
        this((Generable)object, v, false);
    }

    GeneratedFieldReference(Type type, String name) {
        this((Generable)type, name, false);
    }

    GeneratedFieldReference(Type type, GeneratedVariable v) {
        this((Generable)type, v, false);
    }

    GeneratedFieldReference(Generable object, String name, boolean explicitThis) {
        this.explicitThis = explicitThis;
        this.object = object;
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Field name contains '.': " + name);
        }
        this.name = name;
    }

    GeneratedFieldReference(Generable object, GeneratedVariable var, boolean explicitThis) {
        this.explicitThis = explicitThis;
        this.object = object;
        this.var = var;
    }

    public void generate(Formatter f) {
        String name = this.name;
        if (name == null) {
            name = this.var.name();
        }
        if (this.object != null) {
            f.g(this.object).p('.').p(name);
        } else if (this.explicitThis) {
            f.p("this.").p(name);
        } else {
            f.id(name);
        }
    }

    public GeneratedExpression assign(GeneratedExpression rhs) {
        return ExpressionFactory.assign(this, rhs);
    }

    public GeneratedExpression assignPlus(GeneratedExpression rhs) {
        return ExpressionFactory.assignPlus(this, rhs);
    }
}

