/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.Annotable;
import org.mule.devkit.model.code.AnnotationWriter;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedAnnotationUse;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedJavaDocComment;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypedAnnotationWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumConstant
extends AbstractExpression
implements Declaration,
Annotable,
Documentable {
    private final String name;
    private final GeneratedClass type;
    private GeneratedJavaDocComment jdoc = null;
    private List<GeneratedAnnotationUse> annotations = null;
    private List<GeneratedExpression> args = null;

    EnumConstant(GeneratedClass type, String name) {
        this.name = name;
        this.type = type;
    }

    public EnumConstant arg(GeneratedExpression arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        if (this.args == null) {
            this.args = new ArrayList<GeneratedExpression>();
        }
        this.args.add(arg);
        return this;
    }

    public String getName() {
        return this.type.fullName().concat(".").concat(this.name);
    }

    @Override
    public GeneratedJavaDocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new GeneratedJavaDocComment(this.type.owner());
        }
        return this.jdoc;
    }

    @Override
    public GeneratedAnnotationUse annotate(TypeReference clazz) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<GeneratedAnnotationUse>();
        }
        GeneratedAnnotationUse a = new GeneratedAnnotationUse(clazz);
        this.annotations.add(a);
        return a;
    }

    @Override
    public GeneratedAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.type.owner().ref(clazz));
    }

    @Override
    public <W extends AnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<GeneratedAnnotationUse> annotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<GeneratedAnnotationUse>();
        }
        return Collections.unmodifiableList(this.annotations);
    }

    @Override
    public void declare(Formatter f) {
        if (this.jdoc != null) {
            f.nl().g(this.jdoc);
        }
        if (this.annotations != null) {
            for (int i = 0; i < this.annotations.size(); ++i) {
                f.g(this.annotations.get(i)).nl();
            }
        }
        f.id(this.name);
        if (this.args != null) {
            f.p('(').g(this.args).p(')');
        }
    }

    @Override
    public void generate(Formatter f) {
        f.t(this.type).p('.').p(this.name);
    }
}

