/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.dependency;

import java.util.Collection;
import org.mule.devkit.apt.dependency.SimpleDependency;
import org.mule.devkit.apt.dependency.Version;
import org.mule.devkit.apt.dependency.VersionRange;
import org.mule.devkit.generation.api.Dependency;

public class DependencyRule {
    private org.mule.devkit.generation.api.annotations.Dependency dependency;
    private VersionRange genericVersionRange;

    public DependencyRule(org.mule.devkit.generation.api.annotations.Dependency dependency) {
        this.dependency = dependency;
        this.genericVersionRange = new VersionRange(dependency.version());
    }

    public boolean isSatisfiedBy(Collection<Dependency> actualDependencies) {
        for (Dependency actualDependency : actualDependencies) {
            if (!this.dependency.artifactId().equals(actualDependency.getArtifactId()) || !this.dependency.groupId().equals(actualDependency.getGroupId()) || !this.dependency.scope().equals((Object)actualDependency.getScope()) || !this.genericVersionRange.containsVersion(new Version(actualDependency.getVersion()))) continue;
            return !actualDependency.isOptional();
        }
        return false;
    }

    public Dependency getMissingDependency() {
        return this.dependencyFromVersionRange(this.dependency);
    }

    private Dependency dependencyFromVersionRange(org.mule.devkit.generation.api.annotations.Dependency dependency) {
        return new SimpleDependency(dependency.groupId(), dependency.artifactId(), dependency.version(), dependency.scope());
    }
}

