/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.mule.devkit.apt.AnnotationProcessorManifest;
import org.mule.devkit.apt.SilentMessager;
import org.mule.devkit.apt.VerboseMessager;
import org.mule.devkit.apt.model.factory.DefaultPathUtils;
import org.mule.devkit.apt.model.factory.FactoryHolder;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.DevkitMessager;
import org.mule.devkit.generation.api.Manifest;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.apidoc.ModuleModel;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.writer.FilerCodeWriter;
import org.mule.devkit.model.schema.SchemaModel;
import org.mule.devkit.model.studio.StudioModel;

public abstract class AbstractAnnotationProcessorContext
implements Context {
    Filer filer;
    private DevkitMessager messager;
    private CodeModel codeModel;
    private ModuleModel apidocModel;
    private SchemaModel schemaModel;
    private StudioModel studioModel;
    private Types types;
    private AnnotationProcessorManifest manifest;
    private Set<TypeMirror> registeredJaxbElements;
    private Map<Tuple<Product, Identifiable, String>, Object> classesByRole = new HashMap<Tuple<Product, Identifiable, String>, Object>();
    public static final String VERBOSE_ENABLED = "verboseEnabled";

    public AbstractAnnotationProcessorContext(ProcessingEnvironment env) {
        this.filer = env.getFiler();
        FilerCodeWriter filerCodeWriter = new FilerCodeWriter(env.getFiler());
        this.codeModel = new CodeModel((CodeWriter)filerCodeWriter);
        this.schemaModel = new SchemaModel((CodeWriter)filerCodeWriter);
        this.types = env.getTypeUtils();
        this.studioModel = new StudioModel((CodeWriter)filerCodeWriter);
        this.registeredJaxbElements = new HashSet<TypeMirror>();
        this.manifest = new AnnotationProcessorManifest(this);
        this.messager = this.getMessager(env);
        DefaultPathUtils defaultPathUtils = (DefaultPathUtils)FactoryHolder.getPathUtils();
        defaultPathUtils.setTrees(Trees.instance(env));
    }

    private DevkitMessager getMessager(ProcessingEnvironment env) {
        if (Boolean.parseBoolean(env.getOptions().get(VERBOSE_ENABLED))) {
            return new VerboseMessager(env.getMessager());
        }
        return new SilentMessager(env.getMessager());
    }

    public CodeModel getCodeModel() {
        return this.codeModel;
    }

    public SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    public StudioModel getStudioModel() {
        return this.studioModel;
    }

    public ModuleModel getApidocModel() {
        return this.apidocModel;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public Messager getMessager() {
        return this.messager.getMessager();
    }

    public void note(String msg) {
        this.messager.note(msg);
    }

    public void warn(String msg) {
        this.messager.warn(msg);
    }

    public void error(String msg) {
        this.messager.error(msg);
    }

    public void error(String msg, Identifiable element) {
        this.messager.error(msg, element);
    }

    public void warn(String msg, Identifiable element) {
        this.messager.warn(msg, element);
    }

    public void note(String msg, Identifiable element) {
        this.messager.note(msg, element);
    }

    public void printStack(Exception e) {
        this.messager.printStack(e);
    }

    public void debug(String msg) {
        this.messager.debug(msg);
    }

    public <T> T getProduct(Product product) {
        return this.getProduct(new Tuple<Product, Object, Object>(product, null, null));
    }

    public <T> T getProduct(Product product, Identifiable identifiable) {
        return this.getProduct(new Tuple<Product, Identifiable, Object>(product, identifiable, null));
    }

    public <T> T getProduct(Product product, Identifiable identifiable, String methodName) {
        return this.getProduct(new Tuple<Product, Identifiable, String>(product, identifiable, methodName));
    }

    private <T> T getProduct(Tuple<Product, Identifiable, String> tuple) {
        Object t = this.classesByRole.get(tuple);
        if (t == null) {
            this.debug("Null object found while looking up for the tuple " + tuple.toString());
        }
        return (T)t;
    }

    public void registerApidocModel(ModuleModel apidocModel, Identifiable module) {
        this.apidocModel = apidocModel;
        this.registerProduct(Product.APIDOC_MODEL, module, "");
    }

    public <T> void registerProduct(Product product, T clazz) {
        this.classesByRole.put(new Tuple<Product, Object, Object>(product, null, null), clazz);
    }

    public <T> void registerProduct(Product product, Identifiable identifiable, T clazz) {
        this.classesByRole.put(new Tuple<Product, Identifiable, Object>(product, identifiable, null), clazz);
    }

    public <T> void registerProduct(Product product, Identifiable identifiable, String methodName, T clazz) {
        this.classesByRole.put(new Tuple<Product, Identifiable, String>(product, identifiable, methodName), clazz);
    }

    public <T> List<T> getProductList(Product product) {
        ArrayList<Object> generatedClasses = new ArrayList<Object>();
        for (Tuple<Product, Identifiable, String> tuple : this.classesByRole.keySet()) {
            if (!((Product)((Tuple)tuple).first).equals((Object)product)) continue;
            generatedClasses.add(this.classesByRole.get(tuple));
        }
        return generatedClasses;
    }

    public <T> List<T> getModulesByProduct(Product product) {
        ArrayList<Object> modules = new ArrayList<Object>();
        for (Tuple<Product, Identifiable, String> tuple : this.classesByRole.keySet()) {
            if (!((Product)((Tuple)tuple).first).equals((Object)product)) continue;
            modules.add(((Tuple)tuple).second);
        }
        return modules;
    }

    public Filer getFiler() {
        return this.filer;
    }

    private class Tuple<T, U, X> {
        private final T first;
        private final U second;
        private final X third;
        private final transient int hash;

        public Tuple(T f, U s, X x) {
            this.first = f;
            this.second = s;
            this.third = x;
            this.hash = (this.first == null ? 0 : this.first.hashCode() * 31) + (this.second == null ? 0 : this.second.hashCode() * 17) + (this.third == null ? 0 : this.third.hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object oth) {
            if (this == oth) {
                return true;
            }
            if (oth == null || !this.getClass().isInstance(oth)) {
                return false;
            }
            Tuple other = (Tuple)this.getClass().cast(oth);
            return (this.first == null ? other.first == null : this.first.equals(other.first)) && (this.second == null ? other.second == null : this.second.equals(other.second)) && (this.third == null ? other.third == null : this.third.equals(other.third));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            sb.append("Product: ").append(this.first == null ? "null" : this.first.toString());
            sb.append(", Identifiable: ").append(this.second == null ? "null" : this.second.toString());
            sb.append(", MethodName: ").append(this.third == null ? "null" : this.third.toString());
            sb.append("]");
            return sb.toString();
        }
    }
}

