/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model;

import com.google.common.base.Optional;
import java.util.ArrayList;
import javax.inject.Named;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.mule.api.annotations.Query;
import org.mule.api.annotations.display.Text;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Email;
import org.mule.api.annotations.param.MetaDataKeyParam;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.RefOnly;
import org.mule.devkit.apt.model.AnnotationProcessorIdentifiable;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.components.Component;

public abstract class AnnotationProcessorVariable<P extends Identifiable>
extends AnnotationProcessorIdentifiable<VariableElement>
implements Variable<P> {
    protected P parent;
    private int DEFAULT_STRING_MIN_SIZE = 0;
    private int DEFAULT_STRING_MAX_SIZE = Integer.MAX_VALUE;

    public AnnotationProcessorVariable(VariableElement variableElement, P parent, Types types, Elements elements) {
        super(variableElement, types, elements, new ArrayList<Component>());
        this.parent = parent;
    }

    public String getJavaType() {
        return ((VariableElement)this.innerElement).asType().toString();
    }

    public boolean hasSizeLimit() {
        return this.hasAnnotation(Size.class);
    }

    public int getMinSizeLimit() {
        if (this.hasSizeLimit()) {
            return this.getAnnotation(Size.class).min();
        }
        return this.DEFAULT_STRING_MIN_SIZE;
    }

    public int getMaxSizeLimit() {
        if (this.hasSizeLimit()) {
            return this.getAnnotation(Size.class).max();
        }
        return this.DEFAULT_STRING_MAX_SIZE;
    }

    public boolean hasPattern() {
        return this.hasAnnotation(Pattern.class);
    }

    public String getPattern() {
        if (this.hasEmailPattern()) {
            String pattern = this.hasDefaultEmailDomain() ? "[^@]+@[^\\.]+\\..+" : "[^@]+@" + this.getEmailDomain();
            return pattern;
        }
        return this.getAnnotation(Pattern.class).regexp();
    }

    public boolean hasEmailPattern() {
        return this.hasAnnotation(Email.class);
    }

    public String getEmailDomain() {
        return this.getAnnotation(Email.class).domain();
    }

    public boolean hasDefaultEmailDomain() {
        return "".equals(this.getAnnotation(Email.class).domain());
    }

    public boolean isOptional() {
        return this.hasAnnotation(org.mule.api.annotations.param.Optional.class) || this.hasDefaultValue();
    }

    public boolean isPayload() {
        return this.hasAnnotation(Payload.class) || this.hasDefaultValue() && this.getDefaultValue().startsWith("#[payload");
    }

    public boolean hasDefaultValue() {
        return this.hasAnnotation(Default.class);
    }

    public boolean isText() {
        return this.hasAnnotation(Text.class);
    }

    public String getDefaultValue() {
        if (this.hasAnnotation(Default.class)) {
            return this.getAnnotation(Default.class).value();
        }
        return null;
    }

    public P parent() {
        return this.parent;
    }

    public String getAlternativeName() {
        Named named = this.getAnnotation(Named.class);
        String name = this.getName();
        if (named != null && named.value().length() > 0) {
            name = named.value();
        }
        return name;
    }

    public boolean isRefOnly() {
        return this.hasAnnotation(RefOnly.class);
    }

    public Optional<MetaDataKeyParam> metaDataKey() {
        return Optional.fromNullable((Object)this.getAnnotation(MetaDataKeyParam.class));
    }

    public Optional<MetaDataStaticKey> metaDataStaticKey() {
        return Optional.fromNullable((Object)this.getAnnotation(MetaDataStaticKey.class));
    }

    public boolean isQuery() {
        return this.hasAnnotation(Query.class);
    }

    public boolean isArrayOrListOfComplexType(boolean checkGetterAndSetter) {
        return this.asType().isArrayOrList() && !this.getTypeArguments().isEmpty() && this.getTypeArguments().get(0).asTypeMirror().getKind().equals((Object)TypeKind.DECLARED) && this.getTypeArguments().get(0).isComplexTypeWithGetterAndSetter(checkGetterAndSetter);
    }
}

