/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.Query;
import org.mule.api.annotations.QueryPart;
import org.mule.api.annotations.expressions.Expr;
import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.api.annotations.oauth.OAuthAccessTokenSecret;
import org.mule.api.annotations.param.CorrelationGroupSize;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.MessageRootId;
import org.mule.api.annotations.param.MessageUniqueId;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.apt.model.AnnotationProcessorVariable;
import org.mule.devkit.apt.model.factory.FactoryHolder;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.visitor.ModelVisitor;
import org.mule.streaming.PagingConfiguration;

public class AnnotationProcessorParameter<P extends Method>
extends AnnotationProcessorVariable<P>
implements Parameter<P> {
    private static final String PAYLOAD = "#[payload]";
    private static final List<Class<?>> PARAMETER_TYPES_TO_IGNORE = Arrays.asList(SourceCallback.class, PagingConfiguration.class);
    private static final List<Class<? extends Serializable>> PARAMETER_TYPES_TO_INJECT = Arrays.asList(MuleEvent.class, MuleMessage.class);
    private static final List<Class<? extends Annotation>> PARAMETERS_ANNOTATIONS_TO_IGNORE = Arrays.asList(InboundHeaders.class, InvocationHeaders.class, OutboundHeaders.class, SessionHeaders.class, Payload.class, OAuthAccessToken.class, OAuthAccessTokenSecret.class, ExceptionPayload.class, CorrelationId.class, CorrelationSequence.class, CorrelationGroupSize.class, MessageUniqueId.class, MessageRootId.class, Expr.class);

    public AnnotationProcessorParameter(VariableElement element, P parent, Types types, Elements elements) {
        super(element, parent, types, elements);
    }

    public boolean shouldBeIgnored() {
        String variableType = ((VariableElement)this.innerElement).asType().toString();
        for (Class<?> clazz : PARAMETER_TYPES_TO_IGNORE) {
            if (!variableType.contains(clazz.getName())) continue;
            return true;
        }
        for (Class<Object> clazz : PARAMETERS_ANNOTATIONS_TO_IGNORE) {
            if (((VariableElement)this.innerElement).getAnnotation(clazz) == null) continue;
            return true;
        }
        for (Class<Object> clazz : PARAMETER_TYPES_TO_INJECT) {
            if (!variableType.contains(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean shouldBeUIIgnored() {
        return this.shouldBeIgnored() || this.asType().isNestedProcessor() || this.asType().isArrayOrList() && this.getTypeArguments().size() > 0 && this.getTypeArguments().get(0).isNestedProcessor();
    }

    public GenericType getGenericType() {
        return (GenericType)FactoryHolder.getGenericTypeFactory().createGenericType(this.asTypeMirror(), this.types, this.elements, this.innerElement, this.getName()).get();
    }

    @Override
    public boolean isQuery() {
        return this.hasAnnotation(Query.class);
    }

    public boolean hasDefaultPayload() {
        return this.hasAnnotation(Payload.class) || this.hasAnnotation(Default.class) && this.getAnnotation(Default.class).value().equals(PAYLOAD);
    }

    public boolean isQueryPart() {
        return this.hasAnnotation(QueryPart.class);
    }

    public void accept(ModelVisitor visitor) {
        if (!visitor.hasVisited((Identifiable)this)) {
            visitor.visit((Parameter)this);
            Type type = this.asType();
            if (type != null) {
                if (type.isComplexType() && !this.isRefOnly()) {
                    type.accept(visitor);
                    if (type.getSuperClass() != null && type.getSuperClass().isComplexType()) {
                        type.getSuperClass().accept(visitor);
                    }
                } else if (type.isEnum()) {
                    type.accept(visitor);
                } else if (type.isCollection()) {
                    for (Type collectionType : this.getTypeArguments()) {
                        collectionType.accept(visitor);
                    }
                }
            }
        }
    }
}

