/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.jar.Attributes;
import org.mule.devkit.apt.AnnotationProcessor;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.Manifest;

public class AnnotationProcessorManifest
implements Manifest {
    private java.util.jar.Manifest manifest;

    public String getProductVersion() {
        String version = this.getManifestProperty("Specification-Version");
        return version == null ? "Unknown" : version;
    }

    public String getVendorName() {
        return this.getManifestProperty("Specification-Vendor");
    }

    public String getVendorUrl() {
        return this.getManifestProperty("Vendor-Url");
    }

    public String getProductUrl() {
        return this.getManifestProperty("Product-Url");
    }

    public String getProductName() {
        return this.getManifestProperty("Description");
    }

    public String getProductMoreInfo() {
        return this.getManifestProperty("More-Info");
    }

    public String getProductSupport() {
        return this.getManifestProperty("Support");
    }

    public String getProductLicenseInfo() {
        return this.getManifestProperty("License");
    }

    public String getBuildNumber() {
        String version = this.getManifestProperty("Implementation-Version");
        return version == null ? "Unknown" : version;
    }

    public String getDevListEmail() {
        return this.getManifestProperty("Dev-List-Email");
    }

    public String getSupportedJdks() {
        return this.getManifestProperty("Supported-Jdks");
    }

    public String getRecommndedJdks() {
        return this.getManifestProperty("Recommended-Jdks");
    }

    public AnnotationProcessorManifest(final Context context) {
        if (this.manifest == null) {
            this.manifest = new java.util.jar.Manifest();
            InputStream is = null;
            try {
                URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        try {
                            Enumeration<URL> e = AnnotationProcessor.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                            while (e.hasMoreElements()) {
                                URL url = e.nextElement();
                                if ((url.toExternalForm().indexOf("generation-core") <= -1 || url.toExternalForm().indexOf("tests.jar") >= 0) && !url.toExternalForm().matches(".*mule.*-.*-embedded.*\\.jar.*")) continue;
                                return url;
                            }
                            String pathSeparator = System.getProperty("file.separator");
                            String testManifestPath = "core" + pathSeparator + "target" + pathSeparator + "test-classes";
                            e = AnnotationProcessor.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                            while (e.hasMoreElements()) {
                                URL url = e.nextElement();
                                if ((url.toExternalForm().indexOf(testManifestPath) <= -1 || url.toExternalForm().indexOf("tests.jar") >= 0) && !url.toExternalForm().matches(".*mule.*-.*-embedded.*\\.jar.*")) continue;
                                return url;
                            }
                        }
                        catch (IOException e1) {
                            context.warn("Failure reading manifest: " + e1.getMessage());
                        }
                        return null;
                    }
                });
                if (url != null) {
                    is = url.openStream();
                }
                if (is != null) {
                    this.manifest.read(is);
                }
            }
            catch (IOException e) {
                context.warn("Failed to read manifest info. Manifest information will not display correctly: " + e.getMessage());
            }
        }
    }

    private String getManifestProperty(String name) {
        return this.manifest.getMainAttributes().getValue(new Attributes.Name(name));
    }
}

