/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.api.annotations.MetaDataKeyRetriever;
import org.mule.api.annotations.MetaDataOutputRetriever;
import org.mule.api.annotations.MetaDataRetriever;
import org.mule.devkit.apt.model.AnnotationProcessorField;
import org.mule.devkit.apt.model.AnnotationProcessorType;
import org.mule.devkit.apt.model.AnnotationProcessorTypeFactory;
import org.mule.devkit.model.ClassType;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.components.Component;

public class AnnotationProcessorClass
extends AnnotationProcessorType
implements ClassType {
    public AnnotationProcessorClass(TypeElement innerElement, Types types, Elements elements, List<Component> components) {
        super(innerElement, types, elements, components);
    }

    public List<Field> getInjectFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(current.getEnclosedElements())) {
                if (variableElement.getAnnotation(Inject.class) == null) continue;
                if (current == this.innerElement) {
                    fields.add(new AnnotationProcessorField<AnnotationProcessorClass>(variableElement, this, this.types, this.elements));
                    continue;
                }
                Object type = AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.components);
                fields.add(new AnnotationProcessorField(variableElement, type, this.types, this.elements));
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return fields;
    }

    public Method getMetaDataKeyRetrieverMethod() {
        return this.getRecursivelyFirstMethodAnnotatedWith(MetaDataKeyRetriever.class);
    }

    public Method getMetaDataRetrieverMethod() {
        return this.getRecursivelyFirstMethodAnnotatedWith(MetaDataRetriever.class);
    }

    public Method getMetaDataOutputRetrieverMethod() {
        return this.getRecursivelyFirstMethodAnnotatedWith(MetaDataOutputRetriever.class);
    }
}

