/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.apache.commons.lang.StringUtils;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.ExpressionLanguage;
import org.mule.api.annotations.Module;
import org.mule.devkit.apt.AnnotationProcessorContext;
import org.mule.devkit.apt.dependency.DependencyValidator;
import org.mule.devkit.apt.model.AnnotationProcessorTypeFactory;
import org.mule.devkit.apt.model.ComponentTypeFactory;
import org.mule.devkit.apt.model.factory.FactoryHolder;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Generator;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.MultiModuleAnnotationVerifier;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Plugin;
import org.mule.devkit.generation.api.PostProcessor;
import org.mule.devkit.generation.api.PostProcessorException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.ProjectVerifier;
import org.mule.devkit.generation.api.Verifier;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.api.gatherer.DefaultGathererFactory;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.generation.api.gatherer.printing.GathererPrinterHelper;
import org.mule.devkit.generation.api.gatherer.printing.PrinterGatherer;
import org.mule.devkit.model.module.components.Component;

public abstract class AbstractAnnotationProcessor
extends AbstractProcessor {
    protected Context context;
    private Set<Class> alreadyExecutedVerifiers;
    private Set<Class> alreadyExecutedGenerators = new HashSet<Class>();
    private DependencyValidator dependencyValidator;
    protected NotificationGatherer notificationGatherer;
    protected List<? extends Verifier> annotationVerifiers = null;
    protected List<Generator> sortedModuleGenerators = null;
    protected List<PostProcessor> postProcessors = null;
    protected PrinterGatherer printer;

    public abstract List<? extends Verifier> getAnnotationVerifiers();

    public abstract List<Generator> getGenerators();

    public abstract List<PostProcessor> getPostProcessors();

    protected abstract Plugin getPluginFromVerifier(Verifier var1);

    public AbstractAnnotationProcessor() {
        this.alreadyExecutedVerifiers = new HashSet<Class>();
        this.dependencyValidator = new DependencyValidator();
        this.notificationGatherer = new DefaultGathererFactory().create();
        this.printer = new GathererPrinterHelper();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        if (!this.typeExists(annotations, env)) {
            return true;
        }
        this.createContext();
        this.initialize();
        this.doProcess(annotations, env);
        this.postProcess();
        this.dispose();
        return true;
    }

    protected void dispose() {
        this.annotationVerifiers = null;
        this.sortedModuleGenerators = null;
        this.postProcessors = null;
        this.printer = null;
        this.context = null;
        FactoryHolder.dispose();
    }

    private boolean shouldSkipCodeGeneration() {
        return "true".equals(System.getProperty("devkit.generation.skip"));
    }

    private void syncStudioModel() throws IOException {
        this.context.getStudioModel().build();
    }

    private void syncSchema() throws IOException {
        this.context.getSchemaModel().build();
    }

    private void syncCodeModel() throws IOException {
        this.context.getCodeModel().build();
    }

    protected boolean typeExists(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        int size = 0;
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = env.getElementsAnnotatedWith(typeElement);
            Set<TypeElement> typeElements = ElementFilter.typesIn(elements);
            size += typeElements.size();
        }
        return size > 0;
    }

    protected void runVerifiers(List<? extends Verifier> annotationVerifiers, List<org.mule.devkit.model.module.Module> modules, List<Component> components) throws AnnotationVerificationException {
        for (Verifier verifier : annotationVerifiers) {
            if (!(verifier instanceof ProjectVerifier)) continue;
            ((ProjectVerifier)verifier).setCxt(this.context);
        }
        for (org.mule.devkit.model.module.Module module : modules) {
            this.verifyModule(module, annotationVerifiers);
        }
        this.verifyModules(modules, annotationVerifiers);
    }

    protected void runGenerators(List<Generator> sortedGenerators, List<org.mule.devkit.model.module.Module> modules, List<Component> components) throws GenerationException, Exception {
        for (Generator generator : sortedGenerators) {
            try {
                boolean shouldExecute;
                MultiModuleGenerator multiModuleGenerator;
                generator.setCtx(this.context);
                if (generator instanceof ModuleGenerator) {
                    ModuleGenerator moduleGenerator = (ModuleGenerator)generator;
                    for (org.mule.devkit.model.module.Module module : modules) {
                        boolean shouldExecute2;
                        if (!moduleGenerator.shouldGenerate(module) || !(shouldExecute2 = this.shouldGeneratorBeExecuted((Generator)moduleGenerator))) continue;
                        moduleGenerator.generate(module);
                    }
                    continue;
                }
                if (!(generator instanceof MultiModuleGenerator) || !(multiModuleGenerator = (MultiModuleGenerator)generator).shouldGenerate(modules) || !(shouldExecute = this.shouldGeneratorBeExecuted((Generator)multiModuleGenerator))) continue;
                List processableModules = multiModuleGenerator.processableModules(modules);
                multiModuleGenerator.generate(processableModules);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.context.debug("Something went wrong while using the generator " + generator.toString());
                throw e;
            }
        }
    }

    private List<Component> getComponents(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = env.getElementsAnnotatedWith(typeElement);
            Set<TypeElement> typeElements = ElementFilter.typesIn(elements);
            for (TypeElement t : typeElements) {
                Optional<Component> maybeComponent = ComponentTypeFactory.createComponent(t, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils());
                if (!maybeComponent.isPresent() || result.contains(maybeComponent.get())) continue;
                result.add((Component)maybeComponent.get());
            }
        }
        return result;
    }

    private List<org.mule.devkit.model.module.Module> getModules(Set<? extends TypeElement> annotations, RoundEnvironment env, List<Component> components) {
        ArrayList<org.mule.devkit.model.module.Module> modules = new ArrayList<org.mule.devkit.model.module.Module>();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = env.getElementsAnnotatedWith(typeElement);
            Set<TypeElement> typeElements = ElementFilter.typesIn(elements);
            for (TypeElement e : typeElements) {
                List<Component> unrepeatedComponents = this.extractRepeatedElements(components, e);
                Object type = AnnotationProcessorTypeFactory.createType(e, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils(), unrepeatedComponents);
                if (!(type instanceof org.mule.devkit.model.module.Module)) continue;
                modules.add((org.mule.devkit.model.module.Module)type);
            }
        }
        return modules;
    }

    private List<Component> extractRepeatedElements(List<Component> components, TypeElement e) {
        ArrayList<Component> unrepeatedComponents = new ArrayList<Component>();
        for (Component component : components) {
            if (((TypeElement)component.unwrap()).equals(e)) continue;
            unrepeatedComponents.add(component);
        }
        return unrepeatedComponents;
    }

    private boolean shouldVerifierBeExecuted(Verifier verifier) {
        return this.shouldBeExecuted(verifier.getClass(), this.alreadyExecutedVerifiers);
    }

    private boolean shouldGeneratorBeExecuted(Generator generator) {
        return this.shouldBeExecuted(generator.getClass(), this.alreadyExecutedGenerators);
    }

    private boolean shouldBeExecuted(Class clazz, Set<Class> executedClasses) {
        boolean shouldExecute = true;
        if (clazz.getAnnotation(JustOnce.class) != null) {
            if (executedClasses.contains(clazz)) {
                shouldExecute = false;
            } else {
                executedClasses.add(clazz);
                shouldExecute = true;
            }
        }
        return shouldExecute;
    }

    private void verifyModule(org.mule.devkit.model.module.Module module, List<? extends Verifier> annotationVerifiers) throws AnnotationVerificationException {
        this.context.note("Validating " + module.getName() + " class");
        for (Verifier verifier : annotationVerifiers) {
            ModuleAnnotationVerifier moduleAnnotationVerifier;
            if (!(verifier instanceof ModuleAnnotationVerifier) || !(moduleAnnotationVerifier = (ModuleAnnotationVerifier)verifier).shouldVerify(module)) continue;
            this.dependencyValidator.validate(this.context, module, (Verifier)moduleAnnotationVerifier, this.getPluginFromVerifier((Verifier)moduleAnnotationVerifier));
            boolean shouldExecute = this.shouldVerifierBeExecuted((Verifier)moduleAnnotationVerifier);
            if (!shouldExecute) continue;
            this.doVerify(module, moduleAnnotationVerifier);
        }
    }

    private void verifyModules(List<org.mule.devkit.model.module.Module> modules, List<? extends Verifier> annotationVerifiers) throws AnnotationVerificationException {
        this.context.note("Validating Multi-module consistency");
        for (Verifier verifier : annotationVerifiers) {
            MultiModuleAnnotationVerifier moduleAnnotationVerifier;
            if (!(verifier instanceof MultiModuleAnnotationVerifier) || !(moduleAnnotationVerifier = (MultiModuleAnnotationVerifier)verifier).shouldVerify(modules)) continue;
            this.dependencyValidator.validate(this.context, modules, (Verifier)moduleAnnotationVerifier, this.getPluginFromVerifier((Verifier)moduleAnnotationVerifier));
            boolean shouldExecute = this.shouldVerifierBeExecuted((Verifier)moduleAnnotationVerifier);
            if (!shouldExecute) continue;
            List processableModules = moduleAnnotationVerifier.processableModules(modules);
            this.doVerify(processableModules, moduleAnnotationVerifier);
        }
    }

    private void printGenerationOrder(List<Generator> generators) {
        this.context.debug("The generators will be executed in the following order:");
        int i = 0;
        for (Generator generator : generators) {
            this.context.debug(Integer.toString(i) + ") " + generator.getClass().getName());
            ++i;
        }
    }

    private List<Generator> topologicalSort(List<Generator> moduleGenerators) {
        SimpleDirectedGraph generationGraph = new SimpleDirectedGraph(DefaultEdge.class);
        ArrayList<Generator> sortedModuleGenerators = new ArrayList<Generator>();
        for (Generator moduleGenerator : moduleGenerators) {
            generationGraph.addVertex((Object)moduleGenerator);
        }
        for (Generator consumer : generationGraph.vertexSet()) {
            for (Product product : consumer.consumes()) {
                for (Generator producer : generationGraph.vertexSet()) {
                    if (producer == consumer || !producer.produces().contains(product)) continue;
                    DefaultEdge addedEdge = (DefaultEdge)generationGraph.addEdge((Object)producer, (Object)consumer);
                    CycleDetector cycleDetector = new CycleDetector((DirectedGraph)generationGraph);
                    if (!cycleDetector.detectCycles()) continue;
                    generationGraph.removeEdge((Object)addedEdge);
                }
            }
        }
        TopologicalOrderIterator iterator = new TopologicalOrderIterator((DirectedGraph)generationGraph);
        while (iterator.hasNext()) {
            sortedModuleGenerators.add((Generator)iterator.next());
        }
        return sortedModuleGenerators;
    }

    protected void createContext() {
        this.context = new AnnotationProcessorContext(this.processingEnv);
    }

    protected Context getContext() {
        return this.context;
    }

    protected void initialize() {
        this.annotationVerifiers = this.getAnnotationVerifiers();
        List<Generator> moduleGenerators = this.getGenerators();
        this.postProcessors = this.getPostProcessors();
        this.context.note("Sorting generator executing based on their dependencies...");
        this.sortedModuleGenerators = this.topologicalSort(moduleGenerators);
        this.printGenerationOrder(this.sortedModuleGenerators);
    }

    protected boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        try {
            if (this.shouldSkipCodeGeneration()) {
                this.context.debug("Devkit Code Generation is being SKIPPED");
            } else {
                Set<? extends TypeElement> componentAnnotations = this.getComponentAnnotations(annotations);
                List<Component> components = this.getComponents(componentAnnotations, env);
                Set<? extends TypeElement> moduleAnnotations = this.getModuleAnnotations(annotations);
                List<org.mule.devkit.model.module.Module> modules = this.getModules(moduleAnnotations, env, components);
                this.runVerifiers(this.annotationVerifiers, modules, components);
                if (!this.notificationGatherer.hasErrors()) {
                    this.runGenerators(this.sortedModuleGenerators, modules, components);
                }
            }
            if (!this.notificationGatherer.hasErrors()) {
                this.syncCodeModel();
                this.syncSchema();
                this.syncStudioModel();
            }
            return true;
        }
        catch (AnnotationVerificationException ave) {
            this.context.error(ave.getMessage(), ave.getElement());
            this.context.printStack((Exception)((Object)ave));
        }
        catch (GenerationException ge) {
            this.context.error(ge.getMessage());
            this.context.printStack((Exception)((Object)ge));
        }
        catch (IOException e) {
            this.context.error(e.getMessage());
            this.context.printStack((Exception)e);
        }
        catch (Exception e) {
            this.context.error(e.getMessage());
            this.context.printStack(e);
        }
        return false;
    }

    protected void postProcess() {
        try {
            if (!this.notificationGatherer.hasErrors()) {
                for (PostProcessor postProcessor : this.postProcessors) {
                    postProcessor.postProcess(this.context, this.notificationGatherer);
                }
            }
            if (this.notificationGatherer.hasNotifications()) {
                this.printer.printNotes(this.notificationGatherer, this.processingEnv, this.context);
                this.printer.printWarnings(this.notificationGatherer, this.processingEnv, this.context);
                this.printer.printErrors(this.notificationGatherer, this.processingEnv, this.context);
            }
        }
        catch (PostProcessorException e) {
            this.context.error(e.getMessage());
        }
    }

    protected void doVerify(org.mule.devkit.model.module.Module module, ModuleAnnotationVerifier moduleAnnotationVerifier) throws AnnotationVerificationException {
        moduleAnnotationVerifier.verify(module, this.notificationGatherer);
    }

    protected void doVerify(List<org.mule.devkit.model.module.Module> modules, MultiModuleAnnotationVerifier moduleAnnotationVerifier) throws AnnotationVerificationException {
        moduleAnnotationVerifier.verify(modules, this.notificationGatherer);
    }

    private Set<? extends TypeElement> getComponentAnnotations(Set<? extends TypeElement> annotations) {
        return new HashSet(Collections2.filter(annotations, (Predicate)new Predicate<TypeElement>(){

            public boolean apply(TypeElement annotation) {
                return !AbstractAnnotationProcessor.this.isModule(annotation);
            }
        }));
    }

    private Set<? extends TypeElement> getModuleAnnotations(Set<? extends TypeElement> annotations) {
        return new HashSet(Collections2.filter(annotations, (Predicate)new Predicate<TypeElement>(){

            public boolean apply(TypeElement annotation) {
                return AbstractAnnotationProcessor.this.isModule(annotation);
            }
        }));
    }

    private boolean isModule(TypeElement annotation) {
        String fullQualifiedName = annotation.getQualifiedName().toString();
        return StringUtils.equals((String)fullQualifiedName, (String)Connector.class.getCanonicalName()) || StringUtils.equals((String)fullQualifiedName, (String)ExpressionLanguage.class.getCanonicalName()) || StringUtils.equals((String)fullQualifiedName, (String)Module.class.getCanonicalName());
    }
}

