/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model.module.oauth;

import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.api.annotations.oauth.OAuthAccessTokenIdentifier;
import org.mule.api.annotations.oauth.OAuthAccessTokenSecret;
import org.mule.api.annotations.oauth.OAuthCallbackParameter;
import org.mule.api.annotations.oauth.OAuthConsumerKey;
import org.mule.api.annotations.oauth.OAuthConsumerSecret;
import org.mule.api.annotations.oauth.OAuthPostAuthorization;
import org.mule.api.annotations.oauth.OAuthScope;
import org.mule.devkit.apt.model.AnnotationProcessorMethod;
import org.mule.devkit.apt.model.AnnotationProcessorTypeFactory;
import org.mule.devkit.apt.model.module.oauth.AnnotationProcessorOAuthCallbackParameterField;
import org.mule.devkit.apt.model.module.oauth.OAnnotationProcessorOAuthAuthorizationParameter;
import org.mule.devkit.apt.model.module.rest.AnnotationProcessorRestModule;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthCallbackParameterField;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.visitor.ModelVisitor;

public class AnnotationProcessorOAuthModule
extends AnnotationProcessorRestModule
implements OAuthModule {
    private static String stringType;

    public AnnotationProcessorOAuthModule(TypeElement innerElement, Types types, Elements elements, Trees trees) {
        super(innerElement, types, elements, trees);
    }

    public OAuthVersion getOAuthVersion() {
        if (((TypeElement)this.innerElement).getAnnotation(OAuth.class) != null) {
            return OAuthVersion.V10A;
        }
        if (((TypeElement)this.innerElement).getAnnotation(OAuth2.class) != null) {
            return OAuthVersion.V2;
        }
        return OAuthVersion.UNKNOWN;
    }

    @Override
    public boolean needsConfig() {
        return true;
    }

    public Field getConsumerKeyField() {
        for (Field<Type> field : this.getFields()) {
            if (field.getAnnotation(OAuthConsumerKey.class) == null) continue;
            return field;
        }
        return null;
    }

    public Field getConsumerSecretField() {
        for (Field<Type> field : this.getFields()) {
            if (field.getAnnotation(OAuthConsumerSecret.class) == null) continue;
            return field;
        }
        return null;
    }

    public Field getAccessTokenField() {
        for (Field<Type> field : this.getFields()) {
            if (field.getAnnotation(OAuthAccessToken.class) == null) continue;
            return field;
        }
        return null;
    }

    public Field getScopeField() {
        for (Field<Type> field : this.getFields()) {
            if (field.getAnnotation(OAuthScope.class) == null) continue;
            return field;
        }
        return null;
    }

    public Field getAccessTokenSecretField() {
        for (Field<Type> field : this.getFields()) {
            if (field.getAnnotation(OAuthAccessTokenSecret.class) == null) continue;
            return field;
        }
        return null;
    }

    public String getVerifierRegex() {
        if (((TypeElement)this.innerElement).getAnnotation(OAuth.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth.class).verifierRegex();
        }
        if (((TypeElement)this.innerElement).getAnnotation(OAuth2.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).verifierRegex();
        }
        return null;
    }

    public String getRequestTokenUrl() {
        if (((TypeElement)this.innerElement).getAnnotation(OAuth.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth.class).requestTokenUrl();
        }
        return null;
    }

    public String getAccessTokenUrl() {
        if (((TypeElement)this.innerElement).getAnnotation(OAuth.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth.class).accessTokenUrl();
        }
        if (((TypeElement)this.innerElement).getAnnotation(OAuth2.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).accessTokenUrl();
        }
        return null;
    }

    public String getAuthorizationUrl() {
        if (((TypeElement)this.innerElement).getAnnotation(OAuth.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth.class).authorizationUrl();
        }
        if (((TypeElement)this.innerElement).getAnnotation(OAuth2.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).authorizationUrl();
        }
        return null;
    }

    public String getExpirationRegex() {
        if (((TypeElement)this.innerElement).getAnnotation(OAuth2.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).expirationRegex();
        }
        return null;
    }

    public String getAccessTokenRegex() {
        if (((TypeElement)this.innerElement).getAnnotation(OAuth2.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).accessTokenRegex();
        }
        return null;
    }

    public String getRefreshTokenRegex() {
        if (((TypeElement)this.innerElement).getAnnotation(OAuth2.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).refreshTokenRegex();
        }
        return null;
    }

    public List<OAuthAuthorizationParameter> getAuthorizationParameters() {
        if (((TypeElement)this.innerElement).getAnnotation(OAuth2.class) != null && ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).authorizationParameters().length == 0) {
            return null;
        }
        if (((TypeElement)this.innerElement).getAnnotation(OAuth.class) != null && ((TypeElement)this.innerElement).getAnnotation(OAuth.class).authorizationParameters().length == 0) {
            return null;
        }
        ArrayList<OAuthAuthorizationParameter> authorizationParameters = new ArrayList<OAuthAuthorizationParameter>();
        List<AnnotationMirror> annotationMirrors = this.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (OAuth2.class.getName().equals(annotationMirror.getAnnotationType().toString())) {
                this.getAuthorizationParametersFromAnnotationMirror(authorizationParameters, annotationMirror);
                continue;
            }
            if (!OAuth.class.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
            this.getAuthorizationParametersFromAnnotationMirror(authorizationParameters, annotationMirror);
        }
        return authorizationParameters;
    }

    private void getAuthorizationParametersFromAnnotationMirror(List<OAuthAuthorizationParameter> authorizationParameters, AnnotationMirror annotationMirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!"authorizationParameters".equals(entry.getKey().getSimpleName().toString())) continue;
            for (AnnotationValue value : (List)entry.getValue().getValue()) {
                AnnotationValue parameter = (AnnotationValue)value.getValue();
                AnnotationMirror secondMirror = (AnnotationMirror)parameter.getValue();
                DeclaredType type = null;
                String name = "";
                boolean isOptional = false;
                String defaultValue = "";
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> secondEntry : secondMirror.getElementValues().entrySet()) {
                    if ("type".equals(secondEntry.getKey().getSimpleName().toString())) {
                        type = (DeclaredType)secondEntry.getValue().getValue();
                    }
                    if ("name".equals(secondEntry.getKey().getSimpleName().toString())) {
                        name = (String)secondEntry.getValue().getValue();
                    }
                    if ("optional".equals(secondEntry.getKey().getSimpleName().toString())) {
                        isOptional = (Boolean)secondEntry.getValue().getValue();
                    }
                    if (!"defaultValue".equals(secondEntry.getKey().getSimpleName().toString())) continue;
                    defaultValue = (String)secondEntry.getValue().getValue();
                }
                Object realType = AnnotationProcessorTypeFactory.createType((TypeElement)type.asElement(), this.types, this.elements, this.trees);
                authorizationParameters.add(new OAnnotationProcessorOAuthAuthorizationParameter(name, isOptional, defaultValue, (Type)realType));
            }
        }
    }

    public List<OAuthCallbackParameterField> getCallbackParameters() {
        ArrayList<OAuthCallbackParameterField> fields = new ArrayList<OAuthCallbackParameterField>();
        for (VariableElement variableElement : ElementFilter.fieldsIn(((TypeElement)this.innerElement).getEnclosedElements())) {
            if (variableElement.getAnnotation(OAuthCallbackParameter.class) == null) continue;
            fields.add(new AnnotationProcessorOAuthCallbackParameterField(variableElement, this, this.types, this.elements, this.trees));
        }
        return fields;
    }

    public Method<OAuthModule> getPostAuthorizationMethod() {
        for (ExecutableElement executableElement : ElementFilter.methodsIn(((TypeElement)this.innerElement).getEnclosedElements())) {
            if (executableElement.getAnnotation(OAuthPostAuthorization.class) == null) continue;
            return new AnnotationProcessorMethod<OAuthModule>(executableElement, this, this.types, this.elements, this.trees);
        }
        return null;
    }

    public Method<OAuthModule> getUserIdentifierMethod() {
        for (ExecutableElement executableElement : ElementFilter.methodsIn(((TypeElement)this.innerElement).getEnclosedElements())) {
            if (executableElement.getAnnotation(OAuthAccessTokenIdentifier.class) == null) continue;
            return new AnnotationProcessorMethod<OAuthModule>(executableElement, this, this.types, this.elements, this.trees);
        }
        return null;
    }

    @Override
    public void accept(ModelVisitor visitor) {
        if (!visitor.hasVisited((Identifiable)this)) {
            super.accept(visitor);
            List<OAuthAuthorizationParameter> authorizationParameters = this.getAuthorizationParameters();
            if (authorizationParameters != null) {
                for (OAuthAuthorizationParameter authorizationParameter : authorizationParameters) {
                    authorizationParameter.getType().accept(visitor);
                }
            }
        }
    }

    public DeclaredType getOAuthProvider() {
        if (this.getAnnotation(OAuth.class) != null) {
            String oauth = OAuth.class.getName();
            DeclaredType provider = null;
            List<AnnotationMirror> annotationMirrors = this.getAnnotationMirrors();
            block0: for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!oauth.equals(annotationMirror.getAnnotationType().toString())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!"provider".equals(entry.getKey().getSimpleName().toString())) continue;
                    provider = (DeclaredType)entry.getValue().getValue();
                    continue block0;
                }
            }
            return provider;
        }
        return null;
    }
}

