/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;
import javax.xml.bind.annotation.XmlType;
import org.mule.api.NestedProcessor;
import org.mule.api.callback.HttpCallback;
import org.mule.devkit.apt.model.AnnotationProcessorField;
import org.mule.devkit.apt.model.AnnotationProcessorIdentifiable;
import org.mule.devkit.apt.model.AnnotationProcessorMethod;
import org.mule.devkit.apt.model.AnnotationProcessorPackage;
import org.mule.devkit.apt.model.AnnotationProcessorTypeFactory;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Package;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.model.visitor.ModelVisitor;

public class AnnotationProcessorType
extends AnnotationProcessorIdentifiable<TypeElement>
implements Type {
    public AnnotationProcessorType(TypeElement innerElement, Types types, Elements elements, Trees trees) {
        super(innerElement, types, elements, trees);
    }

    public boolean isParametrized() {
        return !((TypeElement)this.innerElement).getTypeParameters().isEmpty();
    }

    public List<Method<Type>> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        ArrayList<Method<Type>> result = new ArrayList<Method<Type>>();
        for (Method<Type> method : this.getMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            result.add(method);
        }
        return result;
    }

    public boolean hasFieldAnnotatedWith(Class<? extends Annotation> annotation) {
        for (Field<Type> field : this.getFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    public List<Field<Type>> getFields() {
        ArrayList<Field<Type>> fields = new ArrayList<Field<Type>>();
        for (VariableElement variableElement : ElementFilter.fieldsIn(((TypeElement)this.innerElement).getEnclosedElements())) {
            fields.add(new AnnotationProcessorField<AnnotationProcessorType>(variableElement, this, this.types, this.elements, this.trees));
        }
        return fields;
    }

    public List<Field<Type>> getInheritedFields() {
        ArrayList<Field<Type>> fields = new ArrayList<Field<Type>>();
        if (!"java.lang.Object".equals(((TypeElement)this.innerElement).getSuperclass()) && ((TypeElement)this.innerElement).getSuperclass() instanceof Type.ClassType) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(((Symbol.TypeSymbol)((Type.ClassType)((TypeElement)this.innerElement).getSuperclass()).asElement()).getEnclosedElements())) {
                fields.add(new AnnotationProcessorField<AnnotationProcessorType>(variableElement, this, this.types, this.elements, this.trees));
            }
        }
        return fields;
    }

    public Type getSuperClass() {
        if (!"java.lang.Object".equals(((Object)((TypeElement)this.innerElement).getSuperclass()).toString()) && ((TypeElement)this.innerElement).getSuperclass() instanceof Type.ClassType) {
            Element type = this.types.asElement(((TypeElement)this.innerElement).getSuperclass());
            return AnnotationProcessorTypeFactory.createType((TypeElement)type, this.types, this.elements, this.trees);
        }
        return null;
    }

    public boolean hasSuperClass() {
        return this.getSuperClass() != null;
    }

    public Package getPackage() {
        if (((TypeElement)this.innerElement).getEnclosingElement() instanceof PackageElement) {
            return new AnnotationProcessorPackage((PackageElement)((TypeElement)this.innerElement).getEnclosingElement(), this.types, this.elements, this.trees);
        }
        if (((TypeElement)this.innerElement).getEnclosingElement() instanceof TypeElement) {
            return AnnotationProcessorTypeFactory.createType((TypeElement)((TypeElement)this.innerElement).getEnclosingElement(), this.types, this.elements, this.trees).getPackage();
        }
        return null;
    }

    public List<Method<Type>> getMethods() {
        ArrayList<Method<Type>> methods = new ArrayList<Method<Type>>();
        for (ExecutableElement executableElement : ElementFilter.methodsIn(((TypeElement)this.innerElement).getEnclosedElements())) {
            methods.add(new AnnotationProcessorMethod<AnnotationProcessorType>(executableElement, this, this.types, this.elements, this.trees));
        }
        return methods;
    }

    public boolean hasNoArgConstructor() {
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(((TypeElement)this.innerElement).getEnclosedElements())) {
            if (!executableElement.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isInterface() {
        return ((TypeElement)this.innerElement).getKind() == ElementKind.INTERFACE;
    }

    public boolean isPrimitive() {
        return ((TypeElement)this.innerElement).asType() != null && ((TypeElement)this.innerElement).asType().getKind() != null && ((TypeElement)this.innerElement).asType().getKind().isPrimitive();
    }

    public Name getQualifiedName() {
        return ((TypeElement)this.innerElement).getQualifiedName();
    }

    public String getPathToSourceFile() {
        TreePath path = this.trees.getPath(this.innerElement);
        JavaFileObject source = path.getCompilationUnit().getSourceFile();
        return source.toUri().getPath();
    }

    private String getBinaryName() {
        return this.elements.getBinaryName((TypeElement)this.innerElement).toString();
    }

    public String getPackageName() {
        int lastDot = this.getBinaryName().lastIndexOf(46);
        return this.getBinaryName().substring(0, lastDot);
    }

    public String getClassName() {
        int lastDot = this.getBinaryName().lastIndexOf(46);
        return this.getBinaryName().substring(lastDot + 1);
    }

    public boolean isXmlType() {
        DeclaredType declaredType;
        XmlType xmlType;
        return this.asTypeMirror().getKind() == TypeKind.DECLARED && (xmlType = (declaredType = (DeclaredType)this.asTypeMirror()).asElement().getAnnotation(XmlType.class)) != null;
    }

    public boolean isCollection() {
        return this.isArrayOrList(this.asTypeMirror()) || this.isMap(this.asTypeMirror()) || this.isSet(this.asTypeMirror());
    }

    public boolean isNestedProcessor() {
        return ((Object)this.asTypeMirror()).toString().startsWith(NestedProcessor.class.getName());
    }

    public boolean isArrayOrList() {
        return this.isArrayOrList(this.asTypeMirror());
    }

    private boolean isArrayOrList(TypeMirror type) {
        if (((Object)type).toString().equals("byte[]")) {
            return false;
        }
        if (type.getKind() == TypeKind.ARRAY) {
            return true;
        }
        if (((Object)type).toString().startsWith(List.class.getName())) {
            return true;
        }
        List<? extends TypeMirror> inherits = this.types.directSupertypes(type);
        for (TypeMirror typeMirror : inherits) {
            if (!this.isArrayOrList(typeMirror)) continue;
            return true;
        }
        return false;
    }

    public boolean isSet() {
        return this.isSet(this.asTypeMirror());
    }

    private boolean isSet(TypeMirror type) {
        if (((Object)type).toString().startsWith(Set.class.getName())) {
            return true;
        }
        List<? extends TypeMirror> inherits = this.types.directSupertypes(type);
        for (TypeMirror typeMirror : inherits) {
            if (!this.isSet(typeMirror)) continue;
            return true;
        }
        return false;
    }

    public boolean isMap() {
        return this.isMap(this.asTypeMirror());
    }

    private boolean isMap(TypeMirror type) {
        if (((Object)type).toString().startsWith(Map.class.getName())) {
            return true;
        }
        List<? extends TypeMirror> inherits = this.types.directSupertypes(type);
        for (TypeMirror typeMirror : inherits) {
            if (!this.isMap(typeMirror)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnum() {
        return this.isEnum(this.asTypeMirror());
    }

    private boolean isEnum(TypeMirror type) {
        if (((Object)type).toString().startsWith(Enum.class.getName())) {
            return true;
        }
        List<? extends TypeMirror> inherits = this.types.directSupertypes(type);
        for (TypeMirror typeMirror : inherits) {
            if (!this.isEnum(typeMirror)) continue;
            return true;
        }
        return false;
    }

    public boolean isString() {
        String className = ((Object)((TypeElement)this.innerElement).asType()).toString();
        return className.startsWith(String.class.getName());
    }

    public boolean isBoolean() {
        String className = ((Object)((TypeElement)this.innerElement).asType()).toString();
        return className.startsWith(Boolean.class.getName()) || className.startsWith("boolean");
    }

    public boolean isInteger() {
        String className = ((Object)((TypeElement)this.innerElement).asType()).toString();
        return className.startsWith(Integer.class.getName()) || className.startsWith("int");
    }

    public boolean isLong() {
        String className = ((Object)((TypeElement)this.innerElement).asType()).toString();
        return className.startsWith(Long.class.getName()) || className.startsWith("long");
    }

    public boolean isFloat() {
        String className = ((Object)((TypeElement)this.innerElement).asType()).toString();
        return className.startsWith(Float.class.getName()) || className.startsWith("float");
    }

    public boolean isDouble() {
        String className = ((Object)((TypeElement)this.innerElement).asType()).toString();
        return className.startsWith(Double.class.getName()) || className.startsWith("double");
    }

    public boolean isChar() {
        String className = ((Object)((TypeElement)this.innerElement).asType()).toString();
        return className.startsWith(Character.class.getName()) || className.startsWith("char");
    }

    public boolean isHttpCallback() {
        return ((Object)((TypeElement)this.innerElement).asType()).toString().startsWith(HttpCallback.class.getName());
    }

    public boolean isURL() {
        return ((Object)((TypeElement)this.innerElement).asType()).toString().startsWith(URL.class.getName());
    }

    public boolean isDate() {
        return ((Object)((TypeElement)this.innerElement).asType()).toString().startsWith(Date.class.getName());
    }

    public boolean isBigDecimal() {
        return ((Object)((TypeElement)this.innerElement).asType()).toString().startsWith(BigDecimal.class.getName());
    }

    public boolean isBigInteger() {
        return ((Object)((TypeElement)this.innerElement).asType()).toString().startsWith(BigInteger.class.getName());
    }

    public boolean isComplexType() {
        return this.isComplexTypeWithGetterAndSetter(true);
    }

    public boolean isComplexTypeWithGetterAndSetter(boolean checkGetterAndSetter) {
        if (!(((TypeElement)this.innerElement).asType().getKind() != TypeKind.DECLARED || this.isNestedProcessor() || this.isCollection() || this.isStatic() || this.isEnum() || this.isHttpCallback() || this.isReservedIdentifier() || ((Object)((TypeElement)this.innerElement).asType()).toString().startsWith("java") || ((Object)((TypeElement)this.innerElement).asType()).toString().startsWith("sun") || SchemaTypeConversion.isSupported((String)((Object)this.asTypeMirror()).toString()) || !this.hasNoArgConstructor())) {
            if (checkGetterAndSetter) {
                boolean found = false;
                for (Field field : this.asType().getFields()) {
                    if (!field.hasSetter()) continue;
                    found = true;
                }
                return found;
            }
            return true;
        }
        return false;
    }

    public boolean isCalendar() {
        return ((Object)((TypeElement)this.innerElement).asType()).toString().startsWith(Calendar.class.getName());
    }

    public boolean inheritsFrom(Type type) {
        return this.inheritsFrom(this.asTypeMirror(), type);
    }

    private boolean inheritsFrom(TypeMirror type, Type otherType) {
        if (((Object)type).toString().startsWith(otherType.getPackage().getName() + "." + otherType.getName())) {
            return true;
        }
        List<? extends TypeMirror> inherits = this.types.directSupertypes(type);
        for (TypeMirror typeMirror : inherits) {
            if (!this.inheritsFrom(typeMirror, otherType)) continue;
            return true;
        }
        return false;
    }

    public boolean inheritsFrom(Class clazz) {
        return this.inheritsFrom(this.asTypeMirror(), clazz);
    }

    private boolean inheritsFrom(TypeMirror type, Class clazz) {
        if (((Object)type).toString().startsWith(clazz.getName())) {
            return true;
        }
        List<? extends TypeMirror> inherits = this.types.directSupertypes(type);
        for (TypeMirror typeMirror : inherits) {
            if (!this.inheritsFrom(typeMirror, clazz)) continue;
            return true;
        }
        return false;
    }

    public void accept(ModelVisitor visitor) {
        block6: {
            block7: {
                if (visitor.hasVisited((Identifiable)this)) break block6;
                visitor.visit((Type)this);
                if (!this.isCollection()) break block7;
                for (Type type : this.getTypeArguments()) {
                    type.accept(visitor);
                }
                break block6;
            }
            if (this.isJavaType()) break block6;
            for (Type type : this.getTypeArguments()) {
                type.accept(visitor);
            }
            for (Field field : this.getFields()) {
                field.accept(visitor);
            }
            for (Field field : this.getInheritedFields()) {
                field.accept(visitor);
            }
            if (!this.isComplexType()) {
                for (Method method : this.getMethods()) {
                    method.accept(visitor);
                }
            }
        }
    }

    private boolean isJavaType() {
        return ((Object)((TypeElement)this.innerElement).asType()).toString().startsWith("java") || ((Object)((TypeElement)this.innerElement).asType()).toString().startsWith("sun");
    }
}

