/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import org.mule.devkit.apt.AbstractAnnotationProcessor;
import org.mule.devkit.generation.api.Generator;
import org.mule.devkit.generation.api.Plugin;
import org.mule.devkit.generation.api.PluginScanner;
import org.mule.devkit.generation.api.PostProcessor;
import org.mule.devkit.generation.api.Verifier;

@SupportedAnnotationTypes(value={"org.mule.api.annotations.Connector", "org.mule.api.annotations.ExpressionLanguage", "org.mule.api.annotations.Module"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"enabledStudioPluginPackage", "enableJavaDocValidation", "mavenInformationFile"})
public class AnnotationProcessor
extends AbstractAnnotationProcessor {
    private Map<Verifier, Plugin> generatorPluginMap = new HashMap<Verifier, Plugin>();

    @Override
    protected Plugin getPluginFromVerifier(Verifier verifier) {
        return this.generatorPluginMap.get(verifier);
    }

    @Override
    public List<? extends Verifier> getAnnotationVerifiers() {
        ArrayList verifiers = new ArrayList();
        try {
            List plugins = PluginScanner.getInstance().getAllPlugins((ClassLoader)this.getUserClassLoader(this.getClass().getClassLoader()));
            for (Plugin p : plugins) {
                if (this.shouldBeIncluded(p)) {
                    verifiers.addAll(p.getVerifiers());
                    for (Verifier verifier : p.getVerifiers()) {
                        this.generatorPluginMap.put(verifier, p);
                    }
                    continue;
                }
                if (p.getOptionName() == null) continue;
                this.context.warn("The following annotation verifiers are being SKIPPED because the option \"" + p.getOptionName() + "\" is not specified:");
                for (Verifier verifier : p.getVerifiers()) {
                    this.context.warn("    " + verifier.getClass().getName());
                }
            }
        }
        catch (MalformedURLException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getLocalizedMessage());
        }
        return verifiers;
    }

    private boolean shouldBeIncluded(Plugin p) {
        return p.getOptionName() == null || this.processingEnv.getOptions().get(p.getOptionName()) != null && this.processingEnv.getOptions().get(p.getOptionName()).equals("true");
    }

    @Override
    public List<Generator> getGenerators() {
        ArrayList<Generator> moduleGenerators = new ArrayList<Generator>();
        try {
            List plugins = PluginScanner.getInstance().getAllPlugins((ClassLoader)this.getUserClassLoader(this.getClass().getClassLoader()));
            for (Plugin p : plugins) {
                if (this.shouldBeIncluded(p)) {
                    moduleGenerators.addAll(p.getGenerators());
                    continue;
                }
                if (p.getOptionName() == null) continue;
                this.context.warn("The following generators are being SKIPPED because the option \"" + p.getOptionName() + "\" is not specified:");
                for (Generator moduleGenerator : p.getGenerators()) {
                    this.context.warn("    " + moduleGenerator.getClass().getName());
                }
            }
        }
        catch (MalformedURLException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getLocalizedMessage());
        }
        return moduleGenerators;
    }

    @Override
    public List<PostProcessor> getPostProcessors() {
        ArrayList<PostProcessor> modulePostProcessors = new ArrayList<PostProcessor>();
        try {
            List plugins = PluginScanner.getInstance().getAllPlugins((ClassLoader)this.getUserClassLoader(this.getClass().getClassLoader()));
            for (Plugin p : plugins) {
                if (this.shouldBeIncluded(p)) {
                    modulePostProcessors.addAll(p.getPostProcessors());
                    continue;
                }
                if (p.getOptionName() == null) continue;
                this.context.warn("The following post processors are being SKIPPED because the option \"" + p.getOptionName() + "\" is not specified:");
                for (PostProcessor postProcessor : p.getPostProcessors()) {
                    this.context.warn("    " + postProcessor.getClass().getName());
                }
            }
        }
        catch (MalformedURLException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getLocalizedMessage());
        }
        return modulePostProcessors;
    }

    public URLClassLoader getUserClassLoader(ClassLoader parent) throws MalformedURLException {
        ArrayList<URL> classpaths = new ArrayList<URL>();
        for (Map.Entry<String, String> me : this.processingEnv.getOptions().entrySet()) {
            String key = me.getKey();
            if (!key.equals("-classpath") && !key.equals("-cp")) continue;
            for (String p : me.getValue().split(File.pathSeparator)) {
                File file = new File(p);
                classpaths.add(file.toURL());
            }
        }
        return new URLClassLoader(classpaths.toArray(new URL[classpaths.size()]), parent);
    }
}

