/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model;

import com.sun.source.util.Trees;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.ExpressionLanguage;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.devkit.apt.model.AnnotationProcessorEnumType;
import org.mule.devkit.apt.model.AnnotationProcessorType;
import org.mule.devkit.apt.model.module.connectivity.AnnotationProcessorManagedConnectionModule;
import org.mule.devkit.apt.model.module.oauth.AnnotationProcessorOAuthModule;
import org.mule.devkit.apt.model.module.rest.AnnotationProcessorRestModule;
import org.mule.devkit.model.Type;

public class AnnotationProcessorTypeFactory {
    public static <T extends Type> T createType(TypeElement innerElement, Types types, Elements elements, Trees trees) {
        if (AnnotationProcessorTypeFactory.usesConnectionManager(innerElement)) {
            return (T)new AnnotationProcessorManagedConnectionModule(innerElement, types, elements, trees);
        }
        if (AnnotationProcessorTypeFactory.usesOAuth(innerElement)) {
            return (T)new AnnotationProcessorOAuthModule(innerElement, types, elements, trees);
        }
        if (AnnotationProcessorTypeFactory.isModuleOrConnector(innerElement)) {
            return (T)new AnnotationProcessorRestModule(innerElement, types, elements, trees);
        }
        if (AnnotationProcessorTypeFactory.isEnum(innerElement)) {
            return (T)new AnnotationProcessorEnumType(innerElement, types, elements, trees);
        }
        return (T)new AnnotationProcessorType(innerElement, types, elements, trees);
    }

    public static boolean isEnum(TypeElement innerElement) {
        return innerElement.getKind() == ElementKind.ENUM;
    }

    private static boolean isModuleOrConnector(TypeElement innerElement) {
        return innerElement.getAnnotation(Connector.class) != null || innerElement.getAnnotation(Module.class) != null || innerElement.getAnnotation(ExpressionLanguage.class) != null;
    }

    private static boolean usesConnectionManager(TypeElement innerElement) {
        if (innerElement.getAnnotation(Connector.class) == null) {
            return false;
        }
        boolean hasConnect = false;
        boolean hasDisconnect = false;
        for (ExecutableElement executableElement : ElementFilter.methodsIn(innerElement.getEnclosedElements())) {
            if (executableElement.getAnnotation(Connect.class) != null) {
                hasConnect = true;
            }
            if (executableElement.getAnnotation(Disconnect.class) == null) continue;
            hasDisconnect = true;
        }
        return hasConnect && hasDisconnect;
    }

    private static boolean usesOAuth(TypeElement innerElement) {
        return innerElement.getAnnotation(OAuth.class) != null || innerElement.getAnnotation(OAuth2.class) != null;
    }
}

