/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model;

import com.sun.source.util.Trees;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.expressions.Expr;
import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.api.annotations.oauth.OAuthAccessTokenSecret;
import org.mule.api.annotations.param.CorrelationGroupSize;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.MessageRootId;
import org.mule.api.annotations.param.MessageUniqueId;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.apt.model.AnnotationProcessorVariable;
import org.mule.devkit.apt.model.GenericTypeFactory;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.visitor.ModelVisitor;

public class AnnotationProcessorParameter<P extends Method>
extends AnnotationProcessorVariable<P>
implements Parameter<P> {
    private static final List<Class<SourceCallback>> PARAMETER_TYPES_TO_IGNORE = Arrays.asList(SourceCallback.class);
    private static final List<Class<? extends Serializable>> PARAMETER_TYPES_TO_INJECT = Arrays.asList(MuleEvent.class, MuleMessage.class);
    private static final List<Class<? extends Annotation>> PARAMETERS_ANNOTATIONS_TO_IGNORE = Arrays.asList(InboundHeaders.class, InvocationHeaders.class, OutboundHeaders.class, SessionHeaders.class, Payload.class, OAuthAccessToken.class, OAuthAccessTokenSecret.class, ExceptionPayload.class, CorrelationId.class, CorrelationSequence.class, CorrelationGroupSize.class, MessageUniqueId.class, MessageRootId.class, Expr.class);

    public AnnotationProcessorParameter(VariableElement element, P parent, Types types, Elements elements, Trees trees) {
        super(element, parent, types, elements, trees);
    }

    public boolean shouldBeIgnored() {
        String variableType = ((Object)((VariableElement)this.innerElement).asType()).toString();
        for (Class<SourceCallback> clazz : PARAMETER_TYPES_TO_IGNORE) {
            if (!variableType.contains(clazz.getName())) continue;
            return true;
        }
        for (Class<Object> clazz : PARAMETERS_ANNOTATIONS_TO_IGNORE) {
            if (((VariableElement)this.innerElement).getAnnotation(clazz) == null) continue;
            return true;
        }
        if (((Method)this.parent()).getAnnotation(Inject.class) != null) {
            for (Class<Object> clazz : PARAMETER_TYPES_TO_INJECT) {
                if (!variableType.contains(clazz.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public GenericType getGenericType() {
        return GenericTypeFactory.createGenericType(this.asTypeMirror(), this.types, this.innerElement, this.getName());
    }

    public void accept(ModelVisitor visitor) {
        if (!visitor.hasVisited((Identifiable)this)) {
            visitor.visit((Parameter)this);
            Type type = this.asType();
            if (type != null) {
                if (type.isComplexType() && !this.isRefOnly()) {
                    type.accept(visitor);
                    if (type.getSuperClass() != null && type.getSuperClass().isComplexType()) {
                        type.getSuperClass().accept(visitor);
                    }
                } else if (type.isEnum()) {
                    type.accept(visitor);
                } else if (type.isCollection()) {
                    for (Type collectionType : this.getTypeArguments()) {
                        collectionType.accept(visitor);
                    }
                }
            }
        }
    }
}

