/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model.module;

import com.sun.source.util.Trees;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.ExpressionLanguage;
import org.mule.api.annotations.Filter;
import org.mule.api.annotations.MetaDataKeyRetriever;
import org.mule.api.annotations.MetaDataRetriever;
import org.mule.api.annotations.MetaDataSwitch;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.Transformer;
import org.mule.api.annotations.TransformerResolver;
import org.mule.api.annotations.lifecycle.Start;
import org.mule.api.annotations.lifecycle.Stop;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.rest.RestHttpClient;
import org.mule.devkit.apt.model.AnnotationProcessorField;
import org.mule.devkit.apt.model.AnnotationProcessorType;
import org.mule.devkit.apt.model.AnnotationProcessorTypeFactory;
import org.mule.devkit.apt.model.module.AnnotationProcessorFilterMethod;
import org.mule.devkit.apt.model.module.AnnotationProcessorProcessorMethod;
import org.mule.devkit.apt.model.module.AnnotationProcessorSourceMethod;
import org.mule.devkit.apt.model.module.AnnotationProcessorTransformerMethod;
import org.mule.devkit.apt.model.module.AnnotationProcessorTransformerResolverMethod;
import org.mule.devkit.apt.model.module.rest.AnnotationProcessorRestCall;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.MuleVersion;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.FilterMethod;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.module.TransformerMethod;
import org.mule.devkit.model.module.TransformerResolverMethod;
import org.mule.devkit.model.module.UnknownLifecyclePhaseException;
import org.mule.devkit.model.module.UnknownModuleKindException;
import org.mule.devkit.model.module.rest.RestCall;
import org.mule.devkit.model.visitor.ModelVisitor;

public class AnnotationProcessorModule
extends AnnotationProcessorType
implements org.mule.devkit.model.module.Module {
    private static final String XSD_EXTENSION = ".xsd";

    public AnnotationProcessorModule(TypeElement innerElement, Types types, Elements elements, Trees trees) {
        super(innerElement, types, elements, trees);
    }

    public org.mule.devkit.model.module.Module parentModule() {
        TypeElement te = (TypeElement)this.types.asElement(((TypeElement)this.innerElement).getSuperclass());
        return new AnnotationProcessorModule(te, this.types, this.elements, this.trees);
    }

    public boolean needsConfig() {
        boolean needsConfig = false;
        for (Field variable : this.getConfigurableFields()) {
            if (variable.getAnnotation(Optional.class) != null) continue;
            needsConfig = true;
        }
        return needsConfig;
    }

    public boolean hasMethodWithName(String methodName) {
        for (ExecutableElement executableElement : ElementFilter.methodsIn(((TypeElement)this.innerElement).getEnclosedElements())) {
            if (!executableElement.getSimpleName().toString().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasProcessorMethodWithParameter(Class<?> parameterType) {
        for (ProcessorMethod method : this.getProcessorMethods()) {
            for (Parameter parameter : method.getParameters()) {
                if (!((Object)parameter.asTypeMirror()).toString().startsWith(parameterType.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasConfigurableWithType(Class<?> parameterType) {
        for (Field field : this.getConfigurableFields()) {
            if (!((Object)field.asTypeMirror()).toString().startsWith(parameterType.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return ((TypeElement)this.innerElement).getAnnotation(annotation) != null;
    }

    public boolean usesPooling() {
        return this.hasAnnotation(Module.class) && this.getAnnotation(Module.class).poolable();
    }

    public MuleVersion getMinMuleVersion() {
        if (this.hasAnnotation(Module.class)) {
            return new MuleVersion(this.getAnnotation(Module.class).minMuleVersion());
        }
        if (this.hasAnnotation(Connector.class)) {
            return new MuleVersion(this.getAnnotation(Connector.class).minMuleVersion());
        }
        if (this.hasAnnotation(ExpressionLanguage.class)) {
            return new MuleVersion(this.getAnnotation(ExpressionLanguage.class).minMuleVersion());
        }
        return null;
    }

    public String getXmlNamespace() {
        String targetNamespace = "";
        if (this.hasAnnotation(Module.class)) {
            targetNamespace = this.getAnnotation(Module.class).namespace();
        }
        if (this.hasAnnotation(Connector.class)) {
            targetNamespace = this.getAnnotation(Connector.class).namespace();
        }
        if (targetNamespace == null || targetNamespace.length() == 0) {
            targetNamespace = "http://www.mulesoft.org/schema/mule/" + this.getModuleName();
        }
        return targetNamespace;
    }

    public String getModuleName() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).name();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).name();
        }
        if (this.hasAnnotation(ExpressionLanguage.class)) {
            return this.getAnnotation(ExpressionLanguage.class).name();
        }
        return null;
    }

    public String getAnnotatedSchemaLocation() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).schemaLocation();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).schemaLocation();
        }
        return null;
    }

    public String getVersionedSchemaLocation() {
        String versionedLocation = this.getAnnotatedSchemaLocation();
        if (versionedLocation == null || versionedLocation.length() == 0) {
            versionedLocation = this.getXmlNamespace() + "/" + this.getModuleSchemaVersion() + "/mule-" + this.getModuleName() + XSD_EXTENSION;
        }
        return versionedLocation;
    }

    public String getCurrentSchemaLocation() {
        String versionedLocation = this.getAnnotatedSchemaLocation();
        if (versionedLocation == null || versionedLocation.length() == 0) {
            versionedLocation = this.getXmlNamespace() + "/current/mule-" + this.getModuleName() + XSD_EXTENSION;
        }
        return versionedLocation;
    }

    public String getModuleSchemaVersion() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).schemaVersion();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).schemaVersion();
        }
        return null;
    }

    public String getFriendlyName() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).friendlyName();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).friendlyName();
        }
        return null;
    }

    public String getDescription() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).description();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).description();
        }
        return null;
    }

    public List<SourceMethod> getSourceMethods() {
        ArrayList<SourceMethod> methods = new ArrayList<SourceMethod>();
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(current.getEnclosedElements())) {
                if (executableElement.getAnnotation(Source.class) == null) continue;
                if (current == this.innerElement) {
                    methods.add(new AnnotationProcessorSourceMethod(executableElement, this, this.types, this.elements, this.trees));
                    continue;
                }
                Object type = AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.trees);
                methods.add(new AnnotationProcessorSourceMethod(executableElement, (Type)type, this.types, this.elements, this.trees));
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return methods;
    }

    public List<ProcessorMethod> getProcessorMethods() {
        ArrayList<ProcessorMethod> methods = new ArrayList<ProcessorMethod>();
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(current.getEnclosedElements())) {
                if (executableElement.getAnnotation(Processor.class) == null) continue;
                if (current == this.innerElement) {
                    methods.add(new AnnotationProcessorProcessorMethod(executableElement, this, this.types, this.elements, this.trees));
                    continue;
                }
                Object type = AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.trees);
                methods.add(new AnnotationProcessorProcessorMethod(executableElement, (Type)type, this.types, this.elements, this.trees));
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return methods;
    }

    public Method getMetaDataKeyRetrieverMethod() {
        for (Method<Type> method : this.getMethods()) {
            if (method.getAnnotation(MetaDataKeyRetriever.class) == null) continue;
            return method;
        }
        return null;
    }

    public Method getMetaDataRetrieverMethod() {
        for (Method<Type> method : this.getMethods()) {
            if (method.getAnnotation(MetaDataRetriever.class) == null) continue;
            return method;
        }
        return null;
    }

    public boolean isConnector() {
        return this.hasAnnotation(Connector.class);
    }

    public boolean isModule() {
        return this.hasAnnotation(Module.class);
    }

    public boolean hasDynamicMetadata() {
        return this.isConnector() && MetaDataSwitch.DYNAMIC.equals((Object)this.getAnnotation(Connector.class).metaData()) || this.isModule() && MetaDataSwitch.DYNAMIC.equals((Object)this.getAnnotation(Module.class).metaData());
    }

    public List<FilterMethod> getFilterMethods() {
        ArrayList<FilterMethod> methods = new ArrayList<FilterMethod>();
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(current.getEnclosedElements())) {
                if (executableElement.getAnnotation(Filter.class) == null) continue;
                if (current == this.innerElement) {
                    methods.add(new AnnotationProcessorFilterMethod(executableElement, this, this.types, this.elements, this.trees));
                    continue;
                }
                Object type = AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.trees);
                methods.add(new AnnotationProcessorFilterMethod(executableElement, (Type)type, this.types, this.elements, this.trees));
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return methods;
    }

    public List<TransformerMethod> getTransformerMethods() {
        ArrayList<TransformerMethod> methods = new ArrayList<TransformerMethod>();
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(current.getEnclosedElements())) {
                if (executableElement.getAnnotation(Transformer.class) == null) continue;
                if (current == this.innerElement) {
                    methods.add(new AnnotationProcessorTransformerMethod(executableElement, this, this.types, this.elements, this.trees));
                    continue;
                }
                Object type = AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.trees);
                methods.add(new AnnotationProcessorTransformerMethod(executableElement, (Type)type, this.types, this.elements, this.trees));
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return methods;
    }

    public List<TransformerResolverMethod> getTransformerResolverMethods() {
        ArrayList<TransformerResolverMethod> methods = new ArrayList<TransformerResolverMethod>();
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(current.getEnclosedElements())) {
                if (executableElement.getAnnotation(TransformerResolver.class) == null) continue;
                if (current == this.innerElement) {
                    methods.add(new AnnotationProcessorTransformerResolverMethod(executableElement, this, this.types, this.elements, this.trees));
                    continue;
                }
                Object type = AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.trees);
                methods.add(new AnnotationProcessorTransformerResolverMethod(executableElement, (Type)type, this.types, this.elements, this.trees));
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return methods;
    }

    public List<Field> getConfigurableFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(current.getEnclosedElements())) {
                if (variableElement.getAnnotation(Configurable.class) == null) continue;
                if (current == this.innerElement) {
                    fields.add(new AnnotationProcessorField<AnnotationProcessorModule>(variableElement, this, this.types, this.elements, this.trees));
                    continue;
                }
                Object type = AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.trees);
                fields.add(new AnnotationProcessorField(variableElement, type, this.types, this.elements, this.trees));
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return fields;
    }

    public List<Field> getInjectFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(current.getEnclosedElements())) {
                if (variableElement.getAnnotation(Inject.class) == null) continue;
                if (current == this.innerElement) {
                    fields.add(new AnnotationProcessorField<AnnotationProcessorModule>(variableElement, this, this.types, this.elements, this.trees));
                    continue;
                }
                Object type = AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.trees);
                fields.add(new AnnotationProcessorField(variableElement, type, this.types, this.elements, this.trees));
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return fields;
    }

    public ModuleKind getKind() {
        if (this.getAnnotation(Connector.class) != null) {
            return ModuleKind.CONNECTOR;
        }
        if (this.getAnnotation(Module.class) != null) {
            return ModuleKind.GENERIC;
        }
        if (this.getAnnotation(ExpressionLanguage.class) != null) {
            return ModuleKind.EXPRESSION_LANGUAGE;
        }
        throw new UnknownModuleKindException();
    }

    public boolean hasSources() {
        return this.getSourceMethods().size() > 0;
    }

    public boolean hasProcessors() {
        return this.getProcessorMethods().size() > 0;
    }

    public boolean hasFilters() {
        return this.getFilterMethods().size() > 0;
    }

    public boolean hasTransformers() {
        return this.getTransformerMethods().size() > 0;
    }

    public Method getLifecycleMethod(String phaseName) {
        if (phaseName.equals("start")) {
            for (Method<Type> method : this.getMethods()) {
                if (method.getAnnotation(Start.class) == null) continue;
                return method;
            }
            return null;
        }
        if (phaseName.equals("stop")) {
            for (Method<Type> method : this.getMethods()) {
                if (method.getAnnotation(Stop.class) == null) continue;
                return method;
            }
            return null;
        }
        if (phaseName.equals("initialise")) {
            for (Method<Type> method : this.getMethods()) {
                if (method.getAnnotation(PostConstruct.class) == null) continue;
                return method;
            }
            return null;
        }
        if (phaseName.equals("dispose")) {
            for (Method<Type> method : this.getMethods()) {
                if (method.getAnnotation(PreDestroy.class) == null) continue;
                return method;
            }
            return null;
        }
        throw new UnknownLifecyclePhaseException();
    }

    public String getConfigElementName() {
        if (((TypeElement)this.innerElement).getAnnotation(Module.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(Module.class).configElementName();
        }
        if (((TypeElement)this.innerElement).getAnnotation(Connector.class) != null) {
            return ((TypeElement)this.innerElement).getAnnotation(Connector.class).configElementName();
        }
        return null;
    }

    public Field getRestHttpClientField() {
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(current.getEnclosedElements())) {
                if (variableElement.getAnnotation(RestHttpClient.class) == null) continue;
                if (current == this.innerElement) {
                    return new AnnotationProcessorField<AnnotationProcessorModule>(variableElement, this, this.types, this.elements, this.trees);
                }
                Object type = AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.trees);
                return new AnnotationProcessorField(variableElement, type, this.types, this.elements, this.trees);
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return null;
    }

    public List<RestCall> getRestCalls() {
        ArrayList<RestCall> methods = new ArrayList<RestCall>();
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(current.getEnclosedElements())) {
                if (executableElement.getAnnotation(org.mule.api.annotations.rest.RestCall.class) == null) continue;
                if (current == this.innerElement) {
                    methods.add(new AnnotationProcessorRestCall(executableElement, this, this.types, this.elements, this.trees));
                    continue;
                }
                org.mule.devkit.model.module.Module module = (org.mule.devkit.model.module.Module)AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.trees);
                methods.add(new AnnotationProcessorRestCall(executableElement, module, this.types, this.elements, this.trees));
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return methods;
    }

    public boolean hasRestCalls() {
        return this.getRestCalls().size() > 0;
    }

    public boolean hasTransformerResolver() {
        return this.getTransformerResolverMethods().size() > 0;
    }

    @Override
    public void accept(ModelVisitor visitor) {
        if (!visitor.hasVisited((Identifiable)this)) {
            visitor.visit((org.mule.devkit.model.module.Module)this);
            for (Field field : this.getConfigurableFields()) {
                field.accept(visitor);
            }
            for (ProcessorMethod processorMethod : this.getProcessorMethods()) {
                processorMethod.accept(visitor);
            }
            for (FilterMethod filterMethod : this.getFilterMethods()) {
                filterMethod.accept(visitor);
            }
            for (SourceMethod sourceMethod : this.getSourceMethods()) {
                sourceMethod.accept(visitor);
            }
            for (TransformerMethod transformerMethod : this.getTransformerMethods()) {
                transformerMethod.accept(visitor);
            }
        }
    }
}

