/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model;

import com.sun.source.util.Trees;
import javax.inject.Named;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.mule.api.annotations.display.Text;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Email;
import org.mule.api.annotations.param.MetaDataKeyParam;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.param.RefOnly;
import org.mule.devkit.apt.model.AnnotationProcessorIdentifiable;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Variable;

public abstract class AnnotationProcessorVariable<P extends Identifiable>
extends AnnotationProcessorIdentifiable<VariableElement>
implements Variable<P> {
    protected P parent;
    private int DEFAULT_STRING_MIN_SIZE = 0;
    private int DEFAULT_STRING_MAX_SIZE = Integer.MAX_VALUE;

    public AnnotationProcessorVariable(VariableElement variableElement, P parent, Types types, Elements elements, Trees trees) {
        super(variableElement, types, elements, trees);
        this.parent = parent;
    }

    public String getJavaType() {
        return ((Object)((VariableElement)this.innerElement).asType()).toString();
    }

    public boolean hasSizeLimit() {
        return this.getAnnotation(Size.class) != null;
    }

    public int getMinSizeLimit() {
        if (this.hasSizeLimit()) {
            return this.getAnnotation(Size.class).min();
        }
        return this.DEFAULT_STRING_MIN_SIZE;
    }

    public int getMaxSizeLimit() {
        if (this.hasSizeLimit()) {
            return this.getAnnotation(Size.class).max();
        }
        return this.DEFAULT_STRING_MAX_SIZE;
    }

    public boolean hasPattern() {
        return this.getAnnotation(Pattern.class) != null;
    }

    public String getPattern() {
        if (this.hasEmailPattern()) {
            String pattern = this.hasDefaultEmailDomain() ? "[^@]+@[^\\.]+\\..+" : "[^@]+@" + this.getEmailDomain();
            return pattern;
        }
        return this.getAnnotation(Pattern.class).regexp();
    }

    public boolean hasEmailPattern() {
        return this.getAnnotation(Email.class) != null;
    }

    public String getEmailDomain() {
        return this.getAnnotation(Email.class).domain();
    }

    public boolean hasDefaultEmailDomain() {
        return "".equals(this.getAnnotation(Email.class).domain());
    }

    public boolean isOptional() {
        return this.getAnnotation(Optional.class) != null;
    }

    public boolean hasDefaultValue() {
        return this.getAnnotation(Default.class) != null;
    }

    public boolean isText() {
        return this.getAnnotation(Text.class) != null;
    }

    public String getDefaultValue() {
        if (this.getAnnotation(Default.class) != null) {
            return this.getAnnotation(Default.class).value();
        }
        return null;
    }

    public P parent() {
        return this.parent;
    }

    public String getAlternativeName() {
        Named named = ((VariableElement)this.innerElement).getAnnotation(Named.class);
        String name = this.getName();
        if (named != null && named.value().length() > 0) {
            name = named.value();
        }
        return name;
    }

    public boolean isRefOnly() {
        return ((VariableElement)this.innerElement).getAnnotation(RefOnly.class) != null;
    }

    public boolean isMetaDataKey() {
        return this.getAnnotation(MetaDataKeyParam.class) != null;
    }
}

