/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mule.devkit.apt.AnnotationProcessorManifest;
import org.mule.devkit.apt.AnnotationProcessorMavenInformation;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.Manifest;
import org.mule.devkit.generation.api.MavenInformation;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.SerializationUtils;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.writer.FilerCodeWriter;
import org.mule.devkit.model.schema.SchemaModel;
import org.mule.devkit.model.studio.StudioModel;

public class AnnotationProcessorContext
implements Context {
    private Messager messager;
    private CodeModel codeModel;
    private SchemaModel schemaModel;
    private StudioModel studioModel;
    private Types types;
    private AnnotationProcessorManifest manifest;
    private Set<TypeMirror> registeredJaxbElements;
    private Map<Tuple<Product, Identifiable, String>, Object> classesByRole = new HashMap<Tuple<Product, Identifiable, String>, Object>();
    private MavenInformation mavenInformation;
    public static final String MAVEN_INFORMATION_FILE = "mavenInformationFile";

    public AnnotationProcessorContext(ProcessingEnvironment env) {
        this.codeModel = new CodeModel((CodeWriter)new FilerCodeWriter(env.getFiler()));
        this.schemaModel = new SchemaModel((CodeWriter)new FilerCodeWriter(env.getFiler()));
        this.types = env.getTypeUtils();
        this.studioModel = new StudioModel((CodeWriter)new FilerCodeWriter(env.getFiler()));
        this.registeredJaxbElements = new HashSet<TypeMirror>();
        this.manifest = new AnnotationProcessorManifest(this);
        this.messager = env.getMessager();
        File mavenInformationFile = new File(env.getOptions().get(MAVEN_INFORMATION_FILE));
        Map mavenInformationMap = (Map)SerializationUtils.load((File)mavenInformationFile);
        this.mavenInformation = AnnotationProcessorMavenInformation.createFromMavenInformationMap(mavenInformationMap);
    }

    public CodeModel getCodeModel() {
        return this.codeModel;
    }

    public SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    public StudioModel getStudioModel() {
        return this.studioModel;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void note(String msg) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, msg);
    }

    public void warn(String msg) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, msg);
    }

    public void error(String msg) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg);
    }

    public void error(String msg, Identifiable element) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, element.unwrap());
    }

    public void debug(String msg) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, "DEBUG: " + msg);
    }

    public <T> T getProduct(Product product) {
        return (T)this.classesByRole.get(new Tuple<Product, Object, Object>(product, null, null));
    }

    public <T> T getProduct(Product product, Identifiable identifiable) {
        return (T)this.classesByRole.get(new Tuple<Product, Identifiable, Object>(product, identifiable, null));
    }

    public <T> T getProduct(Product product, Identifiable identifiable, String methodName) {
        return (T)this.classesByRole.get(new Tuple<Product, Identifiable, String>(product, identifiable, methodName));
    }

    public <T> void registerProduct(Product product, T clazz) {
        this.classesByRole.put(new Tuple<Product, Object, Object>(product, null, null), clazz);
    }

    public <T> void registerProduct(Product product, Identifiable identifiable, T clazz) {
        this.classesByRole.put(new Tuple<Product, Identifiable, Object>(product, identifiable, null), clazz);
    }

    public <T> void registerProduct(Product product, Identifiable identifiable, String methodName, T clazz) {
        this.classesByRole.put(new Tuple<Product, Identifiable, String>(product, identifiable, methodName), clazz);
    }

    public <T> List<T> getProductList(Product product) {
        ArrayList<Object> generatedClasses = new ArrayList<Object>();
        for (Tuple<Product, Identifiable, String> tuple : this.classesByRole.keySet()) {
            if (!((Product)((Tuple)tuple).first).equals((Object)product)) continue;
            generatedClasses.add(this.classesByRole.get(tuple));
        }
        return generatedClasses;
    }

    public <T> List<T> getModulesByProduct(Product product) {
        ArrayList<Object> modules = new ArrayList<Object>();
        for (Tuple<Product, Identifiable, String> tuple : this.classesByRole.keySet()) {
            if (!((Product)((Tuple)tuple).first).equals((Object)product)) continue;
            modules.add(((Tuple)tuple).second);
        }
        return modules;
    }

    public MavenInformation getMavenInformation() {
        return this.mavenInformation;
    }

    private class Tuple<T, U, X> {
        private final T first;
        private final U second;
        private final X third;
        private final transient int hash;

        public Tuple(T f, U s, X x) {
            this.first = f;
            this.second = s;
            this.third = x;
            this.hash = (this.first == null ? 0 : this.first.hashCode() * 31) + (this.second == null ? 0 : this.second.hashCode() * 17) + (this.third == null ? 0 : this.third.hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object oth) {
            if (this == oth) {
                return true;
            }
            if (oth == null || !this.getClass().isInstance(oth)) {
                return false;
            }
            Tuple other = (Tuple)this.getClass().cast(oth);
            return (this.first == null ? other.first == null : this.first.equals(other.first)) && (this.second == null ? other.second == null : this.second.equals(other.second)) && (this.third == null ? other.third == null : this.third.equals(other.third));
        }
    }
}

