/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import org.mule.devkit.model.GenericType;

public class GenericTypeImpl
implements GenericType {
    private List<GenericType> genericTypeArguments;
    private Element typeElement;
    private PrimitiveType primitiveType;
    private List<String> COLLECTION_NAMES = Arrays.asList("Collection", "List", "Set", "Queue", "Deque");

    public GenericTypeImpl(Element element) {
        this.genericTypeArguments = new ArrayList<GenericType>();
        this.typeElement = element;
    }

    public GenericTypeImpl(PrimitiveType primitiveType) {
        this.genericTypeArguments = new ArrayList<GenericType>();
        this.primitiveType = primitiveType;
    }

    public TypeMirror getType() {
        if (this.primitiveType != null) {
            return this.primitiveType;
        }
        return this.typeElement.asType();
    }

    public Element getElement() {
        return this.typeElement;
    }

    public List<GenericType> getGenericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean hasMetaData() {
        if (this.getType() instanceof DeclaredType) {
            DeclaredType type = (DeclaredType)this.getType();
            if (this.isMetaData()) {
                return true;
            }
        } else if (this.getType() instanceof PrimitiveType) {
            return false;
        }
        for (GenericType genericType : this.getGenericTypeArguments()) {
            if (!genericType.hasMetaData()) continue;
            return true;
        }
        return false;
    }

    public boolean isList() {
        return this.typeElement != null && this.typeElement.getSimpleName() != null && "List".equals(this.typeElement.getSimpleName().toString());
    }

    public boolean isMap() {
        return this.typeElement != null && this.typeElement.getSimpleName() != null && "Map".equals(this.typeElement.getSimpleName().toString());
    }

    public boolean isMetaData() {
        return this.typeElement != null && this.typeElement.getSimpleName() != null && "Map".equals(this.typeElement.getSimpleName().toString()) && "String".equals(this.getGenericTypeArguments().get(0).getElement().getSimpleName().toString()) && "Object".equals(this.getGenericTypeArguments().get(1).getElement().getSimpleName().toString());
    }

    public boolean isCollection() {
        return this.typeElement != null && this.typeElement.getSimpleName() != null && this.COLLECTION_NAMES.contains(this.typeElement.getSimpleName().toString());
    }

    public boolean is(String typeName) {
        if (typeName != null) {
            return typeName.equals(this.typeElement.getSimpleName().toString());
        }
        return false;
    }

    public String toString() {
        if (this.primitiveType != null) {
            return this.primitiveType.toString();
        }
        if (this.typeElement != null) {
            return this.typeElement.getSimpleName().toString();
        }
        return super.toString();
    }
}

