/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.devkit.apt.dependency.SimpleDependency;
import org.mule.devkit.generation.api.Dependency;
import org.mule.devkit.generation.api.License;
import org.mule.devkit.generation.api.MavenInformation;
import org.mule.devkit.generation.utils.SerializationUtils;

public class AnnotationProcessorMavenInformation
implements MavenInformation {
    private String artifactId;
    private String groupId;
    private String version;
    private License license;
    private String outputDirectory;
    private String name;
    private String category;
    private Set<Dependency> dependencies;

    public static AnnotationProcessorMavenInformation createFromMavenInformationMap(Map<String, ? extends Serializable> mavenInformationMap) {
        String groupId = (String)((Object)mavenInformationMap.get("mavenGroupId"));
        String artifactId = (String)((Object)mavenInformationMap.get("mavenArtifactId"));
        String version = (String)((Object)mavenInformationMap.get("mavenVersion"));
        String outputDirectory = (String)((Object)mavenInformationMap.get("mavenOutputDirectory"));
        String licenseFile = (String)((Object)mavenInformationMap.get("mavenLicense"));
        String name = (String)((Object)mavenInformationMap.get("mavenName"));
        String category = (String)((Object)mavenInformationMap.get("mavenCategory"));
        List stringDependencies = (List)((Object)mavenInformationMap.get("mavenDependencies"));
        return new AnnotationProcessorMavenInformation(artifactId, groupId, version, name, outputDirectory, licenseFile, category, SimpleDependency.createDependencies(stringDependencies));
    }

    private AnnotationProcessorMavenInformation(String artifactId, String groupId, String version, String name, String outputDirectory, String licenseFilePath, String category, Set<Dependency> dependencies) {
        this.artifactId = artifactId;
        this.groupId = groupId;
        this.version = version;
        this.name = name;
        this.outputDirectory = outputDirectory;
        this.category = "null".equals(category) ? null : category;
        File licenseFile = new File(licenseFilePath);
        this.license = (License)SerializationUtils.load((File)licenseFile);
        this.dependencies = dependencies;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public License getLicense() {
        return this.license;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }
}

