/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.devkit.apt.AnnotationProcessorContext;
import org.mule.devkit.apt.dependency.DependencyValidator;
import org.mule.devkit.apt.model.AnnotationProcessorTypeFactory;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Generator;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.MultiModuleAnnotationVerifier;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Plugin;
import org.mule.devkit.generation.api.PostProcessor;
import org.mule.devkit.generation.api.PostProcessorException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.Verifier;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.module.Module;

public abstract class AbstractAnnotationProcessor
extends AbstractProcessor {
    protected Context context;
    private Set<Class> alreadyExecutedGenerators = new HashSet<Class>();
    private DependencyValidator dependencyValidator = new DependencyValidator();

    public abstract List<? extends Verifier> getAnnotationVerifiers();

    public abstract List<Generator> getGenerators();

    public abstract List<PostProcessor> getPostProcessors();

    protected abstract Plugin getPluginFromVerifier(Verifier var1);

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        if (!this.typeExists(annotations, env)) {
            return true;
        }
        this.createContext();
        List<? extends Verifier> annotationVerifiers = this.getAnnotationVerifiers();
        List<Generator> moduleGenerators = this.getGenerators();
        List<PostProcessor> postProcessors = this.getPostProcessors();
        this.context.note("Sorting generator executing based on their dependencies...");
        List<Generator> sortedModuleGenerators = this.topologicalSort(moduleGenerators);
        this.printGenerationOrder(sortedModuleGenerators);
        try {
            if (this.shouldSkipCodeGeneration()) {
                this.context.warn("Devkit Code Generation is being SKIPPED");
            } else {
                this.scanAnnotationsAndGenerate(annotations, env, annotationVerifiers, sortedModuleGenerators);
            }
            this.syncCodeModel();
            this.syncSchema();
            this.syncStudioModel();
            for (PostProcessor postProcessor : postProcessors) {
                postProcessor.postProcess(this.context);
            }
        }
        catch (AnnotationVerificationException ave) {
            this.context.error(ave.getMessage(), ave.getElement());
            return false;
        }
        catch (GenerationException ge) {
            this.context.error(ge.getMessage());
            return false;
        }
        catch (IOException e) {
            this.context.error(e.getMessage());
            return false;
        }
        catch (PostProcessorException e) {
            this.context.error(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean shouldSkipCodeGeneration() {
        return "true".equals(System.getProperty("devkit.generation.skip"));
    }

    private void syncStudioModel() throws IOException {
        this.context.getStudioModel().build();
    }

    private void syncSchema() throws IOException {
        this.context.getSchemaModel().build();
    }

    private void syncCodeModel() throws IOException {
        this.context.getCodeModel().build();
    }

    private boolean typeExists(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        int size = 0;
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = env.getElementsAnnotatedWith(typeElement);
            Set<TypeElement> typeElements = ElementFilter.typesIn(elements);
            size += typeElements.size();
        }
        return size > 0;
    }

    private void scanAnnotationsAndGenerate(Set<? extends TypeElement> annotations, RoundEnvironment env, List<? extends Verifier> annotationVerifiers, List<Generator> sortedGenerators) throws AnnotationVerificationException, GenerationException {
        List<Module> modules = this.getModules(annotations, env);
        for (TypeElement typeElement : annotations) {
            this.context.note("Searching for classes annotated with @" + typeElement.getSimpleName().toString());
            Set<? extends Element> elements = env.getElementsAnnotatedWith(typeElement);
            Set<TypeElement> typeElements = ElementFilter.typesIn(elements);
            for (TypeElement e : typeElements) {
                Module module = (Module)AnnotationProcessorTypeFactory.createType(e, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils(), Trees.instance(this.processingEnv));
                this.verifyModule(module, annotationVerifiers);
            }
            this.verifyModules(modules, annotationVerifiers);
        }
        for (Generator generator : sortedGenerators) {
            boolean shouldExecute;
            MultiModuleGenerator multiModuleGenerator;
            generator.setCtx(this.context);
            if (generator instanceof ModuleGenerator) {
                ModuleGenerator moduleGenerator = (ModuleGenerator)generator;
                for (TypeElement typeElement : annotations) {
                    Set<? extends Element> elements = env.getElementsAnnotatedWith(typeElement);
                    Set<TypeElement> typeElements = ElementFilter.typesIn(elements);
                    for (TypeElement e : typeElements) {
                        boolean shouldExecute2;
                        Module module = (Module)AnnotationProcessorTypeFactory.createType(e, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils(), Trees.instance(this.processingEnv));
                        if (!moduleGenerator.shouldGenerate(module) || !(shouldExecute2 = this.shouldGeneratorBeExecuted((Generator)moduleGenerator))) continue;
                        moduleGenerator.generate(module);
                    }
                }
                continue;
            }
            if (!(generator instanceof MultiModuleGenerator) || !(multiModuleGenerator = (MultiModuleGenerator)generator).shouldGenerate(modules) || !(shouldExecute = this.shouldGeneratorBeExecuted((Generator)multiModuleGenerator))) continue;
            multiModuleGenerator.generate(modules);
        }
    }

    private List<Module> getModules(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = env.getElementsAnnotatedWith(typeElement);
            Set<TypeElement> typeElements = ElementFilter.typesIn(elements);
            for (TypeElement e : typeElements) {
                Object type = AnnotationProcessorTypeFactory.createType(e, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils(), Trees.instance(this.processingEnv));
                if (!(type instanceof Module)) continue;
                modules.add((Module)type);
            }
        }
        return modules;
    }

    private boolean shouldGeneratorBeExecuted(Generator generator) {
        boolean shouldExecute = true;
        if (generator.getClass().getAnnotation(JustOnce.class) != null) {
            if (this.alreadyExecutedGenerators.contains(generator.getClass())) {
                shouldExecute = false;
            } else {
                this.alreadyExecutedGenerators.add(generator.getClass());
                shouldExecute = true;
            }
        }
        return shouldExecute;
    }

    private void verifyModule(Module module, List<? extends Verifier> annotationVerifiers) throws AnnotationVerificationException {
        this.context.note("Validating " + module.getName() + " class");
        for (Verifier verifier : annotationVerifiers) {
            ModuleAnnotationVerifier moduleAnnotationVerifier;
            if (!(verifier instanceof ModuleAnnotationVerifier) || !(moduleAnnotationVerifier = (ModuleAnnotationVerifier)verifier).shouldVerify(module)) continue;
            this.dependencyValidator.validate(this.context, module, (Verifier)moduleAnnotationVerifier, this.getPluginFromVerifier((Verifier)moduleAnnotationVerifier));
            moduleAnnotationVerifier.verify(module);
        }
    }

    private void verifyModules(List<Module> modules, List<? extends Verifier> annotationVerifiers) throws AnnotationVerificationException {
        this.context.note("Validating Multi-module consistency");
        for (Verifier verifier : annotationVerifiers) {
            MultiModuleAnnotationVerifier moduleAnnotationVerifier;
            if (!(verifier instanceof MultiModuleAnnotationVerifier) || !(moduleAnnotationVerifier = (MultiModuleAnnotationVerifier)verifier).shouldVerify(modules)) continue;
            this.dependencyValidator.validate(this.context, modules, (Verifier)moduleAnnotationVerifier, this.getPluginFromVerifier((Verifier)moduleAnnotationVerifier));
            moduleAnnotationVerifier.verify(modules);
        }
    }

    private void printGenerationOrder(List<Generator> generators) {
        this.context.debug("The generators will be executed in the following order:");
        int i = 0;
        for (Generator generator : generators) {
            this.context.debug(Integer.toString(i) + ") " + generator.getClass().getName());
            ++i;
        }
    }

    private List<Generator> topologicalSort(List<Generator> moduleGenerators) {
        SimpleDirectedGraph generationGraph = new SimpleDirectedGraph(DefaultEdge.class);
        ArrayList<Generator> sortedModuleGenerators = new ArrayList<Generator>();
        for (Generator moduleGenerator : moduleGenerators) {
            generationGraph.addVertex((Object)moduleGenerator);
        }
        for (Generator consumer : generationGraph.vertexSet()) {
            for (Product product : consumer.consumes()) {
                for (Generator producer : generationGraph.vertexSet()) {
                    if (producer == consumer || !producer.produces().contains(product)) continue;
                    DefaultEdge addedEdge = (DefaultEdge)generationGraph.addEdge((Object)producer, (Object)consumer);
                    CycleDetector cycleDetector = new CycleDetector((DirectedGraph)generationGraph);
                    if (!cycleDetector.detectCycles()) continue;
                    generationGraph.removeEdge((Object)addedEdge);
                }
            }
        }
        TopologicalOrderIterator iterator = new TopologicalOrderIterator((DirectedGraph)generationGraph);
        while (iterator.hasNext()) {
            sortedModuleGenerators.add((Generator)iterator.next());
        }
        return sortedModuleGenerators;
    }

    private void createContext() {
        this.context = new AnnotationProcessorContext(this.processingEnv);
    }

    protected Context getContext() {
        return this.context;
    }
}

