/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.mule.devkit.apt.SimpleDependency;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.Dependency;
import org.mule.devkit.generation.api.MavenInformation;
import org.mule.devkit.generation.api.Plugin;
import org.mule.devkit.generation.api.Verifier;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;

public class DependencyValidator {
    public void validate(Context ctx, List<Module> modules, Verifier moduleAnnotationVerifier, Plugin plugin) throws AnnotationVerificationException {
        Validate.notEmpty(modules);
        this.validate(ctx, modules.get(0), moduleAnnotationVerifier, plugin);
    }

    public void validate(Context ctx, Module module, Verifier moduleAnnotationVerifier, Plugin plugin) throws AnnotationVerificationException {
        Validate.notNull((Object)ctx);
        Validate.notNull((Object)module);
        Validate.notNull((Object)plugin);
        RequiresMavenDependencies verifierAnnotation = moduleAnnotationVerifier.getClass().getAnnotation(RequiresMavenDependencies.class);
        RequiresMavenDependencies pluginAnnotation = plugin.getClass().getAnnotation(RequiresMavenDependencies.class);
        Set<Dependency> requiredDependencies = SimpleDependency.createDependencies(verifierAnnotation, pluginAnnotation);
        if (requiredDependencies == null || requiredDependencies.isEmpty()) {
            return;
        }
        MavenInformation mavenInformation = ctx.getMavenInformation();
        Validate.notNull((Object)mavenInformation);
        Set actualDependencies = mavenInformation.getDependencies();
        Validate.notNull((Object)actualDependencies);
        HashSet<Dependency> missingDependencies = new HashSet<Dependency>(requiredDependencies);
        missingDependencies.removeAll(Collections.unmodifiableSet(actualDependencies));
        if (!missingDependencies.isEmpty()) {
            throw new AnnotationVerificationException((Identifiable)module, this.getMissingDependenciesMessage(missingDependencies));
        }
    }

    String dependencyToPomDependency(Dependency dependency) {
        String template = "<dependency>\n   <artifactId>%s</artifactId>\n   <groupId>%s</groupId>\n   <version>%s</version>\n   <scope>%s</scope>\n</dependency>\n";
        return String.format(template, dependency.getArtifactId(), dependency.getGroupId(), dependency.getVersion(), dependency.getScope().toString());
    }

    private String getMissingDependenciesMessage(Set<Dependency> missingDependencies) {
        StringBuilder dependenciesString = new StringBuilder("Some dependencies need to be added to the pom.xml in order to complete the generate-sources lifecycle phase:\n\n");
        for (Dependency dependency : missingDependencies) {
            dependenciesString.append(this.dependencyToPomDependency(dependency));
        }
        return dependenciesString.toString();
    }
}

