/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.mule.api.annotations.Transformer;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;

public class TransformerValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return typeElement.isModuleOrConnector() && typeElement.hasMethodsAnnotatedWith(Transformer.class);
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        for (ExecutableElement method : typeElement.getMethodsAnnotatedWith(Transformer.class)) {
            if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
                throw new ValidationException((Element)method, "@Transformer must be a static method");
            }
            if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new ValidationException((Element)method, "@Transformer cannot be applied to a non-public method");
            }
            if (((Object)method.getReturnType()).toString().equals("void")) {
                throw new ValidationException((Element)method, "@Transformer cannot be void");
            }
            if (((Object)method.getReturnType()).toString().equals("java.lang.Object")) {
                throw new ValidationException((Element)method, "@Transformer cannot return java.lang.Object");
            }
            if (method.getParameters().size() != 1) {
                throw new ValidationException((Element)method, "@Transformer must receive exactly one argument.");
            }
            List<? extends AnnotationValue> sourceTypes = this.getSourceTypes(method);
            if (sourceTypes != null && !sourceTypes.isEmpty()) continue;
            throw new ValidationException((Element)method, "@Transformer must have at declare at least one element in the sourceTypes attribute");
        }
    }

    private List<? extends AnnotationValue> getSourceTypes(ExecutableElement method) {
        String transformerAnnotationName = Transformer.class.getName();
        List<? extends AnnotationMirror> annotationMirrors = method.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!transformerAnnotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"sourceTypes".equals(entry.getKey().getSimpleName().toString())) continue;
                return (List)entry.getValue().getValue();
            }
        }
        return null;
    }
}

