/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import org.mule.api.annotations.lifecycle.Start;
import org.mule.api.annotations.lifecycle.Stop;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;

public class LifecycleValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return true;
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        this.check(typeElement, PostConstruct.class);
        this.check(typeElement, Start.class);
        this.check(typeElement, Stop.class);
        this.check(typeElement, PreDestroy.class);
    }

    private void check(DevKitTypeElement typeElement, Class<? extends Annotation> annotation) throws ValidationException {
        List<ExecutableElement> methods = typeElement.getMethodsAnnotatedWith(annotation);
        if (methods.isEmpty()) {
            return;
        }
        if (methods.size() > 1) {
            throw new ValidationException((Element)typeElement, "Cannot have more than method annotated with " + annotation.getSimpleName());
        }
        ExecutableElement method = methods.get(0);
        if (!method.getParameters().isEmpty()) {
            throw new ValidationException((Element)typeElement, "A method annotated with " + annotation.getSimpleName() + " cannot receive any paramters");
        }
        if (method.getReturnType().getKind() != TypeKind.VOID) {
            throw new ValidationException((Element)typeElement, "A method annotated with " + annotation.getSimpleName() + " can only return void");
        }
        if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ValidationException((Element)method, "A method annotated with " + annotation.getSimpleName() + " cannot be static");
        }
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ValidationException((Element)method, "A method annotated with " + annotation.getSimpleName() + " can only be public");
        }
    }
}

