/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.utils;

import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import org.apache.commons.lang.StringUtils;
import org.mule.devkit.generation.DevKitTypeElement;

public class JavaDocUtils {
    private Elements elements;

    public JavaDocUtils(Elements elements) {
        this.elements = elements;
    }

    public String getSummary(Element element) {
        String comment;
        if (element instanceof DevKitTypeElement) {
            element = ((DevKitTypeElement)element).getInnerTypeElement();
        }
        if ((comment = this.elements.getDocComment(element)) == null || StringUtils.isBlank((String)comment)) {
            return null;
        }
        comment = comment.trim();
        String parsedComment = "";
        boolean tagsBegan = false;
        StringTokenizer st = new StringTokenizer(comment, "\n\r");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken().trim();
            if (nextToken.startsWith("@")) {
                tagsBegan = true;
            }
            if (tagsBegan) continue;
            parsedComment = parsedComment + nextToken + "\n";
        }
        String strippedComments = "";
        boolean insideTag = false;
        for (int i = 0; i < parsedComment.length(); ++i) {
            if (parsedComment.charAt(i) == '{' && parsedComment.charAt(i + 1) == '@') {
                insideTag = true;
                continue;
            }
            if (parsedComment.charAt(i) == '}') {
                insideTag = false;
                continue;
            }
            if (insideTag) continue;
            strippedComments = strippedComments + parsedComment.charAt(i);
        }
        strippedComments = strippedComments.trim();
        while (strippedComments.length() > 0 && strippedComments.charAt(strippedComments.length() - 1) == '\n') {
            strippedComments = StringUtils.chomp((String)strippedComments);
        }
        return strippedComments;
    }

    public boolean hasTag(String tagName, Element element) {
        String comment = this.elements.getDocComment(element);
        if (StringUtils.isBlank((String)comment)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(comment.trim(), "\n\r");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken().trim();
            if (nextToken.startsWith("@" + tagName)) {
                String tagContent = StringUtils.difference((String)("@" + tagName), (String)nextToken);
                return !StringUtils.isBlank((String)tagContent);
            }
            if (!nextToken.startsWith("{@" + tagName)) continue;
            return true;
        }
        return false;
    }

    public String getTagContent(String tagName, Element element) {
        String comment = this.elements.getDocComment(element);
        if (StringUtils.isBlank((String)comment)) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(comment.trim(), "\n\r");
        boolean insideTag = false;
        StringBuilder tagContent = new StringBuilder();
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken().trim();
            if (nextToken.startsWith("@" + tagName)) {
                return StringUtils.difference((String)("@" + tagName), (String)nextToken).trim();
            }
            if (nextToken.startsWith("{@" + tagName)) {
                if (nextToken.endsWith("}")) {
                    return StringUtils.difference((String)("{@" + tagName), (String)nextToken).replaceAll("}", "").trim();
                }
                tagContent.append(StringUtils.difference((String)("{@" + tagName), (String)nextToken).replaceAll("}", "").trim());
                insideTag = true;
                continue;
            }
            if (!insideTag) continue;
            if (nextToken.endsWith("}")) {
                tagContent.append(' ').append(nextToken.replaceAll("}", ""));
                insideTag = false;
                continue;
            }
            tagContent.append(' ').append(nextToken);
        }
        return tagContent.toString();
    }

    public String getParameterSummary(String paramName, Element element) {
        String comment = this.elements.getDocComment(element);
        if (StringUtils.isBlank((String)comment)) {
            return null;
        }
        comment = comment.trim();
        StringBuilder parameterCommentBuilder = new StringBuilder();
        boolean insideParameter = false;
        StringTokenizer st = new StringTokenizer(comment, "\n\r");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken().trim();
            if (nextToken.startsWith("@param " + paramName + " ") || nextToken.equals("@param " + paramName)) {
                insideParameter = true;
            } else if (nextToken.startsWith("@")) {
                insideParameter = false;
            }
            if (!insideParameter) continue;
            parameterCommentBuilder.append(nextToken).append(" ");
        }
        int startIndex = 7 + paramName.length() + 1;
        if (parameterCommentBuilder.length() < startIndex) {
            return null;
        }
        String parameterComment = parameterCommentBuilder.substring(startIndex);
        StringBuilder strippedCommentBuilder = new StringBuilder();
        boolean insideTag = false;
        for (int i = 0; i < parameterComment.length(); ++i) {
            if (parameterComment.charAt(i) == '{' && parameterComment.charAt(i + 1) == '@') {
                insideTag = true;
                continue;
            }
            if (parameterComment.charAt(i) == '}') {
                insideTag = false;
                continue;
            }
            if (insideTag) continue;
            strippedCommentBuilder.append(parameterComment.charAt(i));
        }
        String strippedComment = strippedCommentBuilder.toString().trim();
        while (strippedComment.length() > 0 && strippedComment.charAt(strippedComment.length() - 1) == '\n') {
            strippedComment = StringUtils.chomp((String)strippedComment);
        }
        return strippedComment;
    }
}

