/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.transfomer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.lang.model.element.TypeElement;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class StringToDateTransformerGenerator
extends AbstractMessageGenerator {
    private static final String PATTERN = "yyyy-MM-dd'T'hh:mm:ss";
    private static final String SIMPLE_DATE_FORMAT_FIELD_NAME = "SIMPLE_DATE_FORMAT";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasProcessorMethodWithParameter(Date.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        DefinedClass transformerClass = this.getTransformerClass(typeElement);
        this.context.note("Generating String to Date transformer as " + transformerClass.fullName());
        FieldVariable muleContext = this.generateFieldForMuleContext(transformerClass);
        FieldVariable simpleDateFormat = this.generateSimpleDateFormatField(transformerClass);
        FieldVariable weighting = transformerClass.field(4, (Type)this.context.getCodeModel().INT, "weighting", (Expression)this.ref(DiscoverableTransformer.class).staticRef("DEFAULT_PRIORITY_WEIGHTING"));
        this.generateConstructor(transformerClass);
        this.generateSetMuleContextMethod(transformerClass, muleContext);
        this.generateDoTransform(transformerClass, simpleDateFormat);
        this.generateGetPriorityWeighting(transformerClass, weighting);
        this.generateSetPriorityWeighting(transformerClass, weighting);
        this.context.registerAtBoot(transformerClass);
    }

    private FieldVariable generateSimpleDateFormatField(DefinedClass transformerClass) {
        return FieldBuilder.newConstantFieldBuilder((DefinedClass)transformerClass).type(SimpleDateFormat.class).name(SIMPLE_DATE_FORMAT_FIELD_NAME).initialValue((Expression)ExpressionFactory._new((TypeReference)this.ref(SimpleDateFormat.class)).arg(PATTERN)).build();
    }

    private void generateSetPriorityWeighting(DefinedClass transformerClass, FieldVariable weighting) {
        Method setPriorityWeighting = transformerClass.method(1, (Type)this.context.getCodeModel().VOID, "setPriorityWeighting");
        Variable localWeighting = setPriorityWeighting.param((Type)this.context.getCodeModel().INT, "weighting");
        setPriorityWeighting.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)weighting), (Expression)localWeighting);
    }

    private void generateGetPriorityWeighting(DefinedClass transformerClass, FieldVariable weighting) {
        Method getPriorityWeighting = transformerClass.method(1, (Type)this.context.getCodeModel().INT, "getPriorityWeighting");
        getPriorityWeighting.body()._return((Expression)weighting);
    }

    private void generateDoTransform(DefinedClass definedClass, FieldVariable simpleDateFormat) {
        Method doTransform = definedClass.method(2, (Type)this.ref(Object.class), "doTransform");
        doTransform._throws(TransformerException.class);
        Variable src = doTransform.param((Type)this.ref(Object.class), "src");
        doTransform.param((Type)this.ref(String.class), "encoding");
        TryStatement tryStatement = doTransform.body()._try();
        tryStatement.body()._return((Expression)simpleDateFormat.invoke("parse").arg((Expression)src.invoke("toString")));
        CatchBlock catchBlock = tryStatement._catch(this.ref(ParseException.class));
        Variable exceptionCaught = catchBlock.param("e");
        Invocation errorMessage = this.ref(MessageFactory.class).staticInvoke("createStaticMessage").arg((Expression)this.ref(String.class).staticInvoke("format").arg("Could not parse %s using the format %s").arg((Expression)src).arg((Expression)simpleDateFormat.invoke("toPattern")));
        catchBlock.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(TransformerException.class)).arg((Expression)errorMessage).arg(ExpressionFactory._this()).arg((Expression)exceptionCaught));
    }

    private void generateConstructor(DefinedClass transformerClass) {
        Method constructor = transformerClass.constructor(1);
        this.registerSourceTypes(constructor);
        this.registerDestinationType(constructor, this.ref(Date.class));
        constructor.body().invoke("setName").arg(transformerClass.name());
    }

    private void registerDestinationType(Method constructor, TypeReference clazz) {
        Invocation setReturnClass = constructor.body().invoke("setReturnClass");
        setReturnClass.arg(ExpressionFactory.dotclass((TypeReference)clazz));
    }

    private void registerSourceTypes(Method constructor) {
        Invocation registerSourceType = constructor.body().invoke("registerSourceType");
        registerSourceType.arg((Expression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(this.ref(String.class).boxify().dotclass()));
    }

    private DefinedClass getTransformerClass(TypeElement typeElement) {
        String transformerClassName = this.context.getNameUtils().generateClassNameInPackage(typeElement, "StringToDateTransformer");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(transformerClassName) + ".transformers");
        return pkg._class(this.context.getNameUtils().getClassName(transformerClassName), AbstractTransformer.class, new Class[]{DiscoverableTransformer.class, MuleContextAware.class});
    }
}

