/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio.editor;

import java.util.Comparator;
import javax.lang.model.element.VariableElement;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.display.FriendlyName;
import org.mule.api.annotations.display.Placement;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.utils.TypeMirrorUtils;

public class VariableComparator
implements Comparator<VariableElement> {
    private static final int VARIABLE1_FIRST = -1;
    private static final int VARIABLE2_FIRST = 1;
    private TypeMirrorUtils typeMirrorUtils;

    public VariableComparator(GeneratorContext context) {
        this.typeMirrorUtils = context.getTypeMirrorUtils();
    }

    @Override
    public int compare(VariableElement variable1, VariableElement variable2) {
        Placement placementVar2;
        Placement placementVar1 = variable1.getAnnotation(Placement.class);
        if (!this.sameGroup(placementVar1, placementVar2 = variable2.getAnnotation(Placement.class))) {
            return 0;
        }
        if (placementVar1 != null && placementVar2 != null) {
            return new Integer(placementVar1.order()).compareTo(placementVar2.order());
        }
        if (placementVar1 != null) {
            return new Integer(placementVar1.order()).compareTo(1);
        }
        if (placementVar2 != null) {
            return new Integer(1).compareTo(placementVar2.order());
        }
        if (this.bothOfSameType(variable1, variable2)) {
            return this.compareByName(variable1, variable2);
        }
        if (this.typeMirrorUtils.isCollection(variable1)) {
            return 1;
        }
        if (this.typeMirrorUtils.isCollection(variable2)) {
            return -1;
        }
        if (this.typeMirrorUtils.isBoolean(variable1)) {
            return 1;
        }
        if (this.typeMirrorUtils.isBoolean(variable2)) {
            return -1;
        }
        if (this.typeMirrorUtils.isEnum(variable1)) {
            return 1;
        }
        if (this.typeMirrorUtils.isEnum(variable2)) {
            return -1;
        }
        return 0;
    }

    private boolean sameGroup(Placement placementVar1, Placement placementVar2) {
        String group1 = this.extractGroup(placementVar1);
        String group2 = this.extractGroup(placementVar2);
        return group1.equals(group2);
    }

    private String extractGroup(Placement placement) {
        if (placement != null && StringUtils.isNotBlank((String)placement.group())) {
            return placement.group();
        }
        return "General";
    }

    private boolean bothOfSameType(VariableElement variable1, VariableElement variable2) {
        return this.typeMirrorUtils.isString(variable1) && this.typeMirrorUtils.isString(variable2) || this.typeMirrorUtils.isInteger(variable1) && this.typeMirrorUtils.isInteger(variable2) || this.typeMirrorUtils.isEnum(variable1) && this.typeMirrorUtils.isEnum(variable2) || this.typeMirrorUtils.isBoolean(variable1) && this.typeMirrorUtils.isBoolean(variable2) || this.typeMirrorUtils.isCollection(variable1) && this.typeMirrorUtils.isCollection(variable2);
    }

    private int compareByName(VariableElement variable1, VariableElement variable2) {
        String name1 = this.extractName(variable1);
        String name2 = this.extractName(variable2);
        return name1.compareTo(name2);
    }

    private String extractName(VariableElement variableElement) {
        if (variableElement.getAnnotation(FriendlyName.class) != null) {
            return variableElement.getAnnotation(FriendlyName.class).value();
        }
        return variableElement.getSimpleName().toString();
    }
}

