/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio.editor;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.WordUtils;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.display.FriendlyName;
import org.mule.api.annotations.display.Icons;
import org.mule.api.annotations.display.Password;
import org.mule.api.annotations.display.Summary;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.spring.SchemaTypeConversion;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Booleantype;
import org.mule.devkit.model.studio.EncodingType;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.FlowRefType;
import org.mule.devkit.model.studio.IntegerType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.model.studio.ObjectListAttributeType;
import org.mule.devkit.model.studio.PasswordType;
import org.mule.devkit.model.studio.StringAttributeType;
import org.mule.devkit.model.studio.StringListAttributeType;
import org.mule.devkit.model.studio.StringMapAttributeType;
import org.mule.devkit.model.studio.TextType;
import org.mule.devkit.model.studio.UrlType;
import org.mule.devkit.utils.JavaDocUtils;
import org.mule.devkit.utils.NameUtils;
import org.mule.devkit.utils.TypeMirrorUtils;
import org.mule.util.StringUtils;

public class MuleStudioUtils {
    private static final String IMAGE_PREFIX = "icons/large/";
    private static final String ICON_PREFIX = "icons/small/";
    private NameUtils nameUtils;
    private JavaDocUtils javaDocUtils;
    private TypeMirrorUtils typeMirrorUtils;

    public MuleStudioUtils(GeneratorContext context) {
        this.nameUtils = context.getNameUtils();
        this.javaDocUtils = context.getJavaDocUtils();
        this.typeMirrorUtils = context.getTypeMirrorUtils();
    }

    public String formatCaption(String caption) {
        return WordUtils.capitalizeFully((String)caption);
    }

    public String formatDescription(String description) {
        if (Character.isLowerCase(description.charAt(0))) {
            description = StringUtils.capitalize((String)description);
        }
        if (!description.endsWith(".")) {
            description = description + '.';
        }
        return description.replaceAll("\\<.*?\\>", "");
    }

    public String getConnectorImage(DevKitTypeElement typeElement) {
        Icons icons = typeElement.getAnnotation(Icons.class);
        String image = icons != null ? icons.connectorLarge() : String.format("../../../icons/%s-connector-48x32.png", typeElement.name());
        if (image.contains("/")) {
            image = image.substring(image.lastIndexOf("/") + 1);
        }
        return IMAGE_PREFIX + image;
    }

    public String getConnectorIcon(DevKitTypeElement typeElement) {
        Icons icons = typeElement.getAnnotation(Icons.class);
        String icon = icons != null ? icons.connectorSmall() : String.format("../../../icons/%s-connector-24x16.png", typeElement.name());
        if (icon.contains("/")) {
            icon = icon.substring(icon.lastIndexOf("/") + 1);
        }
        return ICON_PREFIX + icon;
    }

    public String getEndpointImage(DevKitTypeElement typeElement) {
        Icons icons = typeElement.getAnnotation(Icons.class);
        String image = icons != null ? icons.endpointLarge() : String.format("../../../icons/%s-endpoint-48x32.png", typeElement.name());
        if (image.contains("/")) {
            image = image.substring(image.lastIndexOf("/") + 1);
        }
        return IMAGE_PREFIX + image;
    }

    public String getEndpointIcon(DevKitTypeElement typeElement) {
        Icons icons = typeElement.getAnnotation(Icons.class);
        String icon = icons != null ? icons.endpointSmall() : String.format("../../../icons/%s-endpoint-24x16.png", typeElement.name());
        if (icon.contains("/")) {
            icon = icon.substring(icon.lastIndexOf("/") + 1);
        }
        return ICON_PREFIX + icon;
    }

    public String getTransformerImage(DevKitTypeElement typeElement) {
        Icons icons = typeElement.getAnnotation(Icons.class);
        String image = icons != null ? icons.transformerLarge() : String.format("../../../icons/%s-transformer-48x32.png", typeElement.name());
        if (image.contains("/")) {
            image = image.substring(image.lastIndexOf("/") + 1);
        }
        return IMAGE_PREFIX + image;
    }

    public String getTransformerIcon(DevKitTypeElement typeElement) {
        Icons icons = typeElement.getAnnotation(Icons.class);
        String icon = icons != null ? icons.transformerSmall() : String.format("../../../icons/%s-transformer-24x16.png", typeElement.name());
        if (icon.contains("/")) {
            icon = icon.substring(icon.lastIndexOf("/") + 1);
        }
        return ICON_PREFIX + icon;
    }

    public String getGlobalRefId(String moduleName) {
        return "abstract" + StringUtils.capitalize((String)moduleName) + "ConnectorGeneric";
    }

    public List<JAXBElement<? extends AttributeType>> createJAXBElements(List<AttributeType> attributeTypes) {
        ArrayList<JAXBElement<? extends AttributeType>> jaxbElements = new ArrayList<JAXBElement<? extends AttributeType>>();
        for (AttributeType attributeType : attributeTypes) {
            JAXBElement<? extends AttributeType> jaxbElement = this.createJAXBElement(attributeType);
            if (jaxbElement == null) continue;
            jaxbElements.add(jaxbElement);
        }
        return jaxbElements;
    }

    public JAXBElement<? extends AttributeType> createJAXBElement(AttributeType attributeType) {
        ObjectFactory objectFactory = new ObjectFactory();
        if (attributeType instanceof PasswordType) {
            return objectFactory.createGroupPassword((PasswordType)attributeType);
        }
        if (attributeType instanceof UrlType) {
            return objectFactory.createGroupUrl((UrlType)attributeType);
        }
        if (attributeType instanceof StringAttributeType) {
            return objectFactory.createGroupString((StringAttributeType)attributeType);
        }
        if (attributeType instanceof IntegerType) {
            return objectFactory.createGroupInteger((IntegerType)attributeType);
        }
        if (attributeType instanceof EnumType) {
            return objectFactory.createGroupEnum((EnumType)attributeType);
        }
        if (attributeType instanceof Booleantype) {
            return objectFactory.createGroupBoolean((Booleantype)attributeType);
        }
        if (attributeType instanceof TextType) {
            return objectFactory.createGroupText((TextType)attributeType);
        }
        if (attributeType instanceof FlowRefType) {
            return objectFactory.createGroupFlowRef((FlowRefType)attributeType);
        }
        if (attributeType instanceof EncodingType) {
            return objectFactory.createGroupEncoding((EncodingType)attributeType);
        }
        if (attributeType instanceof NestedElementReference) {
            return objectFactory.createNestedElementTypeChildElement((NestedElementReference)attributeType);
        }
        if (attributeType instanceof ObjectListAttributeType) {
            return objectFactory.createGroupObjectList((ObjectListAttributeType)attributeType);
        }
        if (attributeType instanceof StringMapAttributeType) {
            return objectFactory.createGroupObjectList((StringMapAttributeType)attributeType);
        }
        if (attributeType instanceof StringListAttributeType) {
            return objectFactory.createGroupObjectList((StringListAttributeType)attributeType);
        }
        return null;
    }

    public AttributeType createAttributeTypeIgnoreEnumsAndCollections(Element element) {
        if (this.skipAttributeTypeGeneration(element)) {
            return null;
        }
        if (SchemaTypeConversion.isSupported(((Object)element.asType()).toString())) {
            return this.createAttributeTypeOfSupportedType(element);
        }
        if (this.typeMirrorUtils.isHttpCallback(element)) {
            FlowRefType flowRefType = new FlowRefType();
            flowRefType.setSupportFlow(Boolean.valueOf(true));
            flowRefType.setSupportSubflow(Boolean.valueOf(true));
            return flowRefType;
        }
        return new StringAttributeType();
    }

    private boolean skipAttributeTypeGeneration(Element element) {
        return this.typeMirrorUtils.isCollection(element.asType()) || this.typeMirrorUtils.isEnum(element.asType()) || this.typeMirrorUtils.ignoreParameter(element);
    }

    private AttributeType createAttributeTypeOfSupportedType(Element element) {
        if (element.getAnnotation(Password.class) != null) {
            return new PasswordType();
        }
        if (this.typeMirrorUtils.isString(element) || this.typeMirrorUtils.isDate(element) || this.typeMirrorUtils.isChar(element) || this.typeMirrorUtils.isFloat(element) || this.typeMirrorUtils.isDouble(element)) {
            return new StringAttributeType();
        }
        if (this.typeMirrorUtils.isBoolean(element)) {
            Booleantype booleantype = new Booleantype();
            booleantype.setSupportsExpressions(Boolean.valueOf(true));
            return booleantype;
        }
        if (this.typeMirrorUtils.isInteger(element) || this.typeMirrorUtils.isLong(element)) {
            IntegerType integerType = new IntegerType();
            integerType.setMin(0);
            integerType.setStep(1);
            return integerType;
        }
        if (this.typeMirrorUtils.isURL(element)) {
            return new UrlType();
        }
        throw new RuntimeException("Failed to create Studio XML, type not recognized: type=" + ((Object)element.asType()).toString() + " name=" + element.getSimpleName().toString());
    }

    public void setAttributeTypeInfo(VariableElement variableElement, AttributeType attributeType) {
        String parameterName = variableElement.getSimpleName().toString();
        attributeType.setCaption(this.getFormattedCaption(variableElement));
        attributeType.setDescription(this.getFormattedDescription(variableElement));
        if (attributeType instanceof StringAttributeType && !SchemaTypeConversion.isSupported(((Object)variableElement.asType()).toString())) {
            attributeType.setName(parameterName + "-ref");
        } else if (attributeType instanceof FlowRefType) {
            attributeType.setName(this.nameUtils.uncamel(parameterName) + "-flow-ref");
        } else {
            attributeType.setName(parameterName);
        }
        attributeType.setRequired(Boolean.valueOf(variableElement.getAnnotation(Optional.class) == null));
        attributeType.setJavaType(this.typeMirrorUtils.getJavaType(variableElement));
        this.setDefaultValueIfAvailable(variableElement, attributeType);
    }

    public void setDefaultValueIfAvailable(VariableElement variableElement, AttributeType parameter) {
        Default annotation = variableElement.getAnnotation(Default.class);
        if (annotation != null) {
            if (parameter instanceof Booleantype) {
                ((Booleantype)parameter).setDefaultValue(Boolean.valueOf(annotation.value()));
            } else if (parameter instanceof IntegerType) {
                ((IntegerType)parameter).setDefaultValue(Integer.valueOf(annotation.value()));
            } else if (parameter instanceof StringAttributeType) {
                ((StringAttributeType)parameter).setDefaultValue(annotation.value());
            } else if (parameter instanceof EnumType) {
                ((EnumType)parameter).setDefaultValue(annotation.value());
            }
        }
    }

    public String getLocalId(ExecutableElement executableElement, VariableElement variableElement) {
        if (executableElement != null) {
            return this.nameUtils.uncamel(executableElement.getSimpleName().toString()) + '-' + this.nameUtils.uncamel(variableElement.getSimpleName().toString());
        }
        return "configurable-" + this.nameUtils.uncamel(variableElement.getSimpleName().toString());
    }

    public String getLocalId(ExecutableElement executableElement) {
        Processor processor = executableElement.getAnnotation(Processor.class);
        String localId = processor != null && StringUtils.isNotBlank((String)processor.name()) ? processor.name() : executableElement.getSimpleName().toString();
        return this.nameUtils.uncamel(localId);
    }

    public String getFormattedDescription(VariableElement element) {
        Summary description = element.getAnnotation(Summary.class);
        if (description != null && StringUtils.isNotBlank((String)description.value())) {
            return this.formatDescription(description.value());
        }
        if (element.getKind() == ElementKind.PARAMETER) {
            Element executableElement = element.getEnclosingElement();
            return this.formatDescription(this.javaDocUtils.getParameterSummary(element.getSimpleName().toString(), executableElement));
        }
        return this.formatDescription(this.javaDocUtils.getSummary(element));
    }

    public String getFormattedDescription(DevKitTypeElement typeElement) {
        if (StringUtils.isNotBlank((String)typeElement.description())) {
            return typeElement.description();
        }
        return this.formatDescription(this.javaDocUtils.getSummary(typeElement));
    }

    public String getFormattedCaption(DevKitTypeElement typeElement) {
        if (StringUtils.isNotBlank((String)typeElement.friendlyName())) {
            return typeElement.friendlyName();
        }
        return this.formatCaption(typeElement.name().replaceAll("-", " "));
    }

    public String getFormattedCaption(ExecutableElement element) {
        return this.formatCaption(this.getFriendlyName(element));
    }

    public String getFormattedCaption(VariableElement element) {
        FriendlyName caption = element.getAnnotation(FriendlyName.class);
        if (caption != null && StringUtils.isNotBlank((String)caption.value())) {
            return caption.value();
        }
        String friendlyName = this.nameUtils.friendlyNameFromCamelCase(element.getSimpleName().toString());
        if (this.typeMirrorUtils.isHttpCallback(element)) {
            return this.formatCaption(friendlyName + " Flow");
        }
        if (!this.isKnownType(element)) {
            return this.formatCaption(friendlyName + " Reference");
        }
        return this.formatCaption(friendlyName);
    }

    public String getFriendlyName(ExecutableElement element) {
        Processor processor = element.getAnnotation(Processor.class);
        if (processor != null && StringUtils.isNotBlank((String)processor.friendlyName())) {
            return processor.friendlyName();
        }
        Source source = element.getAnnotation(Source.class);
        if (source != null && StringUtils.isNotBlank((String)source.friendlyName())) {
            return source.friendlyName();
        }
        return this.nameUtils.friendlyNameFromCamelCase(element.getSimpleName().toString());
    }

    public boolean isKnownType(VariableElement variable) {
        return this.typeMirrorUtils.isString(variable) || this.typeMirrorUtils.isChar(variable) || this.typeMirrorUtils.isDate(variable) || this.typeMirrorUtils.isDouble(variable) || this.typeMirrorUtils.isFloat(variable) || this.typeMirrorUtils.isLong(variable) || this.typeMirrorUtils.isHttpCallback(variable) || this.typeMirrorUtils.isInteger(variable) || this.typeMirrorUtils.isBoolean(variable) || this.typeMirrorUtils.isEnum(variable) || this.typeMirrorUtils.isCollection(variable) || this.typeMirrorUtils.isURL(variable);
    }

    public String getUrl(DevKitTypeElement typeElement) {
        return "http://www.mulesoft.org/schema/mule/" + typeElement.name() + '/';
    }
}

