/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.mule.api.annotations.Transformer;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.mule.studio.editor.GlobalTypeBuilder;
import org.mule.devkit.generation.mule.studio.editor.MethodComparator;
import org.mule.devkit.model.studio.AttributeCategory;

public class GlobalTransformerTypeOperationsBuilder
extends GlobalTypeBuilder {
    public GlobalTransformerTypeOperationsBuilder(GeneratorContext context, DevKitTypeElement typeElement) {
        super(context, typeElement);
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(this.helper.formatCaption("General"));
        attributeCategory.setDescription(this.helper.formatDescription("General"));
        attributeCategory.getGroup().add(this.createGroupWithModeSwitch(this.getTransformerMethodsSorted()));
        ArrayList<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>();
        attributeCategories.add(attributeCategory);
        return attributeCategories;
    }

    private List<ExecutableElement> getTransformerMethodsSorted() {
        List<ExecutableElement> transformer = this.typeElement.getMethodsAnnotatedWith(Transformer.class);
        Collections.sort(transformer, new MethodComparator());
        return transformer;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return this.helper.formatDescription("Global transformer");
    }

    @Override
    protected String getExtendsBasedOnType() {
        return "http://www.mulesoft.org/schema/mule/" + this.typeElement.name() + '/' + "abstractTransformer";
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return "global-transformer";
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.typeElement);
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return "Identifies the transformer so that other elements can reference it.";
    }

    @Override
    protected String getImage() {
        return this.helper.getTransformerImage(this.typeElement);
    }

    @Override
    protected String getIcon() {
        return this.helper.getTransformerIcon(this.typeElement);
    }
}

