/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MuleStudioSiteXmlGenerator
extends AbstractMessageGenerator {
    protected static final String SEPARATOR = File.separator;
    public static final String SITE_XML = "site.xml";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return !this.context.hasOption("skipStudioPluginPackage");
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element site = document.createElement("site");
            document.appendChild(site);
            Element feature = document.createElement("feature");
            feature.setAttribute("url", "features" + SEPARATOR + "org.mule.tooling.ui.extension." + typeElement.name() + "_%VERSION%" + ".jar");
            feature.setAttribute("id", "org.mule.tooling.ui.extension." + typeElement.name());
            feature.setAttribute("version", "%VERSION%");
            Element category = document.createElement("category");
            category.setAttribute("name", "%CATEGORY%");
            feature.appendChild(category);
            Element categoryDef = document.createElement("category-def");
            categoryDef.setAttribute("name", "%CATEGORY%");
            categoryDef.setAttribute("label", "%CATEGORY%");
            site.appendChild(feature);
            site.appendChild(categoryDef);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(this.context.getCodeModel().getCodeWriter().openBinary(null, SITE_XML));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new GenerationException("Error generating Mule Studio plugin.xml", e);
        }
    }
}

